/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.io.File;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.util.Strings;

public class JUtils {
    public static long generateSerialVersionUID(PMessageDescriptor<?, ?> type) {
        String string = type.getVariant().getName() + " " + type.getQualifiedName();
        long hash = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            hash = 4909L * hash + 7919L * (long)string.charAt(i);
        }
        return hash;
    }

    public static String getClassName(PDeclaredDescriptor<?> type) {
        return JUtils.camelCase("", type.getName());
    }

    public static String getClassName(PService service) {
        return JUtils.camelCase("", service.getName());
    }

    public static String getJavaPackage(CProgram document) throws GeneratorException {
        String javaPackage = document.getNamespaceForLanguage("java");
        if (javaPackage == null) {
            throw new GeneratorException("No java namespace for thrift package " + document.getProgramName());
        }
        return javaPackage;
    }

    public static String getPackageClassPath(String javaPackage) throws GeneratorException {
        Object[] parts = javaPackage.split("[.]");
        return Strings.join((String)File.separator, (Object[])parts);
    }

    public static String getHazelcastFactory(PMessageDescriptor<?, ?> type) {
        return JUtils.camelCase("", type.getProgramName()).concat("_Factory");
    }

    public static String getHazelcastClassId(PMessageDescriptor<?, ?> type) {
        return JUtils.getHazelcastClassId(type.getName());
    }

    public static String getHazelcastClassId(String name) {
        return JUtils.macroCase(name).concat("_ID");
    }

    public static String camelCase(String name) {
        StringBuilder builder = new StringBuilder();
        String[] parts = name.split("[-._]");
        boolean first = true;
        int skipped = 0;
        for (String part : parts) {
            if (part.isEmpty()) {
                ++skipped;
                continue;
            }
            if (first) {
                first = false;
                builder.append(part);
            } else if (skipped > 1) {
                builder.append('_');
                builder.append(part);
            } else {
                builder.append(Strings.capitalize((String)part));
            }
            skipped = 0;
        }
        return builder.toString();
    }

    public static String camelCase(String prefix, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        String[] parts = name.split("[-._]");
        int skipped = 0;
        for (String part : parts) {
            if (part.isEmpty()) {
                ++skipped;
                continue;
            }
            if (skipped > 1) {
                builder.append('_');
                builder.append(part);
            } else {
                builder.append(Strings.capitalize((String)part));
            }
            skipped = 0;
        }
        return builder.toString();
    }

    public static String macroCase(String name) {
        String result = name.replaceAll("([A-Z])", "_$1");
        while (result.startsWith("_")) {
            result = result.substring(1, result.length());
        }
        return result.toUpperCase();
    }

    public static String enumConst(PEnumValue value) {
        return Strings.c_case((String)"", (String)value.getName()).toUpperCase();
    }
}

