/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.shared;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashSet;
import java.util.List;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.util.io.IndentedPrintWriter;

public abstract class BaseMessageFormatter {
    protected final IndentedPrintWriter writer;
    private final JHelper helper;
    private final List<MessageMemberFormatter> formatters;
    private final boolean inner;
    private final boolean makeProtected;

    public BaseMessageFormatter(boolean inner, boolean makeProtected, IndentedPrintWriter writer, JHelper helper, List<MessageMemberFormatter> formatters) {
        this.inner = inner;
        this.makeProtected = makeProtected;
        this.writer = writer;
        this.helper = helper;
        this.formatters = ImmutableList.copyOf(formatters);
    }

    protected void appendClassExtends(JMessage<?> message) {
        if (message.isException()) {
            this.writer.appendln((CharSequence)("extends " + message.exceptionBaseClass()));
        }
    }

    protected abstract String getClassName(JMessage<?> var1);

    public void appendMessageClass(PMessageDescriptor<?, ?> descriptor) throws GeneratorException {
        CAnnotatedDescriptor annotatedDescriptor;
        JMessage message = new JMessage(descriptor, this.helper);
        if (message.descriptor() instanceof CAnnotatedDescriptor && (annotatedDescriptor = (CAnnotatedDescriptor)message.descriptor()).getDocumentation() != null) {
            new BlockCommentBuilder(this.writer).comment(annotatedDescriptor.getDocumentation()).finish();
        }
        this.formatters.forEach(f -> f.appendClassAnnotations(message));
        this.writer.formatln("%s %sclass %s", new Object[]{this.makeProtected ? "protected" : "public", this.inner ? "static " : "", this.getClassName(message)}).begin().begin();
        this.appendClassExtends(message);
        this.writer.end();
        LinkedHashSet impl = new LinkedHashSet();
        this.formatters.forEach(f -> impl.addAll(f.getExtraImplements(message)));
        if (impl.size() > 0) {
            this.writer.formatln("    implements ", new Object[0]).begin("               ");
            boolean first = true;
            for (String i : impl) {
                if (first) {
                    first = false;
                } else {
                    this.writer.append(',').appendln();
                }
                this.writer.append((CharSequence)i);
            }
            this.writer.end();
        }
        this.writer.append((CharSequence)" {");
        this.formatters.forEach(f -> f.appendConstants(message));
        this.formatters.forEach(f -> f.appendFields(message));
        this.formatters.forEach(f -> f.appendConstructors(message));
        this.formatters.forEach(f -> f.appendMethods(message));
        this.formatters.forEach(f -> f.appendExtraProperties(message));
        this.writer.end().appendln('}');
    }
}

