/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.io.IndentedPrintWriter;

public class CommonOverridesFormatter
implements MessageMemberFormatter {
    protected final IndentedPrintWriter writer;

    public CommonOverridesFormatter(IndentedPrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public Collection<String> getExtraImplements(JMessage<?> message) throws GeneratorException {
        LinkedList<String> impl = new LinkedList<String>();
        impl.add(Comparable.class.getSimpleName() + "<" + message.instanceType() + ">");
        if (!message.isException()) {
            impl.add(Serializable.class.getName());
        }
        if (!Strings.isNullOrEmpty((String)message.extraImplements())) {
            String[] extras = message.extraImplements().split("[,]");
            Arrays.stream(extras).map(String::trim).forEachOrdered(impl::add);
        }
        return impl;
    }

    protected String caseFieldConstant(JField field) {
        return field.fieldEnum();
    }

    @Override
    public void appendFields(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"private volatile int tHashCode;").newline();
    }

    public void appendMethods(JMessage message) {
        this.appendEquals(message);
        this.appendHashCode(message);
        this.appendToString(message);
        this.appendAsString(message);
        this.appendCompareTo(message);
    }

    private void appendEquals(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean equals(Object o) {").begin().appendln((CharSequence)"if (o == this) return true;").appendln((CharSequence)"if (o == null || !o.getClass().equals(getClass())) return false;");
        if (message.numericalOrderFields().size() > 0) {
            boolean first = true;
            this.writer.formatln("%s other = (%s) o;", new Object[]{message.instanceType(), message.instanceType()}).appendln((CharSequence)"return ");
            if (message.isUnion()) {
                this.writer.format("%s.equals(%s, other.%s)", new Object[]{Objects.class.getName(), "tUnionField", "tUnionField"});
                first = false;
            }
            for (JField field : message.declaredOrderFields()) {
                if (field.isVoid()) continue;
                if (first) {
                    first = false;
                } else {
                    this.writer.append((CharSequence)" &&").appendln((CharSequence)"       ");
                }
                this.writer.format("%s.equals(%s, other.%s)", new Object[]{Objects.class.getName(), field.member(), field.member()});
            }
            this.writer.append(';');
        } else {
            this.writer.appendln((CharSequence)"return true;");
        }
        this.writer.end().appendln((CharSequence)"}").newline();
    }

    private void appendHashCode(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int hashCode() {").begin().appendln((CharSequence)"if (tHashCode == 0) {").begin().formatln("tHashCode = %s.hash(", new Object[]{Objects.class.getName()}).begin("        ").formatln("%s.class", new Object[]{message.instanceType()});
        message.numericalOrderFields().stream().filter(field -> !field.isVoid()).forEach(field -> {
            this.writer.append((CharSequence)",");
            this.writer.formatln("_Field.%s, %s", new Object[]{field.fieldEnum(), field.member()});
        });
        this.writer.end().append((CharSequence)");").end().appendln('}').appendln((CharSequence)"return tHashCode;").end().appendln((CharSequence)"}").newline();
    }

    private void appendToString(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String toString() {").begin().formatln("return \"%s\" + asString();", new Object[]{message.descriptor().getQualifiedName()}).end().appendln('}').newline();
    }

    private void appendAsString(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String asString() {").begin().appendln((CharSequence)"StringBuilder out = new StringBuilder();").appendln((CharSequence)"out.append(\"{\");").newline();
        if (message.isUnion()) {
            this.writer.formatln("switch (%s) {", new Object[]{"tUnionField"}).begin();
            for (JField field : message.declaredOrderFields()) {
                this.writer.formatln("case %s: {", new Object[]{this.caseFieldConstant(field)}).begin().formatln("out.append(\"%s:\")", new Object[]{field.name()});
                switch (field.type()) {
                    case VOID: {
                        this.writer.formatln("   .append(\"true\");", new Object[0]);
                        break;
                    }
                    case BOOL: 
                    case I32: 
                    case I64: {
                        this.writer.formatln("   .append(%s);", new Object[]{field.member()});
                        break;
                    }
                    case BYTE: 
                    case I16: {
                        this.writer.formatln("   .append((int) %s);", new Object[]{field.member()});
                        break;
                    }
                    case DOUBLE: 
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("   .append(%s.asString(%s));", new Object[]{net.morimekta.util.Strings.class.getName(), field.member()});
                        break;
                    }
                    case STRING: {
                        this.writer.formatln("   .append('\\\"').append(%s.escape(%s)).append('\\\"');", new Object[]{net.morimekta.util.Strings.class.getName(), field.member()});
                        break;
                    }
                    case BINARY: {
                        this.writer.formatln("   .append(\"b64(\").append(%s.toBase64()).append(')');", new Object[]{field.member()});
                        break;
                    }
                    case MESSAGE: 
                    case ENUM: {
                        this.writer.formatln("   .append(%s.asString());", new Object[]{field.member()});
                        break;
                    }
                    default: {
                        this.writer.formatln("   .append(%s.toString());", new Object[]{field.member()});
                    }
                }
                this.writer.appendln((CharSequence)"break;").end().appendln('}');
            }
            this.writer.end().appendln('}');
        } else {
            boolean firstFirstCheck = true;
            boolean alwaysAfter = false;
            List<JField> fieldList = message.declaredOrderFields();
            JField[] fields = fieldList.toArray(new JField[fieldList.size()]);
            for (int i = 0; i < fields.length; ++i) {
                boolean first = i == 0;
                boolean last = i == fields.length - 1;
                JField field = fields[i];
                if (!field.alwaysPresent()) {
                    if (!alwaysAfter && firstFirstCheck && !last) {
                        this.writer.appendln((CharSequence)"boolean first = true;");
                    }
                    this.writer.formatln("if (%s()) {", new Object[]{field.presence()});
                    this.writer.begin();
                }
                if (alwaysAfter) {
                    this.writer.appendln((CharSequence)"out.append(',');");
                } else if (!field.alwaysPresent()) {
                    if (firstFirstCheck || first) {
                        if (!last) {
                            this.writer.appendln((CharSequence)"first = false;");
                        }
                    } else if (last) {
                        this.writer.appendln((CharSequence)"if (!first) out.append(',');");
                    } else {
                        this.writer.appendln((CharSequence)"if (first) first = false;").appendln((CharSequence)"else out.append(',');");
                    }
                }
                this.writer.formatln("out.append(\"%s:\")", new Object[]{field.name()});
                switch (field.type()) {
                    case BOOL: 
                    case I32: 
                    case I64: {
                        this.writer.formatln("   .append(%s);", new Object[]{field.member()});
                        break;
                    }
                    case BYTE: 
                    case I16: {
                        this.writer.formatln("   .append((int) %s);", new Object[]{field.member()});
                        break;
                    }
                    case DOUBLE: 
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("   .append(%s.asString(%s));", new Object[]{net.morimekta.util.Strings.class.getName(), field.member()});
                        break;
                    }
                    case STRING: {
                        this.writer.appendln((CharSequence)"   .append('\\\"')").formatln("   .append(%s.escape(%s))", new Object[]{net.morimekta.util.Strings.class.getName(), field.member()}).appendln((CharSequence)"   .append('\\\"');");
                        break;
                    }
                    case BINARY: {
                        this.writer.appendln((CharSequence)"   .append(\"b64(\")").formatln("   .append(%s.toBase64())", new Object[]{field.member()}).appendln((CharSequence)"   .append(')');");
                        break;
                    }
                    case MESSAGE: 
                    case ENUM: {
                        this.writer.formatln("   .append(%s.asString());", new Object[]{field.member()});
                        break;
                    }
                    default: {
                        this.writer.formatln("   .append(%s.toString());", new Object[]{field.member()});
                    }
                }
                if (!field.alwaysPresent()) {
                    this.writer.end().appendln('}');
                    if (alwaysAfter || !firstFirstCheck) continue;
                    firstFirstCheck = false;
                    continue;
                }
                alwaysAfter = true;
            }
        }
        this.writer.appendln((CharSequence)"out.append('}');").appendln((CharSequence)"return out.toString();").end().appendln((CharSequence)"}").newline();
    }

    private void appendCompareTo(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").formatln("public int compareTo(%s other) {", new Object[]{message.instanceType()}).begin();
        if (message.isUnion()) {
            this.writer.formatln("int c = %s.compareTo(other.%s);", new Object[]{"tUnionField", "tUnionField"}).appendln((CharSequence)"if (c != 0) return c;").newline().formatln("switch (%s) {", new Object[]{"tUnionField"}).begin();
            for (JField field : message.numericalOrderFields()) {
                this.writer.formatln("case %s:", new Object[]{this.caseFieldConstant(field)}).begin();
                switch (field.type()) {
                    case BOOL: {
                        this.writer.formatln("return Boolean.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case BYTE: {
                        this.writer.formatln("return Byte.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I16: {
                        this.writer.formatln("return Short.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I32: {
                        this.writer.formatln("return Integer.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I64: {
                        this.writer.formatln("return Long.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case DOUBLE: {
                        this.writer.formatln("return Double.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case STRING: 
                    case BINARY: 
                    case MESSAGE: {
                        this.writer.formatln("return %s.compareTo(other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case ENUM: {
                        this.writer.formatln("return Integer.compare(%s.getValue(), other.%s.getValue());", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("return Integer.compare(%s.hashCode(), other.%s.hashCode());", new Object[]{field.member(), field.member()});
                        break;
                    }
                }
                this.writer.end();
            }
            this.writer.appendln((CharSequence)"default: return 0;").end().appendln('}');
        } else {
            this.writer.appendln((CharSequence)"int c;");
            for (JField field : message.numericalOrderFields()) {
                this.writer.newline();
                if (!field.alwaysPresent()) {
                    this.writer.formatln("c = Boolean.compare(%s != null, other.%s != null);", new Object[]{field.member(), field.member()}).appendln((CharSequence)"if (c != 0) return c;").formatln("if (%s != null) {", new Object[]{field.member()}).begin();
                }
                switch (field.type()) {
                    case BOOL: {
                        this.writer.formatln("c = Boolean.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case BYTE: {
                        this.writer.formatln("c = Byte.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I16: {
                        this.writer.formatln("c = Short.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I32: {
                        this.writer.formatln("c = Integer.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I64: {
                        this.writer.formatln("c = Long.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case DOUBLE: {
                        this.writer.formatln("c = Double.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case STRING: 
                    case BINARY: 
                    case MESSAGE: {
                        this.writer.formatln("c = %s.compareTo(other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case ENUM: {
                        this.writer.formatln("c = Integer.compare(%s.ordinal(), %s.ordinal());", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("c = Integer.compare(%s.hashCode(), other.%s.hashCode());", new Object[]{field.member(), field.member()});
                        break;
                    }
                }
                this.writer.appendln((CharSequence)"if (c != 0) return c;");
                if (field.alwaysPresent()) continue;
                this.writer.end().appendln('}');
            }
            this.writer.newline().appendln((CharSequence)"return 0;");
        }
        this.writer.end().appendln((CharSequence)"}").newline();
    }
}

