/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.enums;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.EnumMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.util.io.IndentedPrintWriter;

public class CoreMemberFormatter
implements EnumMemberFormatter {
    private final IndentedPrintWriter writer;

    public CoreMemberFormatter(IndentedPrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public Collection<String> getExtraImplements(CEnumDescriptor type) throws GeneratorException {
        return ImmutableList.of((Object)String.format("%s<%s>", PEnumValue.class.getName(), JUtils.getClassName(type)));
    }

    @Override
    public void appendMethods(CEnumDescriptor type) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getValue() {").begin().appendln((CharSequence)"return mValue;").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String getName() {").begin().appendln((CharSequence)"return mName;").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int asInteger() {").begin().appendln((CharSequence)"return mValue;").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String asString() {").begin().appendln((CharSequence)"return mName;").end().appendln('}').newline();
    }

    @Override
    public void appendExtraProperties(CEnumDescriptor type) throws GeneratorException {
        this.appendBuilder((PEnumDescriptor<?>)type);
        this.appendDescriptor((PEnumDescriptor<?>)type);
    }

    private void appendDescriptor(PEnumDescriptor<?> type) {
        String simpleClass = JUtils.getClassName(type);
        this.writer.formatln("public static final %s<%s> kDescriptor;", new Object[]{PEnumDescriptor.class.getName(), simpleClass}).newline();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s<%s> descriptor() {", new Object[]{PEnumDescriptor.class.getName(), simpleClass}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').newline();
        this.writer.formatln("public static %s<%s> provider() {", new Object[]{PEnumDescriptorProvider.class.getName(), simpleClass}).begin().formatln("return new %s<%s>(kDescriptor);", new Object[]{PEnumDescriptorProvider.class.getName(), simpleClass}).end().appendln('}').newline();
        this.writer.appendln((CharSequence)"private static class _Factory").begin().formatln("    extends %s<%s> {", new Object[]{PEnumBuilderFactory.class.getName(), simpleClass}).appendln((CharSequence)"@Override").formatln("public %s._Builder builder() {", new Object[]{simpleClass}).begin().formatln("return new %s._Builder();", new Object[]{simpleClass}).end().appendln('}').end().appendln('}').newline();
        this.writer.appendln((CharSequence)"private static class _Descriptor").formatln("        extends %s<%s> {", new Object[]{PEnumDescriptor.class.getName(), simpleClass}).begin().appendln((CharSequence)"public _Descriptor() {").begin().formatln("super(\"%s\", \"%s\", new _Factory());", new Object[]{type.getProgramName(), type.getName(), simpleClass}).end().appendln('}').newline().appendln((CharSequence)"@Override").formatln("public %s[] getValues() {", new Object[]{simpleClass}).begin().formatln("return %s.values();", new Object[]{simpleClass}).end().appendln('}').newline().appendln((CharSequence)"@Override").formatln("public %s getValueById(int id) {", new Object[]{simpleClass}).begin().formatln("return %s.forValue(id);", new Object[]{simpleClass}).end().appendln('}').newline().appendln((CharSequence)"@Override").formatln("public %s getValueByName(String name) {", new Object[]{simpleClass}).begin().formatln("return %s.forName(name);", new Object[]{simpleClass}).end().appendln('}').end().appendln('}').newline();
        this.writer.formatln("static {", new Object[]{simpleClass}).begin();
        this.writer.appendln((CharSequence)"kDescriptor = new _Descriptor();").end().appendln('}');
    }

    private void appendBuilder(PEnumDescriptor<?> type) {
        String simpleClass = JUtils.getClassName(type);
        this.writer.formatln("public static class _Builder extends %s<%s> {", new Object[]{PEnumBuilder.class.getName(), simpleClass}).begin().formatln("%s mValue;", new Object[]{simpleClass}).newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder setByValue(int value) {").begin().formatln("mValue = %s.forValue(value);", new Object[]{simpleClass}).appendln((CharSequence)"return this;").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder setByName(String name) {").begin().formatln("mValue = %s.forName(name);", new Object[]{simpleClass}).appendln((CharSequence)"return this;").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean valid() {").begin().appendln((CharSequence)"return mValue != null;").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s build() {", new Object[]{simpleClass}).begin().appendln((CharSequence)"return mValue;").end().appendln('}');
        this.writer.end().appendln('}').newline();
    }
}

