/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.morimekta.providence.PException;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.io.IndentedPrintWriter;

public class CoreOverridesFormatter
implements MessageMemberFormatter {
    public static final String UNION_FIELD = "tUnionField";
    protected final IndentedPrintWriter writer;

    public CoreOverridesFormatter(IndentedPrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public Collection<String> getExtraImplements(JMessage<?> message) throws GeneratorException {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)String.format("%s<%s,%s._Field>", message.isUnion() ? PUnion.class.getName() : PMessage.class.getName(), message.instanceType(), message.instanceType()));
        if (message.isException()) {
            builder.add((Object)PException.class.getName());
        }
        return builder.build();
    }

    @Override
    public void appendFields(JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            this.writer.formatln("private final _Field %s;", new Object[]{UNION_FIELD}).newline();
        }
    }

    public void appendMethods(JMessage message) {
        this.appendPresence(message);
        this.appendCounter(message);
        this.appendGetter(message);
        this.appendCompact(message);
        if (message.isException()) {
            this.appendPExceptionOverrides();
            this.appendExceptionOverrides(message);
        }
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field unionField() {").formatln("    return %s;", new Object[]{UNION_FIELD}).appendln('}').newline();
        }
    }

    @Override
    public void appendExtraProperties(JMessage<?> message) throws GeneratorException {
        this.appendFieldEnum(message);
        this.appendDescriptor(message);
    }

    private void appendPExceptionOverrides() {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String origGetMessage() {").appendln((CharSequence)"    return super.getMessage();").appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String origGetLocalizedMessage() {").appendln((CharSequence)"    return super.getLocalizedMessage();").appendln('}').newline();
    }

    private void appendExceptionOverrides(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").formatln("public %s initCause(Throwable cause) {", new Object[]{message.instanceType()}).formatln("    return (%s) super.initCause(cause);", new Object[]{message.instanceType()}).appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s fillInStackTrace() {", new Object[]{message.instanceType()}).formatln("    return (%s) super.fillInStackTrace();", new Object[]{message.instanceType()}).appendln('}').newline();
    }

    private void appendDescriptor(JMessage<?> message) throws GeneratorException {
        String typeClass = message.getDescriptorClass();
        String providerClass = message.getProviderClass();
        this.writer.formatln("public static %s<%s,_Field> provider() {", new Object[]{providerClass, message.instanceType()}).begin().formatln("return new _Provider();", new Object[0]).end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s<%s,_Field> descriptor() {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').newline();
        this.writer.formatln("public static final %s<%s,_Field> kDescriptor;", new Object[]{typeClass, message.instanceType()}).newline();
        this.writer.formatln("private static class _Descriptor", new Object[0]).formatln("        extends %s<%s,_Field> {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"public _Descriptor() {").begin();
        if (message.isException() || message.isUnion()) {
            this.writer.formatln("super(\"%s\", \"%s\", new _Factory(), %s);", new Object[]{message.descriptor().getProgramName(), message.descriptor().getName(), message.descriptor().isSimple()});
        } else {
            this.writer.formatln("super(\"%s\", \"%s\", new _Factory(), %b, %b);", new Object[]{message.descriptor().getProgramName(), message.descriptor().getName(), message.descriptor().isSimple(), message.descriptor().isCompactible()});
        }
        this.writer.end().appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field[] getFields() {").begin().appendln((CharSequence)"return _Field.values();").end().appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field getField(String name) {").begin().appendln((CharSequence)"return _Field.forName(name);").end().appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field getField(int key) {").begin().appendln((CharSequence)"return _Field.forKey(key);").end().appendln('}').end().appendln('}').newline();
        this.writer.formatln("static {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"kDescriptor = new _Descriptor();").end().appendln('}').newline();
        this.writer.formatln("private final static class _Provider extends %s<%s,_Field> {", new Object[]{providerClass, message.instanceType()}).begin().appendln((CharSequence)"@Override").formatln("public %s<%s,_Field> descriptor() {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').end().appendln((CharSequence)"}").newline();
        this.writer.appendln((CharSequence)"private final static class _Factory").begin().formatln("    extends %s<%s,_Field> {", new Object[]{PMessageBuilderFactory.class.getName(), message.instanceType()}).appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder builder() {").begin().appendln((CharSequence)"return new _Builder();").end().appendln('}').end().appendln('}').newline();
    }

    private void appendFieldEnum(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("public enum _Field implements %s {", new Object[]{PField.class.getName()}).begin();
        for (JField field : message.numericalOrderFields()) {
            String provider = field.getProvider();
            String defValue = "null";
            if (field.getPField().hasDefaultValue()) {
                defValue = String.format("new %s<>(%s)", PDefaultValueProvider.class.getName(), field.kDefault());
            }
            this.writer.formatln("%s(%d, %s.%s, \"%s\", %s, %s),", new Object[]{field.fieldEnum(), field.id(), PRequirement.class.getName(), field.getPField().getRequirement().name(), field.name(), provider, defValue});
        }
        this.writer.appendln(';').newline();
        this.writer.appendln((CharSequence)"private final int mKey;").formatln("private final %s mRequired;", new Object[]{PRequirement.class.getName()}).appendln((CharSequence)"private final String mName;").formatln("private final %s mTypeProvider;", new Object[]{PDescriptorProvider.class.getName()}).formatln("private final %s<?> mDefaultValue;", new Object[]{PValueProvider.class.getName()}).newline().formatln("_Field(int key, %s required, String name, %s typeProvider, %s<?> defaultValue) {", new Object[]{PRequirement.class.getName(), PDescriptorProvider.class.getName(), PValueProvider.class.getName()}).begin().appendln((CharSequence)"mKey = key;").appendln((CharSequence)"mRequired = required;").appendln((CharSequence)"mName = name;").appendln((CharSequence)"mTypeProvider = typeProvider;").appendln((CharSequence)"mDefaultValue = defaultValue;").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getKey() { return mKey; }").newline();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s getRequirement() { return mRequired; }", new Object[]{PRequirement.class.getName()}).newline();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s getDescriptor() { return mTypeProvider.descriptor(); }", new Object[]{PDescriptor.class.getName()}).newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String getName() { return mName; }").newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean hasDefaultValue() { return mDefaultValue != null; }").newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public Object getDefaultValue() {").appendln((CharSequence)"    return hasDefaultValue() ? mDefaultValue.get() : null;").appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String toString() {").formatln("    return %s.toString(this);", new Object[]{PField.class.getName()}).appendln('}').newline();
        this.writer.appendln((CharSequence)"public static _Field forKey(int key) {").begin().appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.declaredOrderFields()) {
            this.writer.formatln("case %d: return _Field.%s;", new Object[]{field.id(), field.fieldEnum()});
        }
        this.writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"public static _Field forName(String name) {").begin().appendln((CharSequence)"switch (name) {").begin();
        for (JField field : message.declaredOrderFields()) {
            this.writer.formatln("case \"%s\": return _Field.%s;", new Object[]{field.name(), field.fieldEnum()});
        }
        this.writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}');
        this.writer.end().appendln('}').newline();
    }

    private void appendCompact(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean compact() {").begin();
        if (message.descriptor().isCompactible()) {
            this.writer.appendln((CharSequence)"boolean missing = false;");
            boolean hasCheck = false;
            for (JField field : message.declaredOrderFields()) {
                if (!field.alwaysPresent()) {
                    hasCheck = true;
                    this.writer.formatln("if (%s()) {", new Object[]{field.presence()}).appendln((CharSequence)"    if (missing) return false;").appendln((CharSequence)"} else {").appendln((CharSequence)"    missing = true;").appendln('}');
                    continue;
                }
                if (!hasCheck) continue;
                this.writer.appendln((CharSequence)"if (missing) return false;");
                hasCheck = false;
            }
            this.writer.appendln((CharSequence)"return true;");
        } else {
            this.writer.appendln((CharSequence)"return false;");
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendGetter(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public Object get(int key) {").begin().appendln((CharSequence)"switch(key) {").begin();
        for (JField field : message.declaredOrderFields()) {
            if (field.isVoid()) {
                this.writer.formatln("case %d: return %s() ? Boolean.FALSE : null;", new Object[]{field.id(), field.presence()});
                continue;
            }
            this.writer.formatln("case %d: return %s();", new Object[]{field.id(), field.getter()});
        }
        this.writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
    }

    private void appendPresence(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean has(int key) {").begin().appendln((CharSequence)"switch(key) {").begin();
        for (JField field : message.declaredOrderFields()) {
            if (field.alwaysPresent() && !message.isUnion()) {
                this.writer.formatln("case %d: return true;", new Object[]{field.id()});
                continue;
            }
            this.writer.formatln("case %d: return %s();", new Object[]{field.id(), field.presence()});
        }
        this.writer.appendln((CharSequence)"default: return false;").end().appendln('}').end().appendln('}').newline();
    }

    private void appendCounter(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int num(int key) {").begin().appendln((CharSequence)"switch(key) {").begin();
        for (JField field : message.declaredOrderFields()) {
            if (field.container()) {
                this.writer.formatln("case %d: return %s();", new Object[]{field.id(), field.counter()});
                continue;
            }
            if (field.alwaysPresent() && !message.isUnion()) {
                this.writer.formatln("case %d: return 1;", new Object[]{field.id()});
                continue;
            }
            this.writer.formatln("case %d: return %s() ? 1 : 0;", new Object[]{field.id(), field.presence()});
        }
        this.writer.appendln((CharSequence)"default: return 0;").end().appendln('}').end().appendln('}').newline();
    }
}

