/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.descriptor.PExceptionDescriptor;
import net.morimekta.providence.descriptor.PExceptionDescriptorProvider;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptorProvider;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;
import net.morimekta.providence.reflect.util.ThriftAnnotation;

public class JMessage<T extends CMessage<T, CField>> {
    private final PStructDescriptor<?, ?> struct;
    private final JHelper helper;
    private final ArrayList<JField> declaredFields;
    private final ArrayList<JField> numericalFields;

    public JMessage(PStructDescriptor<T, CField> struct, JHelper helper) {
        this.struct = struct;
        this.helper = helper;
        this.declaredFields = new ArrayList(((CField[])struct.getFields()).length);
        CField[] fields = (CField[])struct.getFields();
        for (int i = 0; i < fields.length; ++i) {
            this.declaredFields.add(new JField(fields[i], helper, i));
        }
        this.numericalFields = new ArrayList<JField>(this.declaredFields);
        Collections.sort(this.numericalFields, (a, b) -> Integer.compare(a.id(), b.id()));
    }

    public PStructDescriptor<?, ?> descriptor() {
        return this.struct;
    }

    public PMessageVariant variant() {
        return this.struct.getVariant();
    }

    public boolean isException() {
        return this.struct.getVariant() == PMessageVariant.EXCEPTION;
    }

    public boolean isUnion() {
        return this.struct.getVariant() == PMessageVariant.UNION;
    }

    public String instanceType() {
        return JUtils.getClassName(this.struct);
    }

    public List<JField> declaredOrderFields() {
        return this.declaredFields;
    }

    public List<JField> numericalOrderFields() {
        return this.numericalFields;
    }

    public String getDescriptorClass() throws GeneratorException {
        switch (this.variant()) {
            case STRUCT: {
                return PStructDescriptor.class.getName();
            }
            case UNION: {
                return PUnionDescriptor.class.getName();
            }
            case EXCEPTION: {
                return PExceptionDescriptor.class.getName();
            }
        }
        throw new GeneratorException("Unable to determine type class for " + this.variant());
    }

    public String getProviderClass() throws GeneratorException {
        switch (this.variant()) {
            case STRUCT: {
                return PStructDescriptorProvider.class.getName();
            }
            case UNION: {
                return PUnionDescriptorProvider.class.getName();
            }
            case EXCEPTION: {
                return PExceptionDescriptorProvider.class.getName();
            }
        }
        throw new GeneratorException("Unable to determine type class for " + this.variant());
    }

    public String extraImplements() {
        if (this.struct instanceof CAnnotatedDescriptor) {
            return ((CAnnotatedDescriptor)this.struct).getAnnotationValue(ThriftAnnotation.JAVA_IMPLEMENTS);
        }
        return null;
    }

    public String exceptionBaseClass() {
        if (!this.isException()) {
            return null;
        }
        if (this.struct instanceof CAnnotatedDescriptor && ((CAnnotatedDescriptor)this.struct).hasAnnotation(ThriftAnnotation.JAVA_EXCEPTION_CLASS)) {
            return ((CAnnotatedDescriptor)this.struct).getAnnotationValue(ThriftAnnotation.JAVA_EXCEPTION_CLASS);
        }
        return Exception.class.getSimpleName();
    }
}

