/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages;

import java.util.List;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.BaseMessageFormatter;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.io.IndentedPrintWriter;

public class CommonBuilderFormatter
extends BaseMessageFormatter
implements MessageMemberFormatter {
    public CommonBuilderFormatter(IndentedPrintWriter writer, JHelper helper, List<MessageMemberFormatter> formatters) {
        super(true, false, writer, helper, formatters);
    }

    @Override
    public String getClassName(JMessage<?> message) {
        return "_Builder";
    }

    @Override
    public void appendMethods(JMessage<?> message) throws GeneratorException {
        this.appendMutate(message);
    }

    @Override
    public void appendExtraProperties(JMessage<?> message) throws GeneratorException {
        this.appendStaticMakeBuilder(message);
        this.appendMessageClass(message.descriptor());
    }

    @Override
    public void appendConstructors(JMessage<?> message) throws GeneratorException {
        this.appendBuilderConstructors(message);
    }

    @Override
    protected void appendClassExtends(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("extends %s<%s,_Field>", new Object[]{PMessageBuilder.class.getName(), message.instanceType()});
    }

    protected void appendMutate(JMessage message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder mutate() {").begin().appendln((CharSequence)"return new _Builder(this);").end().appendln('}').newline();
    }

    protected void appendStaticMakeBuilder(JMessage message) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a " + message.descriptor().getQualifiedName(null) + " builder.").return_("The builder instance.").finish();
        this.writer.formatln("public static _Builder builder() {", new Object[0]).begin().appendln((CharSequence)"return new _Builder();").end().appendln('}').newline();
    }

    private void appendBuilderConstructors(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("private %s(_Builder builder) {", new Object[]{message.instanceType()}).begin();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"tUnionField = builder.tUnionField;").newline();
            block7: for (JField jField : message.declaredOrderFields()) {
                switch (jField.type()) {
                    case VOID: {
                        continue block7;
                    }
                    case LIST: {
                        this.writer.formatln("%s = tUnionField == _Field.%s ? builder.%s.build() : null;", new Object[]{jField.member(), jField.fieldEnum(), jField.member()});
                        continue block7;
                    }
                    case SET: {
                        this.writer.formatln("%s = tUnionField == _Field.%s ? builder.%s.build() : null;", new Object[]{jField.member(), jField.fieldEnum(), jField.member()});
                        continue block7;
                    }
                    case MAP: {
                        this.writer.formatln("%s = tUnionField == _Field.%s ? builder.%s.build() : null;", new Object[]{jField.member(), jField.fieldEnum(), jField.member()});
                        continue block7;
                    }
                    case MESSAGE: {
                        this.writer.formatln("%s = tUnionField != _Field.%s", new Object[]{jField.member(), jField.fieldEnum()}).appendln((CharSequence)"        ? null").formatln("        : builder.%s_builder != null ? builder.%s_builder.build() : builder.%s;", new Object[]{jField.member(), jField.member(), jField.member()});
                        continue block7;
                    }
                }
                if (jField.alwaysPresent()) {
                    this.writer.formatln("%s = tUnionField == _Field.%s ? builder.%s : %s;", new Object[]{jField.member(), jField.fieldEnum(), jField.member(), jField.kDefault()});
                    continue;
                }
                this.writer.formatln("%s = tUnionField == _Field.%s ? builder.%s : null;", new Object[]{jField.member(), jField.fieldEnum(), jField.member()});
            }
        } else {
            if (message.isException()) {
                this.writer.appendln((CharSequence)"super(createMessage(").begin("                    ");
                boolean first = true;
                for (JField field : message.declaredOrderFields()) {
                    if (first) {
                        first = false;
                    } else {
                        this.writer.append(',').appendln();
                    }
                    if (field.container()) {
                        this.writer.format("builder.%s() ? builder.%s.build() : null", new Object[]{field.isSet(), field.member()});
                        continue;
                    }
                    if (field.isVoid()) continue;
                    this.writer.format("builder.%s", new Object[]{field.member()});
                }
                this.writer.append((CharSequence)"));").end().newline();
            }
            for (JField jField : message.declaredOrderFields()) {
                if (jField.container()) {
                    this.writer.formatln("if (builder.%s()) {", new Object[]{jField.isSet()}).formatln("    %s = builder.%s.build();", new Object[]{jField.member(), jField.member()}).appendln((CharSequence)"} else {").formatln("    %s = null;", new Object[]{jField.member()}).appendln('}');
                    continue;
                }
                if (jField.type() == PType.MESSAGE) {
                    this.writer.formatln("%s = builder.%s_builder != null ? builder.%s_builder.build() : builder.%s;", new Object[]{jField.member(), jField.member(), jField.member(), jField.member()});
                    continue;
                }
                if (jField.isVoid()) continue;
                this.writer.formatln("%s = builder.%s;", new Object[]{jField.member(), jField.member()});
            }
        }
        this.writer.end().appendln('}').newline();
    }
}

