/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages;

import java.util.BitSet;
import java.util.Collection;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class BuilderCommonMemberFormatter
implements MessageMemberFormatter {
    protected final IndentedPrintWriter writer;
    protected final JHelper helper;

    public BuilderCommonMemberFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public void appendClassAnnotations(JMessage<?> message) throws GeneratorException {
        if (JAnnotation.isDeprecated(message.descriptor())) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
    }

    @Override
    public void appendConstructors(JMessage<?> message) throws GeneratorException {
        this.appendDefaultConstructor(message);
        this.appendMutateConstructor(message);
    }

    @Override
    public void appendFields(JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            this.appendUnionFields(message);
        } else {
            this.appendStructFields(message);
        }
        for (JField field : message.declaredOrderFields()) {
            if (field.isVoid()) continue;
            this.writer.formatln("private %s %s;", new Object[]{field.builderFieldType(), field.member()});
            if (field.type() != PType.MESSAGE) continue;
            this.writer.formatln("private %s._Builder %s_builder;", new Object[]{field.builderFieldType(), field.member()});
        }
        if (message.declaredOrderFields().size() > 0) {
            this.writer.newline();
        }
    }

    @Override
    public void appendMethods(JMessage<?> message) throws GeneratorException {
        for (JField field : message.declaredOrderFields()) {
            this.appendSetter(message, field);
            if (field.container()) {
                this.appendAdder(message, field);
            }
            this.appendIsSet(message, field);
            this.appendResetter(message, field);
            this.appendMutableGetters(message, field);
        }
    }

    @Override
    public void appendExtraProperties(JMessage<?> message) throws GeneratorException {
        this.appendBuilderBuild(message);
    }

    private void appendBuilderBuild(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").formatln("public %s build() {", new Object[]{message.instanceType()}).begin().formatln("return new %s(this);", new Object[]{message.instanceType()}).end().appendln('}');
    }

    private void appendUnionFields(JMessage<?> message) {
        this.writer.appendln((CharSequence)"private _Field tUnionField;").newline();
    }

    private void appendStructFields(JMessage<?> message) {
        this.writer.formatln("private %s optionals;", new Object[]{BitSet.class.getName()}).newline();
    }

    private void appendDefaultConstructor(JMessage<?> message) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a " + message.descriptor().getQualifiedName(null) + " builder.").finish();
        this.writer.appendln((CharSequence)"public _Builder() {").begin();
        if (!message.isUnion()) {
            this.writer.formatln("optionals = new %s(%d);", new Object[]{BitSet.class.getName(), message.declaredOrderFields().size()});
        }
        for (JField field : message.declaredOrderFields()) {
            if (field.container()) {
                this.writer.formatln("%s = new %s<>();", new Object[]{field.member(), field.builderInstanceType()});
                continue;
            }
            if (!field.alwaysPresent()) continue;
            this.writer.formatln("%s = %s;", new Object[]{field.member(), field.kDefault()});
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendMutateConstructor(JMessage<?> message) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a mutating builder off a base " + message.descriptor().getQualifiedName(null) + ".").newline().param_("base", "The base " + message.descriptor().getName()).finish();
        this.writer.formatln("public _Builder(%s base) {", new Object[]{message.instanceType()}).begin().appendln((CharSequence)"this();").newline();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"tUnionField = base.tUnionField;").newline();
        }
        for (JField field : message.declaredOrderFields()) {
            boolean checkPresence;
            boolean bl = message.isUnion() ? field.container() : (checkPresence = !field.alwaysPresent());
            if (checkPresence) {
                if (field.container()) {
                    this.writer.formatln("if (base.%s() > 0) {", new Object[]{field.counter()}).begin();
                } else {
                    this.writer.formatln("if (base.%s()) {", new Object[]{field.presence()}).begin();
                }
            }
            if (!message.isUnion()) {
                this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
            }
            switch (field.type()) {
                case VOID: {
                    break;
                }
                case LIST: 
                case SET: {
                    this.writer.formatln("%s.addAll(base.%s);", new Object[]{field.member(), field.member()});
                    break;
                }
                case MAP: {
                    this.writer.formatln("%s.putAll(base.%s);", new Object[]{field.member(), field.member()});
                    break;
                }
                default: {
                    this.writer.formatln("%s = base.%s;", new Object[]{field.member(), field.member()});
                }
            }
            if (!checkPresence) continue;
            this.writer.end().appendln('}');
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendSetter(JMessage message, JField field) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        if (field.hasComment()) {
            comment.comment(field.comment());
        } else {
            comment.comment("Sets the value of " + field.name() + ".");
        }
        comment.newline().param_("value", "The new value").return_("The builder").finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        if (field.isVoid()) {
            this.writer.formatln("public _Builder %s() {", new Object[]{field.setter()});
        } else if (field.type() == PType.SET || field.type() == PType.LIST) {
            PContainer cType = (PContainer)field.getPField().getDescriptor();
            String iType = this.helper.getFieldType(cType.itemDescriptor());
            this.writer.formatln("public _Builder %s(%s<%s> value) {", new Object[]{field.setter(), Collection.class.getName(), iType});
        } else {
            this.writer.formatln("public _Builder %s(%s value) {", new Object[]{field.setter(), field.valueType()});
        }
        this.writer.begin();
        if (message.isUnion()) {
            this.writer.formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
        } else {
            this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
        }
        switch (field.type()) {
            case VOID: {
                break;
            }
            case LIST: 
            case SET: {
                this.writer.formatln("%s.clear();", new Object[]{field.member()}).formatln("%s.addAll(value);", new Object[]{field.member()});
                break;
            }
            case MAP: {
                this.writer.formatln("%s.clear();", new Object[]{field.member()}).formatln("%s.putAll(value);", new Object[]{field.member()});
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s_builder = null;", new Object[]{field.member()});
            }
            default: {
                this.writer.formatln("%s = value;", new Object[]{field.member()});
            }
        }
        this.writer.appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendAdder(JMessage message, JField field) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        if (field.hasComment()) {
            comment.comment(field.comment());
        } else if (field.type() == PType.MAP) {
            comment.comment("Adds a mapping to " + field.name() + ".");
        } else {
            comment.comment("Adds entries to " + field.name() + ".");
        }
        comment.newline();
        if (field.type() == PType.MAP) {
            comment.param_("key", "The inserted key").param_("value", "The inserted value");
        } else {
            comment.param_("values", "The added value");
        }
        comment.return_("The builder").finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        switch (field.type()) {
            case MAP: {
                PMap mType = (PMap)field.getPField().getDescriptor();
                String mkType = this.helper.getValueType(mType.keyDescriptor());
                String miType = this.helper.getValueType(mType.itemDescriptor());
                this.writer.formatln("public _Builder %s(%s key, %s value) {", new Object[]{field.adder(), mkType, miType}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                }
                this.writer.formatln("%s.put(key, value);", new Object[]{field.member()}).appendln((CharSequence)"return this;").end().appendln('}').newline();
                break;
            }
            case LIST: 
            case SET: {
                PContainer lType = (PContainer)field.getPField().getDescriptor();
                String liType = this.helper.getValueType(lType.itemDescriptor());
                this.writer.formatln("public _Builder %s(%s... values) {", new Object[]{field.adder(), liType}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                }
                this.writer.formatln("for (%s item : values) {", new Object[]{liType}).begin().formatln("%s.add(item);", new Object[]{field.member()}).end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
                break;
            }
        }
    }

    private void appendIsSet(JMessage message, JField field) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        if (field.hasComment()) {
            comment.comment(field.comment());
        } else {
            comment.comment("Checks for presence of the " + field.name() + " field.");
        }
        comment.newline().return_(String.format("True iff %s has been set.", field.name())).finish();
        this.writer.formatln("public boolean %s() {", new Object[]{field.isSet()}).begin();
        if (message.isUnion()) {
            this.writer.formatln("return tUnionField == _Field.%s;", new Object[]{field.fieldEnum()});
        } else {
            this.writer.formatln("return optionals.get(%d);", new Object[]{field.index()});
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendResetter(JMessage message, JField field) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        if (field.hasComment()) {
            comment.comment(field.comment());
        } else {
            comment.comment("Clears the " + field.name() + " field.");
        }
        comment.newline().return_("The builder").finish();
        this.writer.formatln("public _Builder %s() {", new Object[]{field.resetter()}).begin();
        if (message.isUnion()) {
            this.writer.formatln("if (tUnionField == _Field.%s) tUnionField = null;", new Object[]{field.fieldEnum()});
        } else {
            this.writer.formatln("optionals.clear(%d);", new Object[]{field.index()});
        }
        if (field.container()) {
            this.writer.formatln("%s.clear();", new Object[]{field.member()});
        } else if (!field.isVoid()) {
            if (field.alwaysPresent()) {
                this.writer.formatln("%s = %s;", new Object[]{field.member(), field.kDefault()});
            } else {
                this.writer.formatln("%s = null;", new Object[]{field.member()});
                if (field.type() == PType.MESSAGE) {
                    this.writer.formatln("%s_builder = null;", new Object[]{field.member()});
                }
            }
        }
        this.writer.appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendMutableGetters(JMessage message, JField field) throws GeneratorException {
        if (field.getPField().getDescriptor() instanceof PPrimitive || field.type() == PType.ENUM) {
            return;
        }
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        if (field.hasComment()) {
            comment.comment(field.comment());
        } else {
            comment.comment("Gets the builder for the contained " + field.name() + ".");
        }
        comment.newline().return_("The field builder").finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        switch (field.type()) {
            case MESSAGE: {
                this.writer.formatln("public %s._Builder %s() {", new Object[]{field.instanceType(), Strings.camelCase((String)"mutable", (String)field.name())}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("if (tUnionField != _Field.%s) {", new Object[]{field.fieldEnum()}).formatln("    %s();", new Object[]{field.resetter()}).appendln('}').formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                }
                this.writer.newline().formatln("if (%s != null) {", new Object[]{field.member()}).formatln("    %s_builder = %s.mutate();", new Object[]{field.member(), field.member()}).formatln("    %s = null;", new Object[]{field.member()}).formatln("} else if (%s_builder == null) {", new Object[]{field.member()}).formatln("    %s_builder = %s.builder();", new Object[]{field.member(), field.instanceType()}).appendln('}').formatln("return %s_builder;", new Object[]{field.member()});
                this.writer.end().appendln('}').newline();
                break;
            }
            case LIST: 
            case SET: 
            case MAP: {
                this.writer.formatln("public %s %s() {", new Object[]{field.builderFieldType(), Strings.camelCase((String)"mutable", (String)field.name())}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("if (tUnionField != _Field.%s) {", new Object[]{field.fieldEnum()}).formatln("    %s();", new Object[]{field.resetter()}).appendln('}').formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                }
                this.writer.formatln("return %s;", new Object[]{field.member()});
                this.writer.end().appendln('}').newline();
                break;
            }
            default: {
                throw new GeneratorException("Unexpected field type: " + field.type());
            }
        }
    }
}

