/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.enums.extras;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.EnumMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.util.io.IndentedPrintWriter;

public class JacksonEnumFormatter
implements EnumMemberFormatter {
    private final IndentedPrintWriter writer;

    public JacksonEnumFormatter(IndentedPrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public void appendClassAnnotations(CEnumDescriptor type) throws GeneratorException {
        String simpleClass = JUtils.getClassName(type);
        this.writer.formatln("@%s(", new Object[]{JsonDeserialize.class.getName()}).formatln("        using = %s._Deserializer.class)", new Object[]{simpleClass});
    }

    @Override
    public void appendMethods(CEnumDescriptor type) throws GeneratorException {
        this.writer.formatln("@%s", new Object[]{JsonValue.class.getName()}).appendln((CharSequence)"public int jsonValue() {").appendln((CharSequence)"    return mValue;").appendln('}').newline();
    }

    @Override
    public void appendExtraProperties(CEnumDescriptor type) throws GeneratorException {
        String simpleClass = JUtils.getClassName(type);
        this.writer.formatln("public static class _Deserializer extends %s<%s> {", new Object[]{JsonDeserializer.class.getName(), simpleClass}).appendln((CharSequence)"    @Override").formatln("    public %s deserialize(%s jp,", new Object[]{simpleClass, JsonParser.class.getName()}).formatln("           %s             %s ctxt)", new Object[]{simpleClass.replaceAll(".", " "), DeserializationContext.class.getName()}).formatln("            throws %s,", new Object[]{IOException.class.getName()}).formatln("                   %s {", new Object[]{JsonProcessingException.class.getName()}).formatln("        if (jp.getCurrentToken() == %s.%s) {", new Object[]{JsonToken.class.getName(), JsonToken.VALUE_NUMBER_INT.name()}).formatln("            return %s.forValue(jp.getIntValue());", new Object[]{simpleClass}).formatln("        } else if (jp.getCurrentToken() == %s.%s) {", new Object[]{JsonToken.class.getName(), JsonToken.VALUE_STRING.name()}).formatln("            return %s.forName(jp.getText());", new Object[]{simpleClass}).appendln((CharSequence)"        } else {").formatln("            throw new %s(jp, \"Invalid token for enum %s deserialization \" + jp.getText());", new Object[]{JsonParseException.class.getName(), type.getQualifiedName(null)}).appendln((CharSequence)"        }").appendln((CharSequence)"    }").appendln('}').newline();
    }
}

