/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.enums;

import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.EnumMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CEnumValue;
import net.morimekta.util.io.IndentedPrintWriter;

public class CommonMemberFormatter
implements EnumMemberFormatter {
    private final IndentedPrintWriter writer;

    public CommonMemberFormatter(IndentedPrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public void appendClassAnnotations(CEnumDescriptor type) throws GeneratorException {
        if (JAnnotation.isDeprecated((CAnnotatedDescriptor)type)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
    }

    @Override
    public void appendExtraProperties(CEnumDescriptor type) throws GeneratorException {
        String simpleClass = JUtils.getClassName(type);
        this.writer.formatln("public static %s forValue(int value) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"switch (value) {").begin();
        for (CEnumValue value : type.getValues()) {
            this.writer.formatln("case %d: return %s.%s;", new Object[]{value.getValue(), simpleClass, JUtils.enumConst((PEnumValue)value)});
        }
        this.writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
        this.writer.formatln("public static %s forName(String name) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"switch (name) {").begin();
        for (CEnumValue value : type.getValues()) {
            this.writer.formatln("case \"%s\": return %s.%s;", new Object[]{value.getName(), simpleClass, JUtils.enumConst((PEnumValue)value)});
        }
        this.writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
    }
}

