/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.IOException;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PClient;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PProcessor;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallHandler;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JavaMessageFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseServiceFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JService;
import net.morimekta.providence.generator.format.java.utils.JServiceMethod;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class JavaServiceFormatter
implements BaseServiceFormatter {
    private final JHelper helper;
    private final JavaMessageFormatter messageFormat;
    private final IndentedPrintWriter writer;

    JavaServiceFormatter(IndentedPrintWriter writer, JHelper helper, JavaMessageFormatter messageFormat) {
        this.writer = writer;
        this.helper = helper;
        this.messageFormat = messageFormat;
    }

    @Override
    public void appendServiceClass(CService cs) throws GeneratorException, IOException {
        JService service = new JService(cs, this.helper);
        if (cs.getDocumentation() != null) {
            new BlockCommentBuilder(this.writer).comment(cs.getDocumentation()).finish();
        }
        this.writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")").formatln("public class %s {", new Object[]{service.className()}).begin();
        this.appendIface(this.writer, service);
        this.appendClient(this.writer, service);
        this.appendProcessor(this.writer, service);
        this.appendDescriptor(this.writer, service);
        this.appendStructs(this.writer, service);
        this.writer.formatln("private %s() {}", new Object[]{service.className()});
        this.writer.end().appendln('}');
    }

    private void appendClient(IndentedPrintWriter writer, JService service) throws GeneratorException {
        writer.appendln((CharSequence)"public static class Client").formatln("        extends %s", new Object[]{PClient.class.getName()}).formatln("        implements Iface {", new Object[0]).begin();
        writer.formatln("private final %s handler;", new Object[]{PServiceCallHandler.class.getName()}).newline();
        writer.formatln("public Client(%s handler) {", new Object[]{PServiceCallHandler.class.getName()}).appendln((CharSequence)"    this.handler = handler;").appendln('}').newline();
        boolean firstMethod = true;
        for (JServiceMethod method : service.methods()) {
            if (firstMethod) {
                firstMethod = false;
            } else {
                writer.newline();
            }
            writer.appendln((CharSequence)"@Override");
            JField ret = method.getResponse();
            writer.appendln((CharSequence)"public ");
            if (ret != null) {
                writer.append((CharSequence)ret.valueType());
            } else {
                writer.append((CharSequence)"void");
            }
            writer.format(" %s(", new Object[]{method.methodName()}).begin("        ");
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append((CharSequence)",");
                }
                writer.formatln("%s %s", new Object[]{param.valueType(), param.param()});
            }
            writer.end().format(")", new Object[0]).formatln("        throws %s", new Object[]{IOException.class.getName()}).begin("               ");
            for (JField ex : method.exceptions()) {
                writer.append((CharSequence)",");
                writer.appendln((CharSequence)ex.instanceType());
            }
            writer.format(" {", new Object[0]).end().begin();
            writer.formatln("%s._Builder rq = %s.builder();", new Object[]{method.getRequestClass(), method.getRequestClass()});
            for (JField param : method.params()) {
                writer.formatln("rq.%s(%s);", new Object[]{param.setter(), param.param()});
            }
            String type = method.getMethod().isOneway() ? PServiceCallType.ONEWAY.name() : PServiceCallType.CALL.name();
            writer.newline().formatln("%s call = new %s<>(\"%s\", %s.%s, getNextSequenceId(), rq.build());", new Object[]{PServiceCall.class.getName(), PServiceCall.class.getName(), method.name(), PServiceCallType.class.getName(), type}).appendln();
            if (method.getResponseClass() != null) {
                writer.format("%s resp = ", new Object[]{PServiceCall.class.getName()});
            }
            writer.format("handler.handleCall(call, %s.kDescriptor);", new Object[]{service.className()});
            if (method.getResponseClass() != null) {
                writer.formatln("%s msg = (%s) resp.getMessage();", new Object[]{method.getResponseClass(), method.getResponseClass()});
                writer.newline().formatln("if (resp.getType() == %s.%s) {", new Object[]{PServiceCallType.class.getName(), PServiceCallType.EXCEPTION.name()}).formatln("    throw (%s) resp.getMessage();", new Object[]{PApplicationException.class.getName()}).appendln('}');
                writer.appendln((CharSequence)"if (msg.unionField() != null) {").begin().appendln((CharSequence)"switch (msg.unionField()) {").begin();
                if (method.exceptions().length > 0) {
                    for (JField ex : method.exceptions()) {
                        writer.formatln("case %s:", new Object[]{ex.fieldEnum()}).formatln("    throw msg.%s();", new Object[]{ex.getter()});
                    }
                }
                if (method.getResponse() != null) {
                    writer.formatln("case %s:", new Object[]{method.getResponse().fieldEnum()});
                    if (method.getResponse().isVoid()) {
                        writer.formatln("    return;", new Object[0]);
                    } else {
                        writer.formatln("    return msg.%s();", new Object[]{method.getResponse().getter()});
                    }
                }
                writer.end().appendln((CharSequence)"}").end().appendln((CharSequence)"}").newline();
                writer.formatln("throw new %s(\"Result field for %s.%s() not set\",", new Object[]{PApplicationException.class.getName(), service.getService().getQualifiedName(null), method.name()}).formatln("          %s %s.%s);", new Object[]{PApplicationException.class.getName().replaceAll(".", " "), PApplicationExceptionType.class.getName(), PApplicationExceptionType.MISSING_RESULT.name()});
            }
            writer.end().appendln('}');
        }
        writer.end().appendln('}').newline();
    }

    private void appendProcessor(IndentedPrintWriter writer, JService service) throws GeneratorException {
        writer.formatln("public static class Processor implements %s {", new Object[]{PProcessor.class.getName()}).begin().appendln((CharSequence)"private final Iface impl;");
        writer.formatln("public Processor(Iface impl) {", new Object[0]).appendln((CharSequence)"    this.impl = impl;").appendln('}').newline();
        writer.appendln((CharSequence)"@Override").formatln("public %s getDescriptor() {", new Object[]{PService.class.getName()}).appendln((CharSequence)"    return kDescriptor;").appendln('}').newline();
        writer.appendln((CharSequence)"@Override").formatln("public <Request extends %s<Request, RequestField>,", new Object[]{PMessage.class.getName()}).formatln("        Response extends %s<Response, ResponseField>,", new Object[]{PMessage.class.getName()}).formatln("        RequestField extends %s,", new Object[]{PField.class.getName()}).formatln("        ResponseField extends %s>", new Object[]{PField.class.getName()}).formatln("%s<Response, ResponseField> handleCall(", new Object[]{PServiceCall.class.getName()}).formatln("        %s<Request, RequestField> call,", new Object[]{PServiceCall.class.getName()}).formatln("        %s service)", new Object[]{PService.class.getName()}).formatln("        throws %s,", new Object[]{IOException.class.getName()}).formatln("               %s {", new Object[]{SerializerException.class.getName()}).begin();
        writer.appendln((CharSequence)"switch(call.getMethod()) {").begin();
        for (JServiceMethod method : service.methods()) {
            writer.formatln("case \"%s\": {", new Object[]{method.name()}).begin();
            if (method.getResponseClass() != null) {
                writer.formatln("%s._Builder rsp = %s.builder();", new Object[]{method.getResponseClass(), method.getResponseClass()});
            }
            if (method.exceptions().length > 0) {
                writer.appendln((CharSequence)"try {").begin();
            }
            writer.formatln("%s req = (%s) call.getMessage();", new Object[]{method.getRequestClass(), method.getRequestClass()});
            String indent = "      " + Strings.times((String)" ", (int)method.methodName().length());
            if (method.getResponse() != null && !method.getResponse().isVoid()) {
                writer.formatln("%s result =", new Object[]{method.getResponse().valueType()});
                writer.appendln((CharSequence)"        ");
                indent = indent + "        ";
            } else {
                writer.appendln();
            }
            writer.format("impl.%s(", new Object[]{method.methodName()}).begin(indent);
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(',').appendln();
                }
                writer.format("req.%s()", new Object[]{param.getter()});
            }
            writer.end().append((CharSequence)");");
            if (method.getResponse() != null) {
                if (method.getResponse().isVoid()) {
                    writer.formatln("rsp.%s();", new Object[]{method.getResponse().setter()});
                } else {
                    writer.formatln("rsp.%s(result);", new Object[]{method.getResponse().setter()});
                }
            }
            if (method.exceptions().length > 0) {
                writer.end();
                for (JField ex : method.exceptions()) {
                    writer.formatln("} catch (%s e) {", new Object[]{ex.instanceType()}).begin().formatln("rsp.%s(e);", new Object[]{ex.setter()}).end();
                }
                writer.appendln('}');
            }
            if (method.getResponseClass() != null) {
                String spaces = PServiceCall.class.getName().replaceAll("[\\S]", " ");
                writer.formatln("%s reply =", new Object[]{PServiceCall.class.getName()}).formatln("        new %s<>(call.getMethod(),", new Object[]{PServiceCall.class.getName()}).formatln("            %s   %s.%s,", new Object[]{spaces, PServiceCallType.class.getName(), PServiceCallType.REPLY.name()}).formatln("            %s   call.getSequence(),", new Object[]{spaces}).formatln("            %s   rsp.build());", new Object[]{spaces}).appendln((CharSequence)"return reply;");
            } else {
                writer.appendln((CharSequence)"return null;");
            }
            writer.end().appendln('}');
        }
        writer.appendln((CharSequence)"default: {").begin().formatln("%s ex =", new Object[]{PApplicationException.class.getName()}).formatln("        new %s(", new Object[]{PApplicationException.class.getName()}).formatln("                \"Unknown method \\\"\" + call.getMethod() + \"\\\" on %s.\",", new Object[]{service.getService().getQualifiedName(null)}).formatln("                %s.%s);", new Object[]{PApplicationExceptionType.class.getName(), PApplicationExceptionType.UNKNOWN_METHOD.getName()});
        String spaces = PServiceCall.class.getName().replaceAll("[\\S]", " ");
        writer.formatln("%s reply =", new Object[]{PServiceCall.class.getName()}).formatln("        new %s(call.getMethod(),", new Object[]{PServiceCall.class.getName()}).formatln("            %s %s.%s,", new Object[]{spaces, PServiceCallType.class.getName(), PServiceCallType.EXCEPTION.name()}).formatln("            %s call.getSequence(),", new Object[]{spaces}).formatln("            %s ex);", new Object[]{spaces}).appendln((CharSequence)"return reply;");
        writer.end().appendln('}').end().appendln('}');
        writer.end().appendln('}');
        writer.end().appendln('}').newline();
    }

    private void appendDescriptor(IndentedPrintWriter writer, JService service) throws GeneratorException {
        writer.formatln("public enum Method implements %s {", new Object[]{PServiceMethod.class.getName()}).begin();
        for (JServiceMethod method : service.methods()) {
            String responseDesc = method.getResponseClass() == null ? "null" : method.getResponseClass() + ".kDescriptor";
            writer.formatln("%s(\"%s\", %b, %s.kDescriptor, %s),", new Object[]{method.constant(), method.name(), method.getMethod().isOneway(), method.getRequestClass(), responseDesc});
        }
        writer.appendln(';').newline();
        writer.appendln((CharSequence)"private final String name;").appendln((CharSequence)"private final boolean oneway;").formatln("private final %s request;", new Object[]{PStructDescriptor.class.getName()}).formatln("private final %s response;", new Object[]{PUnionDescriptor.class.getName()}).newline();
        writer.formatln("private Method(String name, boolean oneway, %s request, %s response) {", new Object[]{PStructDescriptor.class.getName(), PUnionDescriptor.class.getName()}).appendln((CharSequence)"    this.name = name;").appendln((CharSequence)"    this.oneway = oneway;").appendln((CharSequence)"    this.request = request;").appendln((CharSequence)"    this.response = response;").appendln('}').newline();
        writer.appendln((CharSequence)"public String getName() {").appendln((CharSequence)"    return name;").appendln('}').newline().appendln((CharSequence)"public boolean isOneway() {").appendln((CharSequence)"    return oneway;").appendln('}').newline().formatln("public %s getRequestType() {", new Object[]{PStructDescriptor.class.getName()}).formatln("    return request;", new Object[0]).appendln('}').newline().formatln("public %s getResponseType() {", new Object[]{PUnionDescriptor.class.getName()}).formatln("    return response;", new Object[0]).appendln('}').newline();
        writer.appendln((CharSequence)"public static Method forName(String name) {").begin().appendln((CharSequence)"switch (name) {").begin();
        for (JServiceMethod method : service.methods()) {
            writer.formatln("case \"%s\": return %s;", new Object[]{method.name(), method.constant()});
        }
        writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}');
        writer.end().appendln('}').newline();
        String inherits = "null";
        if (service.getService().getExtendsService() != null) {
            CService other = (CService)service.getService().getExtendsService();
            inherits = this.helper.getJavaPackage((PService)other) + "." + new JService(other, this.helper).className() + ".provider()";
        }
        writer.formatln("private static class _Descriptor extends %s {", new Object[]{PService.class.getName()}).begin().appendln((CharSequence)"private _Descriptor() {").formatln("    super(\"%s\", \"%s\", %s, Method.values());", new Object[]{service.getService().getPackageName(), service.getService().getName(), inherits}).appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public Method getMethod(String name) {").appendln((CharSequence)"    return Method.forName(name);").appendln((CharSequence)"}").end().appendln('}').newline();
        writer.formatln("private static class _Provider implements %s {", new Object[]{PServiceProvider.class.getName()}).begin().appendln((CharSequence)"@Override").formatln("public %s getService() {", new Object[]{PService.class.getName()}).appendln((CharSequence)"    return kDescriptor;").appendln((CharSequence)"}").end().appendln('}').newline();
        writer.formatln("public static final %s kDescriptor = new _Descriptor();", new Object[]{PService.class.getName()}).newline();
        writer.formatln("public static %s provider() {", new Object[]{PServiceProvider.class.getName()}).appendln((CharSequence)"    return new _Provider();").appendln('}').newline();
    }

    private void appendStructs(IndentedPrintWriter writer, JService service) throws GeneratorException, IOException {
        for (JServiceMethod method : service.methods()) {
            JMessage request = new JMessage(method.getMethod().getRequestType(), this.helper);
            writer.formatln("// type --> %s", new Object[]{request.descriptor().getName()});
            this.messageFormat.appendMessageClass((PStructDescriptor<?, ?>)method.getMethod().getRequestType());
            if (method.getMethod().getResponseType() == null) continue;
            JMessage response = new JMessage(method.getMethod().getResponseType(), this.helper);
            writer.formatln("// type <-- %s", new Object[]{response.descriptor().getName()});
            this.messageFormat.appendMessageClass((PStructDescriptor<?, ?>)method.getMethod().getResponseType());
        }
    }

    private void appendIface(IndentedPrintWriter writer, JService service) throws GeneratorException {
        String inherits = "";
        if (service.getService().getExtendsService() != null) {
            CService other = (CService)service.getService().getExtendsService();
            inherits = "extends " + this.helper.getJavaPackage((PService)other) + "." + new JService(other, this.helper).className() + ".Iface ";
        }
        writer.formatln("public interface Iface %s{", new Object[]{inherits}).begin();
        boolean firstMethod = true;
        for (JServiceMethod method : service.declaredMethods()) {
            JField ret;
            if (firstMethod) {
                firstMethod = false;
            } else {
                writer.newline();
            }
            if (method.getMethod().getDocumentation() != null) {
                new BlockCommentBuilder(writer).comment(method.getMethod().getDocumentation()).finish();
            }
            if ((ret = method.getResponse()) != null) {
                writer.appendln((CharSequence)ret.valueType());
            } else {
                writer.appendln((CharSequence)"void");
            }
            writer.format(" %s(", new Object[]{method.methodName()}).begin("        ");
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append((CharSequence)",");
                }
                writer.formatln("%s %s", new Object[]{param.valueType(), param.param()});
            }
            writer.end().format(")", new Object[0]).formatln("        throws %s", new Object[]{IOException.class.getName()}).begin("               ");
            for (JField ex : method.exceptions()) {
                writer.append((CharSequence)",");
                writer.appendln((CharSequence)ex.instanceType());
            }
            writer.format(";", new Object[0]).end();
        }
        writer.end().appendln('}').newline();
    }
}

