/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.util.Collection;
import java.util.Map;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.BaseConstantsFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.ValueBuilder;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.util.io.IndentedPrintWriter;

public class JavaConstantsFormatter
implements BaseConstantsFormatter {
    private static final String DBL_INDENT = "        ";
    private final JHelper helper;
    private final IndentedPrintWriter writer;

    public JavaConstantsFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public void appendConstantsClass(CProgram document) throws GeneratorException {
        ValueBuilder value = new ValueBuilder(this.writer, this.helper);
        if (document.getComment() != null) {
            new BlockCommentBuilder(this.writer).comment(document.getComment()).finish();
        }
        this.writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")").formatln("public class %s {", new Object[]{this.helper.getConstantsClassName(document)}).begin().formatln("private %s() {}", new Object[]{this.helper.getConstantsClassName(document)});
        block5: for (CField c : document.getConstants()) {
            this.writer.newline();
            String name = c.getName();
            JField constant = new JField(c, this.helper, 1);
            switch (c.getType()) {
                case MESSAGE: {
                    String instance = this.helper.getValueType(c.getDescriptor());
                    this.writer.formatln("public static final %s %s;", new Object[]{this.helper.getValueType(c.getDescriptor()), name}).appendln((CharSequence)"static {").begin().formatln("%s = %s.builder()", new Object[]{name, instance}).begin(DBL_INDENT);
                    PMessage message = (PMessage)c.getDefaultValue();
                    int i = 0;
                    for (PField f : message.descriptor().getFields()) {
                        CField cField = (CField)f;
                        JField field = new JField(cField, this.helper, i++);
                        if (!message.has(f.getKey())) continue;
                        this.writer.formatln(".%s(", new Object[]{field.setter()});
                        value.appendTypedValue(message.get(f.getKey()), f.getDescriptor());
                        this.writer.append((CharSequence)")");
                    }
                    this.writer.formatln(".build();", new Object[]{name}).end().end().appendln('}');
                    continue block5;
                }
                case LIST: 
                case SET: {
                    PContainer lDesc = (PContainer)c.getDescriptor();
                    PDescriptor itemDesc = lDesc.itemDescriptor();
                    this.writer.formatln("public static final %s %s;", new Object[]{this.helper.getValueType(c.getDescriptor()), name}).appendln((CharSequence)"static {").begin().formatln("%s = new %s<%s>()", new Object[]{name, constant.builderInstanceType(), this.helper.getFieldType(itemDesc)}).begin(DBL_INDENT);
                    Collection items = (Collection)c.getDefaultValue();
                    for (Object item : items) {
                        this.writer.appendln((CharSequence)".add(").begin();
                        value.appendTypedValue(item, itemDesc);
                        this.writer.end().append((CharSequence)")");
                    }
                    this.writer.formatln(".build();", new Object[]{name});
                    this.writer.end().end().appendln('}');
                    continue block5;
                }
                case MAP: {
                    JField field = new JField(c, this.helper, 1);
                    PMap mDesc = (PMap)c.getDescriptor();
                    PDescriptor itemDesc = mDesc.itemDescriptor();
                    PDescriptor keyDesc = mDesc.keyDescriptor();
                    this.writer.formatln("public static final %s %s;", new Object[]{this.helper.getValueType(c.getDescriptor()), name}).appendln((CharSequence)"static {").begin().formatln("%s = new %s<>()", new Object[]{name, field.builderInstanceType()}).begin(DBL_INDENT);
                    Map items = (Map)c.getDefaultValue();
                    for (Map.Entry item : items.entrySet()) {
                        this.writer.appendln((CharSequence)".put(").begin();
                        value.appendTypedValue(item.getKey(), keyDesc);
                        this.writer.append((CharSequence)", ");
                        value.appendTypedValue(item.getValue(), itemDesc);
                        this.writer.end().append((CharSequence)")");
                    }
                    this.writer.formatln(".build();", new Object[]{name});
                    this.writer.end().end().appendln('}');
                    continue block5;
                }
            }
            this.writer.formatln("public static final %s %s = ", new Object[]{this.helper.getValueType(c.getDescriptor()), c.getName()}).begin(DBL_INDENT);
            value.appendTypedValue(c.getDefaultValue(), c.getDescriptor());
            this.writer.append(';').end();
        }
        this.writer.end().appendln('}');
    }
}

