/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import net.morimekta.providence.PException;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JMessageAndroidFormat;
import net.morimekta.providence.generator.format.java.JMessageBuilderFormat;
import net.morimekta.providence.generator.format.java.JMessageOverridesFormat;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.ContainerType;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.generator.format.java.utils.ValueBuilder;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class JMessageFormat {
    private static final String DBL_INDENT = "        ";
    private final JHelper helper;
    private final JOptions options;

    JMessageFormat(JHelper helper, JOptions options) {
        this.helper = helper;
        this.options = options;
    }

    public void format(IndentedPrintWriter writer, PStructDescriptor<?, ?> descriptor) throws GeneratorException, IOException {
        this.format(writer, descriptor, null);
    }

    public void format(IndentedPrintWriter writer, PStructDescriptor<?, ?> descriptor, CService containingService) throws GeneratorException, IOException {
        JMessage message = new JMessage(descriptor, this.helper);
        JMessageAndroidFormat android = new JMessageAndroidFormat(writer, this.helper);
        JMessageOverridesFormat overrides = new JMessageOverridesFormat(writer, this.options, this.helper);
        JMessageBuilderFormat builder = new JMessageBuilderFormat(writer, this.helper, this.options);
        ValueBuilder values = new ValueBuilder(writer, this.helper);
        CAnnotatedDescriptor annotatedDescriptor = (CAnnotatedDescriptor)descriptor;
        if (annotatedDescriptor.getComment() != null) {
            new BlockCommentBuilder(writer).comment(annotatedDescriptor.getComment()).finish();
        }
        if (JAnnotation.isDeprecated(annotatedDescriptor)) {
            writer.appendln((CharSequence)"@Deprecated");
        }
        if (JAnnotation.isDeprecated(message.descriptor())) {
            writer.appendln((CharSequence)"@Deprecated");
        }
        String mod = "public";
        if (containingService != null) {
            mod = "private static";
        }
        writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")").formatln("%s class %s", new Object[]{mod, message.instanceType()}).begin(DBL_INDENT);
        if (message.variant().equals((Object)PMessageVariant.EXCEPTION)) {
            writer.appendln((CharSequence)("extends " + PException.class.getName()));
        }
        writer.formatln("implements %s<%s,%s._Field>, %s, Comparable<%s>", new Object[]{message.isUnion() ? PUnion.class.getName() : PMessage.class.getName(), message.instanceType(), message.instanceType(), Serializable.class.getName(), message.instanceType()});
        if (this.options.android) {
            writer.format(", android.os.Parcelable", new Object[0]);
        }
        writer.append((CharSequence)" {").end().begin();
        writer.formatln("private final static long serialVersionUID = %dL;", new Object[]{JUtils.generateSerialVersionUID(message.descriptor())}).newline();
        values.appendDefaultConstants(message.fields());
        this.appendFieldDeclarations(writer, message);
        this.appendBuilderConstructor(writer, message);
        this.appendCreateConstructor(writer, message);
        if (message.isException()) {
            this.appendCreateMessage(writer, message);
        }
        this.appendFieldGetters(writer, message);
        overrides.appendOverrides(message);
        this.appendFieldEnum(writer, message);
        this.appendDescriptor(writer, message);
        if (this.options.android) {
            android.appendParcelable(message);
        }
        builder.appendBuilder(message);
        writer.end().appendln('}').newline();
    }

    private void appendFieldEnum(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        writer.formatln("public enum _Field implements %s {", new Object[]{PField.class.getName()}).begin();
        for (JField field : message.fields()) {
            String provider = field.getProvider();
            String defValue = "null";
            if (field.getPField().hasDefaultValue()) {
                defValue = String.format("new %s<>(%s)", PDefaultValueProvider.class.getName(), field.kDefault());
            }
            writer.formatln("%s(%d, %s.%s, \"%s\", %s, %s),", new Object[]{field.fieldEnum(), field.id(), PRequirement.class.getName(), field.getPField().getRequirement().name(), field.name(), provider, defValue});
        }
        writer.appendln(';').newline();
        writer.appendln((CharSequence)"private final int mKey;").formatln("private final %s mRequired;", new Object[]{PRequirement.class.getName()}).appendln((CharSequence)"private final String mName;").formatln("private final %s mTypeProvider;", new Object[]{PDescriptorProvider.class.getName()}).formatln("private final %s<?> mDefaultValue;", new Object[]{PValueProvider.class.getName()}).newline().formatln("_Field(int key, %s required, String name, %s typeProvider, %s<?> defaultValue) {", new Object[]{PRequirement.class.getName(), PDescriptorProvider.class.getName(), PValueProvider.class.getName()}).begin().appendln((CharSequence)"mKey = key;").appendln((CharSequence)"mRequired = required;").appendln((CharSequence)"mName = name;").appendln((CharSequence)"mTypeProvider = typeProvider;").appendln((CharSequence)"mDefaultValue = defaultValue;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getKey() { return mKey; }").newline();
        writer.appendln((CharSequence)"@Override").formatln("public %s getRequirement() { return mRequired; }", new Object[]{PRequirement.class.getName()}).newline();
        writer.appendln((CharSequence)"@Override").formatln("public %s getDescriptor() { return mTypeProvider.descriptor(); }", new Object[]{PDescriptor.class.getName()}).newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String getName() { return mName; }").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean hasDefaultValue() { return mDefaultValue != null; }").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public Object getDefaultValue() {").appendln((CharSequence)"    return hasDefaultValue() ? mDefaultValue.get() : null;").appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String toString() {").formatln("    return %s.toString(this);", new Object[]{PField.class.getName()}).appendln('}').newline();
        writer.appendln((CharSequence)"public static _Field forKey(int key) {").begin().appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.fields()) {
            writer.formatln("case %d: return _Field.%s;", new Object[]{field.id(), field.fieldEnum()});
        }
        writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}').newline();
        writer.appendln((CharSequence)"public static _Field forName(String name) {").begin().appendln((CharSequence)"switch (name) {").begin();
        for (JField field : message.fields()) {
            writer.formatln("case \"%s\": return _Field.%s;", new Object[]{field.name(), field.fieldEnum()});
        }
        writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}');
        writer.end().appendln('}').newline();
    }

    private void appendDescriptor(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        String typeClass = message.getDescriptorClass();
        String providerClass = message.getProviderClass();
        writer.formatln("public static %s<%s,_Field> provider() {", new Object[]{providerClass, message.instanceType()}).begin().formatln("return new _Provider();", new Object[0]).end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").formatln("public %s<%s,_Field> descriptor() {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').newline();
        writer.formatln("public static final %s<%s,_Field> kDescriptor;", new Object[]{typeClass, message.instanceType()}).newline();
        writer.formatln("private static class _Descriptor", new Object[0]).formatln("        extends %s<%s,_Field> {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"public _Descriptor() {").begin();
        if (message.isException() || message.isUnion()) {
            writer.formatln("super(\"%s\", \"%s\", new _Factory(), %s);", new Object[]{message.descriptor().getPackageName(), message.descriptor().getName(), message.descriptor().isSimple()});
        } else {
            writer.formatln("super(\"%s\", \"%s\", new _Factory(), %b, %b);", new Object[]{message.descriptor().getPackageName(), message.descriptor().getName(), message.descriptor().isSimple(), message.descriptor().isCompactible()});
        }
        writer.end().appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field[] getFields() {").begin().appendln((CharSequence)"return _Field.values();").end().appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field getField(String name) {").begin().appendln((CharSequence)"return _Field.forName(name);").end().appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field getField(int key) {").begin().appendln((CharSequence)"return _Field.forKey(key);").end().appendln('}').end().appendln('}').newline();
        writer.formatln("static {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"kDescriptor = new _Descriptor();").end().appendln('}').newline();
        writer.formatln("private final static class _Provider extends %s<%s,_Field> {", new Object[]{providerClass, message.instanceType()}).begin().appendln((CharSequence)"@Override").formatln("public %s<%s,_Field> descriptor() {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').end().appendln((CharSequence)"}").newline();
        writer.appendln((CharSequence)"private final static class _Factory").begin().formatln("    extends %s<%s,_Field> {", new Object[]{PMessageBuilderFactory.class.getName(), message.instanceType()}).appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder builder() {").begin().appendln((CharSequence)"return new _Builder();").end().appendln('}').end().appendln('}').newline();
    }

    private void appendFieldGetters(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        for (JField field : message.fields()) {
            if (message.isUnion()) {
                if (field.container()) {
                    writer.formatln("public int %s() {", new Object[]{field.counter()}).formatln("    return tUnionField == _Field.%s ? %s.size() : 0;", new Object[]{field.fieldEnum(), field.member()}).appendln('}').newline();
                }
                if (field.alwaysPresent()) {
                    writer.formatln("public boolean %s() {", new Object[]{field.presence()}).formatln("    return tUnionField == _Field.%s;", new Object[]{field.fieldEnum()}).appendln('}').newline();
                } else {
                    writer.formatln("public boolean %s() {", new Object[]{field.presence()}).formatln("    return tUnionField == _Field.%s && %s != null;", new Object[]{field.fieldEnum(), field.member()}).appendln('}').newline();
                }
            } else {
                if (field.container()) {
                    writer.formatln("public int %s() {", new Object[]{field.counter()}).formatln("    return %s != null ? %s.size() : 0;", new Object[]{field.member(), field.member()}).appendln('}').newline();
                }
                if (field.alwaysPresent()) {
                    writer.formatln("public boolean %s() {", new Object[]{field.presence()}).begin().formatln("return true;", new Object[0]).end().appendln('}').newline();
                } else {
                    writer.formatln("public boolean %s() {", new Object[]{field.presence()}).begin().formatln("return %s != null;", new Object[]{field.member()}).end().appendln('}').newline();
                }
            }
            BlockCommentBuilder comment = new BlockCommentBuilder(writer);
            if (field.hasComment()) {
                comment.comment(field.comment()).newline();
            }
            comment.return_("The field value").finish();
            if (JAnnotation.isDeprecated(field)) {
                writer.appendln((CharSequence)"@Deprecated");
            }
            writer.formatln("public %s %s() {", new Object[]{field.valueType(), field.getter()});
            if (!field.container() && !field.alwaysPresent() && field.getPField().hasDefaultValue()) {
                writer.formatln("    return %s() ? %s : %s;", new Object[]{field.presence(), field.member(), field.kDefault()});
            } else {
                writer.formatln("    return %s;", new Object[]{field.member()});
            }
            writer.appendln('}').newline();
        }
        if (message.isUnion()) {
            writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field unionField() {").appendln((CharSequence)"    return tUnionField;").appendln('}').newline();
        }
    }

    private void appendFieldDeclarations(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        for (JField field : message.fields()) {
            writer.formatln("private final %s %s;", new Object[]{field.fieldType(), field.member()});
        }
        if (message.isUnion()) {
            writer.newline().appendln((CharSequence)"private final _Field tUnionField;");
        }
        writer.appendln().appendln((CharSequence)"private volatile int tHashCode;").newline();
    }

    private void appendBuilderConstructor(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        writer.formatln("private %s(_Builder builder) {", new Object[]{message.instanceType()}).begin();
        if (message.isUnion()) {
            writer.appendln((CharSequence)"tUnionField = builder.tUnionField;").newline();
            block6: for (JField jField : message.fields()) {
                switch (jField.type()) {
                    case LIST: {
                        writer.formatln("%s = tUnionField == _Field.%s ? builder.%s.build() : null;", new Object[]{jField.member(), jField.fieldEnum(), jField.member()});
                        continue block6;
                    }
                    case SET: {
                        writer.formatln("%s = tUnionField == _Field.%s ? builder.%s.build() : null;", new Object[]{jField.member(), jField.fieldEnum(), jField.member()});
                        continue block6;
                    }
                    case MAP: {
                        writer.formatln("%s = tUnionField == _Field.%s ? builder.%s.build() : null;", new Object[]{jField.member(), jField.fieldEnum(), jField.member()});
                        continue block6;
                    }
                    case MESSAGE: {
                        writer.formatln("%s = tUnionField != _Field.%s", new Object[]{jField.member(), jField.fieldEnum()}).appendln((CharSequence)"        ? null").formatln("        : builder.%s_builder != null ? builder.%s_builder.build() : builder.%s;", new Object[]{jField.member(), jField.member(), jField.member()});
                        continue block6;
                    }
                }
                if (jField.alwaysPresent()) {
                    writer.formatln("%s = tUnionField == _Field.%s ? builder.%s : %s;", new Object[]{jField.member(), jField.fieldEnum(), jField.member(), jField.kDefault()});
                    continue;
                }
                writer.formatln("%s = tUnionField == _Field.%s ? builder.%s : null;", new Object[]{jField.member(), jField.fieldEnum(), jField.member()});
            }
        } else {
            if (message.isException()) {
                writer.appendln((CharSequence)"super(createMessage(").begin("                    ");
                boolean first = true;
                for (JField field : message.fields()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',').appendln();
                    }
                    if (field.container()) {
                        writer.format("builder.%s() ? builder.%s.build() : null", new Object[]{field.isSet(), field.member()});
                        continue;
                    }
                    writer.format("builder.%s", new Object[]{field.member()});
                }
                writer.append((CharSequence)"));").end().newline();
            }
            for (JField jField : message.fields()) {
                if (jField.container()) {
                    writer.formatln("if (builder.%s()) {", new Object[]{jField.isSet()}).formatln("    %s = builder.%s.build();", new Object[]{jField.member(), jField.member()}).appendln((CharSequence)"} else {").formatln("    %s = null;", new Object[]{jField.member()}).appendln('}');
                    continue;
                }
                if (jField.type() == PType.MESSAGE) {
                    writer.formatln("%s = builder.%s_builder != null ? builder.%s_builder.build() : builder.%s;", new Object[]{jField.member(), jField.member(), jField.member(), jField.member()});
                    continue;
                }
                writer.formatln("%s = builder.%s;", new Object[]{jField.member(), jField.member()});
            }
        }
        writer.end().appendln('}').newline();
    }

    private void appendCreateMessage(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        writer.appendln((CharSequence)"private static String createMessage(").begin("                                    ");
        boolean first = true;
        for (JField fld : message.fields()) {
            if (first) {
                first = false;
            } else {
                writer.append(',').appendln();
            }
            writer.format("%s %s", new Object[]{fld.valueType(), fld.param()});
        }
        writer.append((CharSequence)") {").end().begin().appendln((CharSequence)"StringBuilder out = new StringBuilder();").appendln((CharSequence)"out.append('{');");
        boolean firstFirstCheck = true;
        boolean alwaysAfter = false;
        JField[] fields = message.fields().toArray(new JField[message.fields().size()]);
        for (int i = 0; i < fields.length; ++i) {
            first = i == 0;
            boolean last = i == fields.length - 1;
            JField field = fields[i];
            if (!field.alwaysPresent()) {
                if (!alwaysAfter && firstFirstCheck && !last) {
                    writer.appendln((CharSequence)"boolean first = true;");
                }
                if (field.container()) {
                    writer.formatln("if (%s != null && %s.size() > 0) {", new Object[]{field.param(), field.param()});
                } else {
                    writer.formatln("if (%s != null) {", new Object[]{field.param()});
                }
                writer.begin();
            }
            if (alwaysAfter) {
                writer.appendln((CharSequence)"out.append(',');");
            } else if (!field.alwaysPresent()) {
                if (firstFirstCheck || first) {
                    if (!last) {
                        writer.appendln((CharSequence)"first = false;");
                    }
                } else if (last) {
                    writer.appendln((CharSequence)"if (!first) out.append(',');");
                } else {
                    writer.appendln((CharSequence)"if (first) first = false;").appendln((CharSequence)"else out.append(',');");
                }
            }
            writer.formatln("out.append(\"%s:\")", new Object[]{field.name()});
            switch (field.type()) {
                case BOOL: 
                case I32: 
                case I64: {
                    writer.formatln("   .append(%s);", new Object[]{field.param()});
                    break;
                }
                case BYTE: 
                case I16: {
                    writer.formatln("   .append((int) %s);", new Object[]{field.param()});
                    break;
                }
                case LIST: 
                case SET: 
                case MAP: 
                case DOUBLE: {
                    writer.formatln("   .append(%s.asString(%s));", new Object[]{Strings.class.getName(), field.param()});
                    break;
                }
                case STRING: {
                    writer.formatln("   .append('\\\"')", new Object[0]).formatln("   .append(%s.escape(%s))", new Object[]{Strings.class.getName(), field.param()}).appendln((CharSequence)"   .append('\\\"');");
                    break;
                }
                case BINARY: {
                    writer.appendln((CharSequence)"   .append(\"b64(\")").formatln("   .append(%s.toBase64())", new Object[]{field.param()}).appendln((CharSequence)"   .append(')');");
                    break;
                }
                case MESSAGE: {
                    writer.formatln("   .append(%s.asString());", new Object[]{field.param()});
                    break;
                }
                default: {
                    writer.formatln("   .append(%s.toString());", new Object[]{field.param()});
                }
            }
            if (!field.alwaysPresent()) {
                writer.end().appendln('}');
                if (alwaysAfter || !firstFirstCheck) continue;
                firstFirstCheck = false;
                continue;
            }
            alwaysAfter = true;
        }
        writer.appendln((CharSequence)"out.append('}');").appendln((CharSequence)"return out.toString();").end().appendln('}').newline();
    }

    private void appendCreateConstructor(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            for (JField field : message.fields()) {
                BlockCommentBuilder block = new BlockCommentBuilder(writer);
                if (field.hasComment()) {
                    block.comment(field.comment());
                }
                block.param_("value", "The union value").return_("The created union.").finish();
                writer.formatln("public static %s %s(%s value) {", new Object[]{message.instanceType(), JUtils.camelCase("with", field.name()), field.valueType()}).begin().formatln("return new _Builder().%s(value).build();", new Object[]{field.setter()}).end().appendln('}').newline();
            }
        } else {
            String spaces = message.instanceType().replaceAll("[\\S]", " ");
            writer.formatln("public %s(", new Object[]{message.instanceType()}).begin(DBL_INDENT + spaces);
            boolean first = true;
            for (JField field : message.fields()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(',').appendln();
                }
                writer.format("%s %s", new Object[]{field.valueType(), field.param()});
            }
            writer.end().append((CharSequence)") {").begin();
            if (message.isException()) {
                writer.appendln((CharSequence)"super(createMessage(").begin("                    ");
                first = true;
                for (JField field : message.fields()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',').appendln();
                    }
                    writer.format("%s", new Object[]{field.param()});
                }
                writer.append((CharSequence)"));").end().newline();
            }
            block8: for (JField field : message.fields()) {
                switch (field.type()) {
                    case LIST: {
                        writer.formatln("if (%s != null) {", new Object[]{field.param()}).formatln("    %s = %s.copyOf(%s);", new Object[]{field.member(), field.fieldInstanceType(), field.param()}).appendln((CharSequence)"} else {").formatln("    %s = null;", new Object[]{field.member()}).appendln('}');
                        continue block8;
                    }
                    case SET: {
                        writer.formatln("if (%s != null) {", new Object[]{field.param()}).begin();
                        if (field.containerType() == ContainerType.ORDERED) {
                            writer.formatln("%s = %s.unmodifiableSet(%s);", new Object[]{field.member(), Collections.class.getName(), field.param()});
                        } else {
                            writer.formatln("%s = %s.copyOf(%s);", new Object[]{field.member(), field.fieldInstanceType(), field.param()});
                        }
                        writer.end().appendln((CharSequence)"} else {").formatln("    %s = null;", new Object[]{field.member()}).appendln('}');
                        continue block8;
                    }
                    case MAP: {
                        writer.formatln("if (%s != null) {", new Object[]{field.param()}).begin();
                        if (field.containerType() == ContainerType.ORDERED) {
                            writer.formatln("%s = %s.unmodifiableMap(%s);", new Object[]{field.member(), Collections.class.getName(), field.param()});
                        } else {
                            writer.formatln("%s = %s.copyOf(%s);", new Object[]{field.member(), field.fieldInstanceType(), field.param()});
                        }
                        writer.end().appendln((CharSequence)"} else {").formatln("    %s = null;", new Object[]{field.member()}).appendln('}');
                        continue block8;
                    }
                }
                writer.formatln("%s = %s;", new Object[]{field.member(), field.param()});
            }
            writer.end().appendln('}').newline();
        }
    }
}

