/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.util.BitSet;
import java.util.Collection;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class JMessageBuilderFormat {
    private final JOptions options;
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public JMessageBuilderFormat(IndentedPrintWriter writer, JHelper helper, JOptions options) {
        this.writer = writer;
        this.helper = helper;
        this.options = options;
    }

    public void appendBuilder(JMessage<?> message) throws GeneratorException {
        this.appendMutators(message);
        if (JAnnotation.isDeprecated(message.descriptor())) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        this.writer.appendln((CharSequence)"public static class _Builder").begin().formatln("    extends %s<%s,_Field> {", new Object[]{PMessageBuilder.class.getName(), message.instanceType()});
        this.appendFields(message);
        this.appendDefaultConstructor(message);
        this.appendMutateConstructor(message);
        this.appendMerge(message);
        for (JField field : message.fields()) {
            this.appendSetter(message, field);
            if (field.container()) {
                this.appendAdder(message, field);
            }
            this.appendIsSet(message, field);
            this.appendResetter(message, field);
            this.appendMutableGetters(message, field);
        }
        this.appendOverrideMutator(message);
        this.appendOverrideSetter(message);
        this.appendOverrideAdder(message);
        this.appendOverrideResetter(message);
        this.appendOverrideIsValid(message);
        this.appendOverrideDescriptor(message);
        this.writer.appendln((CharSequence)"@Override").formatln("public %s build() {", new Object[]{message.instanceType()}).begin().formatln("return new %s(this);", new Object[]{message.instanceType()}).end().appendln('}');
        this.writer.end().appendln('}');
    }

    private void appendMutators(JMessage message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder mutate() {").begin().appendln((CharSequence)"return new _Builder(this);").end().appendln('}').newline();
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a " + message.descriptor().getQualifiedName(null) + " builder.").return_("The builder instance.").finish();
        this.writer.formatln("public static _Builder builder() {", new Object[0]).begin().appendln((CharSequence)"return new _Builder();").end().appendln('}').newline();
    }

    private void appendFields(JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"private _Field tUnionField;");
        } else {
            this.writer.formatln("private %s optionals;", new Object[]{BitSet.class.getName()});
        }
        this.writer.newline();
        for (JField field : message.fields()) {
            this.writer.formatln("private %s %s;", new Object[]{field.builderFieldType(), field.member()});
            if (field.type() != PType.MESSAGE) continue;
            this.writer.formatln("private %s._Builder %s_builder;", new Object[]{field.builderFieldType(), field.member()});
        }
        if (message.fields().size() > 0) {
            this.writer.newline();
        }
    }

    private void appendDefaultConstructor(JMessage<?> message) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a " + message.descriptor().getQualifiedName(null) + " builder.").finish();
        this.writer.appendln((CharSequence)"public _Builder() {").begin();
        if (!message.isUnion()) {
            this.writer.formatln("optionals = new %s(%d);", new Object[]{BitSet.class.getName(), message.fields().size()});
        }
        for (JField field : message.fields()) {
            if (field.container()) {
                this.writer.formatln("%s = new %s<>();", new Object[]{field.member(), field.builderInstanceType()});
                continue;
            }
            if (!field.alwaysPresent()) continue;
            this.writer.formatln("%s = %s;", new Object[]{field.member(), field.kDefault()});
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendMutateConstructor(JMessage<?> message) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a mutating builder off a base " + message.descriptor().getQualifiedName(null) + ".").newline().param_("base", "The base " + message.descriptor().getName()).finish();
        this.writer.formatln("public _Builder(%s base) {", new Object[]{message.instanceType()}).begin().appendln((CharSequence)"this();").newline();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"tUnionField = base.tUnionField;").newline();
        }
        for (JField field : message.fields()) {
            boolean checkPresence;
            boolean bl = message.isUnion() ? field.container() : (checkPresence = !field.alwaysPresent());
            if (checkPresence) {
                if (field.container()) {
                    this.writer.formatln("if (base.%s() > 0) {", new Object[]{field.counter()}).begin();
                } else {
                    this.writer.formatln("if (base.%s()) {", new Object[]{field.presence()}).begin();
                }
            }
            if (!message.isUnion()) {
                this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
            }
            switch (field.type()) {
                case LIST: 
                case SET: {
                    this.writer.formatln("%s.addAll(base.%s);", new Object[]{field.member(), field.member()});
                    break;
                }
                case MAP: {
                    this.writer.formatln("%s.putAll(base.%s);", new Object[]{field.member(), field.member()});
                    break;
                }
                default: {
                    this.writer.formatln("%s = base.%s;", new Object[]{field.member(), field.member()});
                }
            }
            if (!checkPresence) continue;
            this.writer.end().appendln('}');
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendMerge(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").formatln("public _Builder merge(%s from) {", new Object[]{message.instanceType()}).begin();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"if (from.unionField() == null) {").appendln((CharSequence)"    return this;").appendln((CharSequence)"}").newline().appendln((CharSequence)"switch (from.unionField()) {").begin();
            for (JField field : message.fields()) {
                this.writer.formatln("case %s: {", new Object[]{field.fieldEnum()}).begin();
                switch (field.type()) {
                    case MESSAGE: {
                        this.writer.formatln("if (tUnionField == _Field.%s && %s != null) {", new Object[]{field.fieldEnum(), field.member()}).formatln("    %s = %s.mutate().merge(from.%s()).build();", new Object[]{field.member(), field.member(), field.getter()}).appendln((CharSequence)"} else {").formatln("    %s(from.%s());", new Object[]{field.setter(), field.getter()}).appendln('}');
                        break;
                    }
                    case SET: {
                        this.writer.formatln("if (tUnionField == _Field.%s) {", new Object[]{field.fieldEnum()}).formatln("    %s.addAll(from.%s()):", new Object[]{field.member(), field.getter()}).appendln((CharSequence)"} else {").formatln("    %s(from.%s());", new Object[]{field.setter(), field.getter()}).appendln('}');
                        break;
                    }
                    case MAP: {
                        this.writer.formatln("if (tUnionField == _Field.%s) {", new Object[]{field.fieldEnum()}).formatln("    %s.putAll(from.%s()):", new Object[]{field.member(), field.getter()}).appendln((CharSequence)"} else {").formatln("    %s(from.%s());", new Object[]{field.setter(), field.getter()}).appendln('}');
                        break;
                    }
                    default: {
                        this.writer.formatln("%s(from.%s());", new Object[]{field.setter(), field.getter()});
                    }
                }
                this.writer.appendln((CharSequence)"break;").end().appendln('}');
            }
            this.writer.end().appendln('}');
        } else {
            boolean first = true;
            for (JField field : message.fields()) {
                if (first) {
                    first = false;
                } else {
                    this.writer.newline();
                }
                if (!field.alwaysPresent()) {
                    this.writer.formatln("if (from.%s()) {", new Object[]{field.presence()}).begin();
                }
                this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                switch (field.type()) {
                    case MESSAGE: {
                        this.writer.formatln("if (%s_builder != null) {", new Object[]{field.member()}).formatln("    %s_builder.merge(from.%s());", new Object[]{field.member(), field.getter()}).formatln("} else if (%s != null) {", new Object[]{field.member()}).formatln("    %s_builder = %s.mutate().merge(from.%s());", new Object[]{field.member(), field.member(), field.getter()}).formatln("    %s = null;", new Object[]{field.member()}).appendln((CharSequence)"} else {").formatln("    %s = from.%s();", new Object[]{field.member(), field.getter()}).appendln('}');
                        break;
                    }
                    case SET: {
                        this.writer.formatln("%s.addAll(from.%s());", new Object[]{field.member(), field.getter()});
                        break;
                    }
                    case MAP: {
                        this.writer.formatln("%s.putAll(from.%s());", new Object[]{field.member(), field.getter()});
                        break;
                    }
                    case LIST: {
                        this.writer.formatln("%s.clear();", new Object[]{field.member()});
                        this.writer.formatln("%s.addAll(from.%s());", new Object[]{field.member(), field.getter()});
                        break;
                    }
                    default: {
                        this.writer.formatln("%s = from.%s();", new Object[]{field.member(), field.getter()});
                    }
                }
                if (field.alwaysPresent()) continue;
                this.writer.end().appendln('}');
            }
        }
        this.writer.appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendSetter(JMessage message, JField field) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Sets the value of " + field.name() + ".").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.param_("value", "The new value").return_("The builder").finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        if (field.type() == PType.SET || field.type() == PType.LIST) {
            PContainer cType = (PContainer)field.getPField().getDescriptor();
            String iType = this.helper.getFieldType(cType.itemDescriptor());
            this.writer.formatln("public _Builder %s(%s<%s> value) {", new Object[]{field.setter(), Collection.class.getName(), iType});
        } else {
            this.writer.formatln("public _Builder %s(%s value) {", new Object[]{field.setter(), field.valueType()});
        }
        this.writer.begin();
        if (message.isUnion()) {
            this.writer.formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
        } else {
            this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
        }
        switch (field.type()) {
            case LIST: 
            case SET: {
                this.writer.formatln("%s.clear();", new Object[]{field.member()}).formatln("%s.addAll(value);", new Object[]{field.member()});
                break;
            }
            case MAP: {
                this.writer.formatln("%s.clear();", new Object[]{field.member()}).formatln("%s.putAll(value);", new Object[]{field.member()});
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s_builder = null;", new Object[]{field.member()});
            }
            default: {
                this.writer.formatln("%s = value;", new Object[]{field.member()});
            }
        }
        this.writer.appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendAdder(JMessage message, JField field) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        if (field.type() == PType.MAP) {
            comment.comment("Adds a mapping to " + field.name() + ".").newline();
        } else {
            comment.comment("Adds entries to " + field.name() + ".").newline();
        }
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        if (field.type() == PType.MAP) {
            comment.param_("key", "The inserted key").param_("value", "The inserted value");
        } else {
            comment.param_("values", "The added value");
        }
        comment.return_("The builder").finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        switch (field.type()) {
            case MAP: {
                PMap mType = (PMap)field.getPField().getDescriptor();
                String mkType = this.helper.getValueType(mType.keyDescriptor());
                String miType = this.helper.getValueType(mType.itemDescriptor());
                this.writer.formatln("public _Builder %s(%s key, %s value) {", new Object[]{field.adder(), mkType, miType}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                }
                this.writer.formatln("%s.put(key, value);", new Object[]{field.member()}).appendln((CharSequence)"return this;").end().appendln('}').newline();
                break;
            }
            case LIST: 
            case SET: {
                PContainer lType = (PContainer)field.getPField().getDescriptor();
                String liType = this.helper.getValueType(lType.itemDescriptor());
                this.writer.formatln("public _Builder %s(%s... values) {", new Object[]{field.adder(), liType}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                }
                this.writer.formatln("for (%s item : values) {", new Object[]{liType}).begin().formatln("%s.add(item);", new Object[]{field.member()}).end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
                break;
            }
        }
    }

    private void appendIsSet(JMessage message, JField field) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Checks for presence of the " + field.name() + " field.").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.return_(String.format("True iff %s has been set.", field.name())).finish();
        this.writer.formatln("public boolean %s() {", new Object[]{field.isSet()}).begin();
        if (message.isUnion()) {
            this.writer.formatln("return tUnionField == _Field.%s;", new Object[]{field.fieldEnum()});
        } else {
            this.writer.formatln("return optionals.get(%d);", new Object[]{field.index()});
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendResetter(JMessage message, JField field) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Clears the " + field.name() + " field.").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.return_("The builder").finish();
        this.writer.formatln("public _Builder %s() {", new Object[]{field.resetter()}).begin();
        if (message.isUnion()) {
            this.writer.formatln("if (tUnionField == _Field.%s) tUnionField = null;", new Object[]{field.fieldEnum()});
        } else {
            this.writer.formatln("optionals.clear(%d);", new Object[]{field.index()});
        }
        if (field.container()) {
            this.writer.formatln("%s.clear();", new Object[]{field.member()});
        } else if (field.alwaysPresent()) {
            this.writer.formatln("%s = %s;", new Object[]{field.member(), field.kDefault()});
        } else {
            this.writer.formatln("%s = null;", new Object[]{field.member()});
            if (field.type() == PType.MESSAGE) {
                this.writer.formatln("%s_builder = null;", new Object[]{field.member()});
            }
        }
        this.writer.appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendMutableGetters(JMessage message, JField field) throws GeneratorException {
        if (field.getPField().getDescriptor() instanceof PPrimitive || field.type() == PType.ENUM) {
            return;
        }
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Gets the builder for the contained " + field.name() + ".").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.return_("The field builder").finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        switch (field.type()) {
            case MESSAGE: {
                this.writer.formatln("public %s._Builder %s() {", new Object[]{field.instanceType(), Strings.camelCase((String)"mutable", (String)field.name())}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("if (tUnionField != _Field.%s) {", new Object[]{field.fieldEnum()}).formatln("    %s();", new Object[]{field.resetter()}).appendln('}').formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                }
                this.writer.newline().formatln("if (%s != null) {", new Object[]{field.member()}).formatln("    %s_builder = %s.mutate();", new Object[]{field.member(), field.member()}).formatln("    %s = null;", new Object[]{field.member()}).formatln("} else if (%s_builder == null) {", new Object[]{field.member()}).formatln("    %s_builder = %s.builder();", new Object[]{field.member(), field.instanceType()}).appendln('}').formatln("return %s_builder;", new Object[]{field.member()});
                this.writer.end().appendln('}').newline();
                break;
            }
            case LIST: 
            case SET: 
            case MAP: {
                this.writer.formatln("public %s %s() {", new Object[]{field.builderFieldType(), Strings.camelCase((String)"mutable", (String)field.name())}).begin();
                this.writer.formatln("return %s;", new Object[]{field.member()});
                this.writer.end().appendln('}').newline();
                break;
            }
            default: {
                throw new GeneratorException("Unexpected field type: " + field.type());
            }
        }
    }

    private void appendOverrideMutator(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@SuppressWarnings(\"unchecked\")").formatln("public %s mutator(int key) {", new Object[]{PMessageBuilder.class.getName()}).begin().appendln((CharSequence)"switch (key) {").begin();
        message.fields().stream().filter(field -> field.type() == PType.MESSAGE).forEachOrdered(field -> this.writer.formatln("case %d: return %s();", new Object[]{field.id(), Strings.camelCase((String)"mutable", (String)field.name())}));
        this.writer.appendln((CharSequence)"default: throw new IllegalArgumentException(\"Not a message field ID: \" + key);").end().appendln('}').end().appendln('}').newline();
    }

    private void appendOverrideSetter(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@SuppressWarnings(\"unchecked\")").appendln((CharSequence)"public _Builder set(int key, Object value) {").begin().appendln((CharSequence)"if (value == null) return clear(key);").appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.fields()) {
            this.writer.formatln("case %d: %s((%s) value); break;", new Object[]{field.id(), field.setter(), field.valueType()});
        }
        this.writer.end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendOverrideAdder(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder addTo(int key, Object value) {").begin().appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.fields()) {
            if (field.type() != PType.LIST && field.type() != PType.SET) continue;
            PContainer ct = (PContainer)field.getPField().getDescriptor();
            PDescriptor itype = ct.itemDescriptor();
            this.writer.formatln("case %d: %s((%s) value); break;", new Object[]{field.id(), field.adder(), this.helper.getValueType(itype)});
        }
        this.writer.appendln((CharSequence)"default: break;").end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendOverrideResetter(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder clear(int key) {").begin().appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.fields()) {
            this.writer.formatln("case %d: %s(); break;", new Object[]{field.id(), field.resetter()});
        }
        this.writer.end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendOverrideIsValid(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean isValid() {").begin();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"if (tUnionField == null) {").appendln((CharSequence)"    return false;").appendln('}').newline().appendln((CharSequence)"switch (tUnionField) {").begin();
            for (JField field : message.fields()) {
                if (field.alwaysPresent()) continue;
                if (field.type() == PType.MESSAGE) {
                    this.writer.formatln("case %s: return %s != null || %s_builder != null;", new Object[]{field.fieldEnum(), field.member(), field.member()});
                    continue;
                }
                this.writer.formatln("case %s: return %s != null;", new Object[]{field.fieldEnum(), field.member()});
            }
            this.writer.appendln((CharSequence)"default: return true;").end().appendln('}');
        } else {
            this.writer.appendln((CharSequence)"return ").begin("       ");
            boolean first = true;
            for (JField field : message.fields()) {
                if (!field.isRequired()) continue;
                if (first) {
                    first = false;
                } else {
                    this.writer.append((CharSequence)" &&").appendln((CharSequence)"");
                }
                this.writer.format("optionals.get(%d)", new Object[]{field.index()});
            }
            if (first) {
                this.writer.append((CharSequence)"true");
            }
            this.writer.end().append(';');
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendOverrideDescriptor(JMessage<?> message) throws GeneratorException {
        String typeClass = message.getDescriptorClass();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s<%s,_Field> descriptor() {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').newline();
    }
}

