/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.generator.Generator;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JConstantsFormat;
import net.morimekta.providence.generator.format.java.JEnumFormat;
import net.morimekta.providence.generator.format.java.JMessageFormat;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.JServiceFormat;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.generator.util.FileManager;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.util.TypeRegistry;
import net.morimekta.util.io.IndentedPrintWriter;

public class JGenerator
extends Generator {
    private final JHelper helper;
    private final JMessageFormat messageFormatter;
    private final JEnumFormat enumFormatter;
    private final JServiceFormat serviceFormatter;
    private final JConstantsFormat constFormat;

    public JGenerator(FileManager manager, TypeRegistry registry, JOptions options) throws GeneratorException {
        super(manager);
        this.helper = new JHelper(registry);
        this.messageFormatter = new JMessageFormat(this.helper, options);
        this.enumFormatter = new JEnumFormat(options);
        this.serviceFormatter = new JServiceFormat(this.helper, this.messageFormatter);
        this.constFormat = new JConstantsFormat(this.helper, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(CDocument document) throws IOException, GeneratorException {
        IndentedPrintWriter writer;
        OutputStream out;
        String file;
        String javaPackage = JUtils.getJavaPackage(document);
        String path = JUtils.getPackageClassPath(javaPackage);
        if (document.getConstants().size() > 0) {
            String file2 = this.helper.getConstantsClassName(document) + ".java";
            OutputStream out2 = this.getFileManager().create(path, file2);
            try {
                IndentedPrintWriter writer2 = new IndentedPrintWriter(out2);
                this.constFormat.format(writer2, document);
                writer2.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize(out2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (PDeclaredDescriptor type : document.getDeclaredTypes()) {
            file = JUtils.getClassName(type) + ".java";
            out = this.getFileManager().create(path, file);
            try {
                writer = new IndentedPrintWriter(out);
                this.appendFileHeader(writer, document);
                switch (type.getType()) {
                    case MESSAGE: {
                        this.messageFormatter.format(writer, (PStructDescriptor)type);
                        break;
                    }
                    case ENUM: {
                        this.enumFormatter.format(writer, (CEnumDescriptor)type);
                        break;
                    }
                    default: {
                        throw new GeneratorException("Unhandled declaration type.");
                    }
                }
                writer.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize(out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (CService service : document.getServices()) {
            file = JUtils.getClassName((PService)service) + ".java";
            out = this.getFileManager().create(path, file);
            try {
                writer = new IndentedPrintWriter(out);
                this.appendFileHeader(writer, document);
                this.serviceFormatter.format(writer, service);
                writer.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize(out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void appendFileHeader(IndentedPrintWriter writer, CDocument document) throws GeneratorException, IOException {
        writer.format("package %s;", new Object[]{this.helper.getJavaPackage(document)}).newline();
    }
}

