/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.util.MessageUtil;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableSortedSet;
import net.morimekta.util.collect.Unmodifiables;

public class MessageValidation<M extends PMessage<M>, E extends Exception> {
    private final SortedSet<PField<M>> expectedPresentFields;
    private final SortedSet<PField<M>> expectedMissingFields;
    private final PMessageDescriptor<M> descriptor;
    private final boolean allowNull;
    private final Function<Exception, E> onMismatch;
    private final List<Expectation<M>> expectations;

    public <ME extends PMessageOrBuilder<M>> ME validate(ME message) throws E {
        return this.validate("", message);
    }

    public boolean isValid(PMessageOrBuilder<M> message) {
        if (message == null) {
            return this.allowNull;
        }
        if (!this.descriptor.equals(message.descriptor())) {
            return false;
        }
        Object toTest = message.toMessage();
        if (this.expectedMissingFields.stream().anyMatch(field -> toTest.has(field.getId()))) {
            return false;
        }
        if (this.expectedPresentFields.stream().anyMatch(field -> !toTest.has(field.getId()))) {
            return false;
        }
        for (Expectation<M> predicate : this.expectations) {
            try {
                predicate.test("", toTest);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public List<E> validationErrors(PMessageOrBuilder<M> message) {
        return this.validationErrors("", message);
    }

    public static <M extends PMessage<M>, E extends Exception> Builder<M, E> builder(@Nonnull PMessageDescriptor<M> descriptor, @Nonnull Function<Exception, E> onMismatch) {
        return new Builder(descriptor, onMismatch);
    }

    public <ME extends PMessageOrBuilder<M>> ME validate(@Nonnull String path, @Nullable ME message) throws E {
        try {
            return this.validateInternal(path, message);
        }
        catch (Exception e) {
            throw (Exception)this.onMismatch.apply(e);
        }
    }

    public List<E> validationErrors(String path, PMessageOrBuilder<M> message) {
        List missing;
        List present;
        if (message == null) {
            if (!this.allowNull) {
                return UnmodifiableList.listOf((Object)((Exception)this.onMismatch.apply(new IllegalStateException(MessageValidation.pathPrefix(path) + "Null " + this.descriptor.getQualifiedName() + " value."))));
            }
            return UnmodifiableList.listOf();
        }
        if (!this.descriptor.equals((message = message.toMessage()).descriptor())) {
            return UnmodifiableList.listOf((Object)((Exception)this.onMismatch.apply(new IllegalStateException(MessageValidation.pathPrefix(path) + "Validating message of type " + message.descriptor().getQualifiedName() + ", required " + this.descriptor.getQualifiedName() + "."))));
        }
        ArrayList<Exception> errors = new ArrayList<Exception>();
        Object toTest = message.toMessage();
        if (!this.expectedMissingFields.isEmpty() && !(present = this.expectedMissingFields.stream().filter(field -> toTest.has(field.getId())).map(PField::getName).collect(Collectors.toList())).isEmpty()) {
            errors.add((Exception)this.onMismatch.apply(new IllegalStateException(MessageValidation.pathPrefix(path) + Strings.join((String)", ", present) + " present on " + this.descriptor.getQualifiedName())));
        }
        if (!this.expectedPresentFields.isEmpty() && !(missing = this.expectedPresentFields.stream().filter(field -> !toTest.has(field.getId())).map(PField::getName).collect(Collectors.toList())).isEmpty()) {
            errors.add((Exception)this.onMismatch.apply(new IllegalStateException(MessageValidation.pathPrefix(path) + Strings.join((String)", ", missing) + " not present on " + this.descriptor.getQualifiedName())));
        }
        for (Expectation<M> predicate : this.expectations) {
            if (predicate instanceof ValidationExpectation) {
                ValidationExpectation valEx = (ValidationExpectation)predicate;
                errors.addAll(valEx.validationErrors(path, (PMessage)message));
                continue;
            }
            try {
                predicate.test(path, (PMessage)message);
            }
            catch (Exception e) {
                errors.add((Exception)this.onMismatch.apply(e));
            }
        }
        return errors;
    }

    public Builder<M, E> toBuilder() {
        return new Builder(this);
    }

    private MessageValidation(Builder<M, E> builder) {
        this.expectedMissingFields = UnmodifiableSortedSet.copyOf((Collection)((Builder)builder).expectedMissingFields);
        this.expectedPresentFields = UnmodifiableSortedSet.copyOf((Collection)((Builder)builder).expectedPresentFields);
        this.onMismatch = ((Builder)builder).onMismatch;
        this.allowNull = ((Builder)builder).allowNull;
        this.descriptor = ((Builder)builder).descriptor;
        this.expectations = UnmodifiableList.copyOf((Collection)((Builder)builder).expectations);
    }

    <ME extends PMessageOrBuilder<M>> ME validateInternal(@Nonnull String path, @Nullable ME message) throws Exception {
        List missing;
        List present;
        if (message == null) {
            if (this.allowNull) {
                return null;
            }
            throw new IllegalStateException(MessageValidation.pathPrefix(path) + "Null " + this.descriptor.getQualifiedName() + " value" + MessageValidation.pathPrefix(path) + ".");
        }
        if (!this.descriptor.equals(message.descriptor())) {
            throw new IllegalStateException(MessageValidation.pathPrefix(path) + "Validating message of type " + message.descriptor().getQualifiedName() + ", required " + this.descriptor.getQualifiedName() + ".");
        }
        Object toTest = message.toMessage();
        if (!this.expectedMissingFields.isEmpty() && !(present = this.expectedMissingFields.stream().filter(field -> toTest.has(field.getId())).map(PField::getName).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalStateException(MessageValidation.pathPrefix(path) + Strings.join((String)", ", present) + " present on " + this.descriptor.getQualifiedName());
        }
        if (!this.expectedPresentFields.isEmpty() && !(missing = this.expectedPresentFields.stream().filter(field -> !toTest.has(field.getId())).map(PField::getName).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalStateException(MessageValidation.pathPrefix(path) + Strings.join((String)", ", missing) + " not present on " + this.descriptor.getQualifiedName());
        }
        for (Expectation<M> expectation : this.expectations) {
            expectation.test(path, toTest);
        }
        return message;
    }

    public static String pathPrefix(String path) {
        if (path.isEmpty()) {
            return path;
        }
        return path + ": ";
    }

    public static String atPathSuffix(String path) {
        if (path.isEmpty()) {
            return path;
        }
        return " at " + path;
    }

    public static class Builder<M extends PMessage<M>, E extends Exception> {
        private boolean allowNull;
        private final SortedSet<PField<M>> expectedPresentFields;
        private final SortedSet<PField<M>> expectedMissingFields;
        private final PMessageDescriptor<M> descriptor;
        private final Function<Exception, E> onMismatch;
        private final List<Expectation<M>> expectations;

        @Nonnull
        public MessageValidation<M, E> build() {
            return new MessageValidation(this);
        }

        @Nonnull
        public Builder<M, E> expectNotNull() {
            this.allowNull = false;
            return this;
        }

        @Nonnull
        @SafeVarargs
        public final Builder<M, E> expectPresent(PField<M> ... fields) {
            this.expectedPresentFields.addAll((Collection<PField<M>>)Unmodifiables.asList((Object[])fields));
            this.expectedMissingFields.removeAll((Collection<?>)Unmodifiables.asList((Object[])fields));
            return this;
        }

        @Nonnull
        @SafeVarargs
        public final Builder<M, E> expectMissing(PField<M> ... fields) {
            this.expectedMissingFields.addAll((Collection<PField<M>>)Unmodifiables.asList((Object[])fields));
            this.expectedPresentFields.removeAll((Collection<?>)Unmodifiables.asList((Object[])fields));
            return this;
        }

        @Nonnull
        public Builder<M, E> expect(@Nonnull SimpleExpectation<M> expectation) {
            this.expectations.add(expectation);
            return this;
        }

        @Nonnull
        public Builder<M, E> expect(@Nonnull Expectation<M> expectation) {
            this.expectations.add(expectation);
            return this;
        }

        @Nonnull
        public <V> Builder<M, E> expectIfPresent(@Nonnull PField<M> field, @Nonnull SimpleExpectation<V> valueExpectation) {
            return this.expectIfPresent(field, (Expectation<V>)valueExpectation);
        }

        @Nonnull
        public <V> Builder<M, E> expectIfPresent(@Nonnull PField<M> field, @Nonnull Expectation<V> valueExpectation) {
            Expectation<PMessage> expectation = (path, message) -> {
                if (message.has(field)) {
                    valueExpectation.test(MessageUtil.keyPathAppend(path, field), message.get(field));
                }
            };
            this.expectations.add(expectation);
            return this;
        }

        @Nonnull
        public <M2 extends PMessage<M2>> Builder<M, E> expectIfPresent(@Nonnull PField<M> field, @Nonnull PMessageDescriptor<M2> descriptor, @Nonnull Consumer<Builder<M2, E>> builderConsumer) {
            if (!field.onMessageType().equals(this.descriptor)) {
                throw new IllegalArgumentException("Field not part of, " + this.descriptor.getQualifiedName());
            }
            Builder<M2, E> builder = MessageValidation.builder(descriptor, this.onMismatch);
            builderConsumer.accept(builder);
            MessageValidation<M2, E> validator = builder.build();
            if (field.getType() == PType.MESSAGE) {
                this.expectations.add(new MessageValidationExpectation<M, M2, E>(field, validator));
            } else if (field.getType() == PType.MAP) {
                this.expectations.add(new MessageMapValidationExpectation<M, M2, E>(field, validator));
            } else if (field.getType() == PType.LIST || field.getType() == PType.SET) {
                this.expectations.add(new MessageCollectionValidationExpectation<M, M2, E>(field, validator));
            } else {
                throw new IllegalArgumentException("Field type mismatch, '" + field + "' is not usable for " + descriptor.getQualifiedName() + " validation.");
            }
            if (!((MessageValidation)validator).allowNull) {
                this.expectPresent(field);
            }
            return this;
        }

        private Builder(PMessageDescriptor<M> descriptor, @Nonnull Function<Exception, E> onMismatch) {
            this.descriptor = descriptor;
            this.onMismatch = onMismatch;
            this.expectations = new ArrayList<Expectation<M>>();
            this.allowNull = true;
            this.expectedPresentFields = new TreeSet<PField>(Comparator.comparing(PField::getName));
            this.expectedMissingFields = new TreeSet<PField>(Comparator.comparing(PField::getName));
        }

        private Builder(MessageValidation<M, E> validation) {
            this.descriptor = ((MessageValidation)validation).descriptor;
            this.onMismatch = ((MessageValidation)validation).onMismatch;
            this.expectations = new ArrayList<Expectation<M>>(((MessageValidation)validation).expectations);
            this.allowNull = ((MessageValidation)validation).allowNull;
            this.expectedPresentFields = new TreeSet<PField<M>>(((MessageValidation)validation).expectedPresentFields);
            this.expectedMissingFields = new TreeSet<PField<M>>(((MessageValidation)validation).expectedMissingFields);
        }
    }

    public static final class PredicateExpectation<Value>
    implements SimpleExpectation<Value> {
        private final Predicate<Value> predicate;
        private final String failureMessage;

        public PredicateExpectation(Predicate<Value> predicate, String failureMessage) {
            this.predicate = predicate;
            this.failureMessage = failureMessage;
        }

        @Override
        public void test(Value value) {
            if (!this.predicate.test(value)) {
                throw new IllegalStateException(this.failureMessage);
            }
        }
    }

    public static final class MessageCollectionValidationExpectation<BaseMessage extends PMessage<BaseMessage>, FieldMessage extends PMessage<FieldMessage>, E extends Exception>
    implements ValidationExpectation<BaseMessage, E> {
        private final MessageValidation<FieldMessage, E> validation;
        private final PField<BaseMessage> field;

        public MessageCollectionValidationExpectation(PField<BaseMessage> field, MessageValidation<FieldMessage, E> validation) {
            if (field.getDescriptor().getType() != PType.LIST && field.getDescriptor().getType() != PType.SET) {
                throw new IllegalArgumentException("Field type not a collection.");
            }
            PMap containerType = (PMap)field.getDescriptor();
            if (!containerType.itemDescriptor().equals(((MessageValidation)validation).descriptor)) {
                throw new IllegalArgumentException("Field item value type not same as validation.");
            }
            this.validation = validation;
            this.field = field;
        }

        @Override
        public void test(String path, BaseMessage message) throws Exception {
            if (message.has(this.field)) {
                Collection collection = (Collection)message.get(this.field);
                String prefix = MessageUtil.keyPathAppend(path, this.field) + "[";
                int i = 0;
                for (PMessage item : collection) {
                    this.validation.validateInternal(prefix + i++ + "]", item);
                }
            }
        }

        @Override
        public List<E> validationErrors(String path, BaseMessage message) {
            if (message.has(this.field)) {
                ArrayList<E> exceptions = new ArrayList<E>();
                Collection collection = (Collection)message.get(this.field);
                String prefix = MessageUtil.keyPathAppend(path, this.field) + "[";
                int i = 0;
                for (PMessage item : collection) {
                    exceptions.addAll(this.validation.validationErrors(prefix + i++ + "]", item));
                }
                UnmodifiableList.copyOf(exceptions);
            }
            return UnmodifiableList.listOf();
        }
    }

    public static final class MessageMapValidationExpectation<BaseMessage extends PMessage<BaseMessage>, FieldMessage extends PMessage<FieldMessage>, E extends Exception>
    implements ValidationExpectation<BaseMessage, E> {
        private final MessageValidation<FieldMessage, E> validation;
        private final PField<BaseMessage> field;

        public MessageMapValidationExpectation(PField<BaseMessage> field, MessageValidation<FieldMessage, E> validation) {
            if (field.getDescriptor().getType() != PType.MAP) {
                throw new IllegalArgumentException("Field type not a map.");
            }
            PMap mapType = (PMap)field.getDescriptor();
            if (!mapType.itemDescriptor().equals(((MessageValidation)validation).descriptor)) {
                throw new IllegalArgumentException("Field map value type not same as validation.");
            }
            this.validation = validation;
            this.field = field;
        }

        @Override
        public void test(String path, BaseMessage message) throws Exception {
            if (message.has(this.field)) {
                Map map = (Map)message.get(this.field);
                String prefix = MessageUtil.keyPathAppend(path, this.field) + "[";
                for (Map.Entry entry : map.entrySet()) {
                    this.validation.validateInternal(prefix + entry.getKey().toString() + "]", (PMessage)entry.getValue());
                }
            }
        }

        @Override
        public List<E> validationErrors(String path, BaseMessage message) {
            if (message.has(this.field)) {
                ArrayList<E> exceptions = new ArrayList<E>();
                Map map = (Map)message.get(this.field);
                String prefix = MessageUtil.keyPathAppend(path, this.field) + "[";
                for (Map.Entry entry : map.entrySet()) {
                    exceptions.addAll(this.validation.validationErrors(prefix + entry.getKey().toString() + "]", (PMessageOrBuilder)entry.getValue()));
                }
                UnmodifiableList.copyOf(exceptions);
            }
            return UnmodifiableList.listOf();
        }
    }

    private static final class MessageValidationExpectation<BaseMessage extends PMessage<BaseMessage>, FieldMessage extends PMessage<FieldMessage>, E extends Exception>
    implements ValidationExpectation<BaseMessage, E> {
        private final MessageValidation<FieldMessage, E> validation;
        private final PField<BaseMessage> field;

        public MessageValidationExpectation(PField<BaseMessage> field, MessageValidation<FieldMessage, E> validation) {
            if (!field.getDescriptor().equals(((MessageValidation)validation).descriptor)) {
                throw new IllegalArgumentException("Field value type not same as validation");
            }
            this.validation = validation;
            this.field = field;
        }

        @Override
        public void test(String path, BaseMessage message) throws Exception {
            if (message.has(this.field)) {
                this.validation.validateInternal(MessageUtil.keyPathAppend(path, this.field), (PMessageOrBuilder)message.get(this.field));
            }
        }

        @Override
        public List<E> validationErrors(String path, BaseMessage message) {
            if (message.has(this.field)) {
                return this.validation.validationErrors(MessageUtil.keyPathAppend(path, this.field), (PMessageOrBuilder)message.get(this.field));
            }
            return UnmodifiableList.listOf();
        }
    }

    public static interface ValidationExpectation<BaseMessage extends PMessage<BaseMessage>, E extends Exception>
    extends Expectation<BaseMessage> {
        public List<E> validationErrors(String var1, BaseMessage var2);
    }

    @FunctionalInterface
    public static interface Expectation<V> {
        public void test(String var1, V var2) throws Exception;
    }

    @FunctionalInterface
    public static interface SimpleExpectation<V>
    extends Expectation<V> {
        public void test(V var1) throws Exception;

        @Override
        default public void test(String path, V value) throws Exception {
            this.test(value);
        }
    }
}

