/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.types;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.types.TypeReference;
import net.morimekta.util.collect.UnmodifiableMap;

public abstract class TypeRegistry {
    protected TypeRegistry() {
    }

    @Nonnull
    public abstract Optional<PDeclaredDescriptor<?>> getDeclaredType(@Nonnull TypeReference var1);

    @Nonnull
    public abstract Optional<PService> getService(@Nonnull TypeReference var1);

    @Nonnull
    public abstract <T> Optional<T> getConstantValue(@Nonnull TypeReference var1);

    @Nonnull
    public abstract Optional<TypeReference> getTypedef(@Nonnull TypeReference var1);

    public abstract List<PDeclaredDescriptor<?>> getDeclaredTypes();

    public abstract boolean isKnownProgram(@Nonnull String var1);

    @Nonnull
    public PDeclaredDescriptor requireDeclaredType(@Nonnull TypeReference reference) {
        if (reference.isNativeType()) {
            throw new IllegalArgumentException("Not a valid type name '" + reference + "'");
        }
        TypeReference finalReference = this.finalTypeReference(reference);
        if (finalReference.isNativeType()) {
            throw new IllegalArgumentException("Declared name '" + reference.typeName + "' is defined to native type in program '" + reference + "'");
        }
        if (this.getService(finalReference).isPresent() || this.getConstantValue(finalReference).isPresent()) {
            if (reference.equals(finalReference)) {
                throw new IllegalArgumentException("Declared name '" + finalReference.typeName + "' is not a type in program '" + finalReference.programName + "'");
            }
            throw new IllegalArgumentException("Declared name '" + finalReference.typeName + "' is not a type in program '" + finalReference.programName + "' from typedef '" + reference + "'");
        }
        return this.getDeclaredType(finalReference).orElseThrow(() -> {
            if (this.isKnownProgram(finalReference.programName)) {
                return new IllegalArgumentException("No type '" + finalReference.typeName + "' in program '" + finalReference.programName + "'");
            }
            return new IllegalArgumentException("No program '" + finalReference.programName + "' for type '" + finalReference + "'");
        });
    }

    @Nonnull
    public <M extends PMessage<M>> PMessageDescriptor<M> requireMessageType(@Nonnull TypeReference reference) {
        PDeclaredDescriptor descriptor = this.requireDeclaredType(reference);
        if (descriptor instanceof PMessageDescriptor) {
            return (PMessageDescriptor)descriptor;
        }
        throw new IllegalStateException("Not a message type " + reference + ", was " + (Object)((Object)descriptor.getType()));
    }

    @Nonnull
    public <E extends PEnumValue<E>> PEnumDescriptor<E> requireEnumType(@Nonnull TypeReference reference) {
        PDeclaredDescriptor descriptor = this.requireDeclaredType(reference);
        if (descriptor instanceof PEnumDescriptor) {
            return (PEnumDescriptor)descriptor;
        }
        throw new IllegalStateException("Not an enum type " + reference + ", was " + (Object)((Object)descriptor.getType()));
    }

    @Nonnull
    public PService requireService(@Nonnull TypeReference reference) {
        if (reference.isNativeType()) {
            throw new IllegalArgumentException("Not a valid service name '" + reference + "'");
        }
        if (this.getDeclaredType(reference).isPresent() || this.getTypedef(reference).isPresent()) {
            throw new IllegalArgumentException("Declared name '" + reference.typeName + "' is not a service in program '" + reference.programName + "'");
        }
        return this.getService(reference).orElseThrow(() -> {
            if (this.isKnownProgram(reference.programName)) {
                return new IllegalArgumentException("No service '" + reference.typeName + "' in program '" + reference.programName + "'");
            }
            return new IllegalArgumentException("No program '" + reference.programName + "' for service '" + reference + "'");
        });
    }

    @Nonnull
    public PDescriptorProvider getTypeProvider(@Nonnull TypeReference reference) {
        return this.getTypeProvider(reference, (Map<String, String>)UnmodifiableMap.mapOf());
    }

    @Nonnull
    public PDescriptorProvider getTypeProvider(@Nonnull TypeReference reference, @Nonnull Map<String, String> annotations) {
        return () -> this.resolveType(reference, annotations);
    }

    @Nonnull
    public PServiceProvider getServiceProvider(@Nonnull TypeReference reference) {
        return () -> this.requireService(reference);
    }

    @Nonnull
    protected TypeReference finalTypeReference(@Nonnull TypeReference reference) {
        if (reference.isMap()) {
            return new TypeReference(reference.programName, reference.typeName, this.finalTypeReference(Objects.requireNonNull(reference.keyType)), this.finalTypeReference(Objects.requireNonNull(reference.valueType)));
        }
        if (reference.isContainer()) {
            return new TypeReference(reference.programName, reference.typeName, null, this.finalTypeReference(Objects.requireNonNull(reference.valueType)));
        }
        Optional<TypeReference> def = this.getTypedef(reference);
        return def.map(this::finalTypeReference).orElse(reference);
    }

    private PDescriptor resolveType(TypeReference reference, Map<String, String> annotations) {
        reference = this.finalTypeReference(reference);
        PPrimitive primitive = PPrimitive.findByName(reference.typeName);
        if (primitive != null) {
            return primitive;
        }
        if (reference.isMap()) {
            PDescriptorProvider keyType = this.getTypeProvider(Objects.requireNonNull(reference.keyType), annotations);
            PDescriptorProvider valueType = this.getTypeProvider(Objects.requireNonNull(reference.valueType), annotations);
            switch (PContainer.typeForName(annotations.get(PAnnotation.CONTAINER.tag))) {
                case SORTED: {
                    return PMap.sortedProvider(keyType, valueType).descriptor();
                }
                case ORDERED: {
                    return PMap.orderedProvider(keyType, valueType).descriptor();
                }
                case DEFAULT: {
                    return PMap.provider(keyType, valueType).descriptor();
                }
            }
        } else if (reference.isSet()) {
            PDescriptorProvider valueType = this.getTypeProvider(Objects.requireNonNull(reference.valueType), annotations);
            switch (PContainer.typeForName(annotations.get(PAnnotation.CONTAINER.tag))) {
                case SORTED: {
                    return PSet.sortedProvider(valueType).descriptor();
                }
                case ORDERED: {
                    return PSet.orderedProvider(valueType).descriptor();
                }
                case DEFAULT: {
                    return PSet.provider(valueType).descriptor();
                }
            }
        } else if (reference.isList()) {
            PDescriptorProvider valueType = this.getTypeProvider(Objects.requireNonNull(reference.valueType), annotations);
            return PList.provider(valueType).descriptor();
        }
        return this.requireDeclaredType(reference);
    }
}

