/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.SetOperations;
import net.morimekta.util.collect.UnmodifiableSet;

public final class TypeReference {
    private static final String GLOBAL = "";
    private static final String LIST = "list";
    private static final String SET = "set";
    private static final String MAP = "map";
    private static final String IDENTIFIER = "[_a-zA-Z][_a-zA-Z0-9]*";
    private static final String TYPENAME = "[_a-zA-Z][_a-zA-Z0-9]*(\\.[_a-zA-Z][_a-zA-Z0-9]*\\.(request|response))?";
    private static final Set<String> ILLEGAL_TYPE = UnmodifiableSet.setOf((Object)"struct", (Object)"union", (Object)"exception", (Object)"interface", (Object)"const", (Object)"enum", (Object)"namespace", (Object)"include", (Object)"implements", (Object)"of", (Object[])new String[]{"service", "extends", "throws"});
    private static final Set<String> NATIVE_TYPE = SetOperations.union((Set[])new Set[]{UnmodifiableSet.setOf((Object)"set", (Object)"list", (Object)"map"), UnmodifiableSet.setOf((Object)"i8"), UnmodifiableSet.copyOf((Collection)Arrays.stream(PPrimitive.values()).map(PPrimitive::getName).collect(Collectors.toSet()))});
    public final String programName;
    public final String typeName;
    public final TypeReference keyType;
    public final TypeReference valueType;

    TypeReference(@Nonnull String programName, @Nonnull String typeName, @Nullable TypeReference keyType, @Nullable TypeReference valueType) {
        this.programName = programName;
        this.typeName = typeName;
        this.keyType = keyType;
        this.valueType = valueType;
        if (!programName.equals(GLOBAL) && !programName.matches(IDENTIFIER)) {
            throw new IllegalArgumentException("Bad program name '" + programName + "'");
        }
        if (typeName.isEmpty()) {
            throw new IllegalArgumentException("Empty type name");
        }
        if (!typeName.matches(TYPENAME)) {
            throw new IllegalArgumentException("Bad type '" + typeName + "'");
        }
        if (this.isMap()) {
            if (keyType == null || valueType == null) {
                throw new IllegalArgumentException("Map without key or value type");
            }
        } else if (this.isSet()) {
            if (valueType == null) {
                throw new IllegalArgumentException("Set without value type");
            }
        } else if (this.isList()) {
            if (valueType == null) {
                throw new IllegalArgumentException("List without value type");
            }
        } else {
            if (ILLEGAL_TYPE.contains(typeName)) {
                throw new IllegalArgumentException("Not allowed type name: '" + typeName + "'");
            }
            if (valueType != null || keyType != null) {
                throw new IllegalArgumentException("Non-container with key or value type");
            }
        }
    }

    public boolean isNativeType() {
        return NATIVE_TYPE.contains(this.typeName);
    }

    public boolean isContainer() {
        return this.isList() || this.isSet() || this.isMap();
    }

    public boolean isList() {
        return LIST.equals(this.typeName);
    }

    public boolean isSet() {
        return SET.equals(this.typeName);
    }

    public boolean isMap() {
        return MAP.equals(this.typeName);
    }

    @Nonnull
    public static TypeReference ref(@Nonnull String programContext, @Nonnull String typeName) {
        return new TypeReference(programContext, typeName, null, null);
    }

    @Nonnull
    public static TypeReference parseType(@Nonnull String globalName) {
        if (globalName.isEmpty()) {
            throw new IllegalArgumentException("Empty type name");
        }
        try {
            return TypeReference.parseInternal(GLOBAL, globalName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + " in reference '" + globalName + "'", e);
        }
    }

    @Nonnull
    public static TypeReference parseType(@Nonnull String programContext, @Nonnull String typeName) {
        if (typeName.isEmpty()) {
            throw new IllegalArgumentException("Empty type");
        }
        if (programContext.isEmpty()) {
            throw new IllegalArgumentException("Empty program name");
        }
        if (!programContext.matches(IDENTIFIER)) {
            throw new IllegalArgumentException("Bad program name '" + programContext + "'");
        }
        try {
            return TypeReference.parseInternal(programContext, typeName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + " in reference '" + typeName + "' in program '" + programContext + "'", e);
        }
    }

    @Nonnull
    private static TypeReference parseInternal(@Nonnull String programContext, @Nonnull String typeName) {
        if (typeName.startsWith("list<") && typeName.endsWith(">")) {
            String valueType = typeName.substring(5, typeName.length() - 1);
            if (valueType.isEmpty()) {
                throw new IllegalArgumentException("Empty value type");
            }
            return new TypeReference(GLOBAL, LIST, null, TypeReference.parseInternal(programContext, valueType));
        }
        if (typeName.startsWith("set<") && typeName.endsWith(">")) {
            String valueType = typeName.substring(4, typeName.length() - 1);
            if (valueType.isEmpty()) {
                throw new IllegalArgumentException("Empty value type");
            }
            return new TypeReference(GLOBAL, SET, null, TypeReference.parseInternal(programContext, valueType));
        }
        if (typeName.startsWith("map<") && typeName.endsWith(">")) {
            String generics = typeName.substring(4, typeName.length() - 1);
            if (generics.isEmpty()) {
                throw new IllegalArgumentException("Empty key and value type");
            }
            String[] parts = generics.split(",", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Map without value type: '" + typeName + "'");
            }
            if (parts[0].isEmpty()) {
                throw new IllegalArgumentException("Empty key type");
            }
            if (parts[1].isEmpty()) {
                throw new IllegalArgumentException("Empty value type");
            }
            return new TypeReference(GLOBAL, MAP, TypeReference.parseInternal(programContext, parts[0]), TypeReference.parseInternal(programContext, parts[1]));
        }
        if (NATIVE_TYPE.contains(typeName)) {
            return new TypeReference(GLOBAL, typeName, null, null);
        }
        String[] parts = typeName.split("\\.", 127);
        if (parts.length == 1) {
            if (programContext.equals(GLOBAL)) {
                throw new IllegalArgumentException("No program for type '" + typeName + "'");
            }
            return new TypeReference(programContext, typeName, null, null);
        }
        if (parts.length == 2) {
            if (parts[0].equals(GLOBAL)) {
                throw new IllegalArgumentException("Empty program for name '" + typeName + "'");
            }
            return new TypeReference(parts[0], parts[1], null, null);
        }
        if (parts.length == 3) {
            if (programContext.equals(GLOBAL)) {
                throw new IllegalArgumentException("No program for type '" + typeName + "'");
            }
            return new TypeReference(programContext, typeName, null, null);
        }
        if (parts.length == 4) {
            if (parts[0].equals(GLOBAL)) {
                throw new IllegalArgumentException("Empty program for name '" + typeName + "'");
            }
            typeName = Strings.join((String)".", (Object[])Arrays.copyOfRange(parts, 1, parts.length));
            return new TypeReference(parts[0], typeName, null, null);
        }
        throw new IllegalArgumentException("Bad type reference: '" + typeName + "'");
    }

    public String toString() {
        if (this.typeName.equals(LIST) || this.typeName.equals(SET)) {
            return this.typeName + "<" + this.valueType + ">";
        }
        if (this.typeName.equals(MAP)) {
            return this.typeName + "<" + this.keyType + "," + this.valueType + ">";
        }
        if (NATIVE_TYPE.contains(this.typeName)) {
            return this.typeName;
        }
        return this.programName + "." + this.typeName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeReference)) {
            return false;
        }
        TypeReference other = (TypeReference)obj;
        return Objects.equals(this.programName, other.programName) && Objects.equals(this.typeName, other.typeName) && Objects.equals(this.keyType, other.keyType) && Objects.equals(this.valueType, other.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.programName, this.typeName);
    }
}

