/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PContainerProvider;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.util.collect.UnmodifiableSet;
import net.morimekta.util.collect.UnmodifiableSortedSet;

@Immutable
public class PSet<Item>
extends PContainer<Set<Item>> {
    private final IntFunction<Builder<Item>> builderSupplier;

    public PSet(PDescriptorProvider itemType, IntFunction<Builder<Item>> builderSupplier) {
        super(itemType);
        this.builderSupplier = builderSupplier;
    }

    @Override
    @Nonnull
    public String getName() {
        return "set<" + this.itemDescriptor().getName() + ">";
    }

    @Override
    @Nonnull
    public String getQualifiedName(String programContext) {
        return "set<" + this.itemDescriptor().getQualifiedName(programContext) + ">";
    }

    @Override
    @Nonnull
    public PType getType() {
        return PType.SET;
    }

    @Override
    @Nullable
    public Object getDefaultValue() {
        return Collections.EMPTY_SET;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PSet)) {
            return false;
        }
        PSet other = (PSet)o;
        return other.itemDescriptor().equals(this.itemDescriptor());
    }

    public int hashCode() {
        return PSet.class.hashCode() + this.itemDescriptor().hashCode();
    }

    @Nonnull
    public Builder<Item> builder(int capacity) {
        return this.builderSupplier.apply(capacity);
    }

    @Nonnull
    public static <I> PContainerProvider<Set<I>, PSet<I>> provider(PDescriptorProvider itemDesc) {
        return PSet.provider(itemDesc, DefaultBuilder::new);
    }

    @Nonnull
    public static <I extends Comparable<I>> PContainerProvider<Set<I>, PSet<I>> sortedProvider(PDescriptorProvider itemDesc) {
        return PSet.provider(itemDesc, SortedBuilder::new);
    }

    @Nonnull
    public static <I extends Comparable<I>> PContainerProvider<Set<I>, PSet<I>> orderedProvider(PDescriptorProvider itemDesc) {
        return PSet.provider(itemDesc, DefaultBuilder::new);
    }

    private static <I> PContainerProvider<Set<I>, PSet<I>> provider(PDescriptorProvider itemDesc, IntFunction<Builder<I>> builderFactory) {
        return new PContainerProvider<Set<I>, PSet<I>>(new PSet(itemDesc, builderFactory));
    }

    public static class SortedBuilder<I extends Comparable<I>>
    implements Builder<I> {
        private UnmodifiableSortedSet.Builder<I> builder;

        public SortedBuilder() {
            this(10);
        }

        public SortedBuilder(int capacity) {
            this.builder = UnmodifiableSortedSet.builderNaturalOrder((int)capacity);
        }

        @Override
        @Nonnull
        public Builder<I> add(@Nonnull I value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public Builder<I> addAll(@Nonnull Collection<I> items) {
            this.builder.addAll(items);
            return this;
        }

        @Override
        @Nonnull
        public Set<I> build() {
            return this.builder.build();
        }
    }

    public static class DefaultBuilder<I>
    implements Builder<I> {
        private UnmodifiableSet.Builder<I> builder;

        public DefaultBuilder() {
            this(10);
        }

        public DefaultBuilder(int capacity) {
            this.builder = UnmodifiableSet.builder((int)capacity);
        }

        @Override
        @Nonnull
        public Builder<I> add(@Nonnull I value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public Builder<I> addAll(@Nonnull Collection<I> items) {
            this.builder.addAll(items);
            return this;
        }

        @Override
        @Nonnull
        public Set<I> build() {
            return this.builder.build();
        }
    }

    public static interface Builder<I> {
        @Nonnull
        public Builder<I> add(@Nonnull I var1);

        @Nonnull
        public Builder<I> addAll(@Nonnull Collection<I> var1);

        @Nonnull
        public Set<I> build();
    }
}

