/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;

public enum PApplicationExceptionType implements PEnumValue<PApplicationExceptionType>
{
    UNKNOWN(0, "UNKNOWN", "UNKNOWN"),
    UNKNOWN_METHOD(1, "UNKNOWN_METHOD", "UNKNOWN_METHOD"),
    INVALID_MESSAGE_TYPE(2, "INVALID_MESSAGE_TYPE", "INVALID_MESSAGE_TYPE"),
    WRONG_METHOD_NAME(3, "WRONG_METHOD_NAME", "WRONG_METHOD_NAME"),
    BAD_SEQUENCE_ID(4, "BAD_SEQUENCE_ID", "BAD_SEQUENCE_ID"),
    MISSING_RESULT(5, "MISSING_RESULT", "MISSING_RESULT"),
    INTERNAL_ERROR(6, "INTERNAL_ERROR", "INTERNAL_ERROR"),
    PROTOCOL_ERROR(7, "PROTOCOL_ERROR", "PROTOCOL_ERROR"),
    INVALID_TRANSFORM(8, "INVALID_TRANSFORM", "INVALID_TRANSFORM"),
    INVALID_PROTOCOL(9, "INVALID_PROTOCOL", "INVALID_PROTOCOL"),
    UNSUPPORTED_CLIENT_TYPE(10, "UNSUPPORTED_CLIENT_TYPE", "UNSUPPORTED_CLIENT_TYPE");

    private final int mId;
    private final String mName;
    private final String mPojoName;
    public static final PEnumDescriptor<PApplicationExceptionType> kDescriptor;

    private PApplicationExceptionType(int id, String name, String pojoName) {
        this.mId = id;
        this.mName = name;
        this.mPojoName = pojoName;
    }

    public int asInteger() {
        return this.mId;
    }

    @Nonnull
    public String asString() {
        return this.mName;
    }

    @Override
    @Nonnull
    public String getPojoName() {
        return this.mPojoName;
    }

    @Nullable
    public static PApplicationExceptionType findById(Integer id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return UNKNOWN_METHOD;
            }
            case 2: {
                return INVALID_MESSAGE_TYPE;
            }
            case 3: {
                return WRONG_METHOD_NAME;
            }
            case 4: {
                return BAD_SEQUENCE_ID;
            }
            case 5: {
                return MISSING_RESULT;
            }
            case 6: {
                return INTERNAL_ERROR;
            }
            case 7: {
                return PROTOCOL_ERROR;
            }
            case 8: {
                return INVALID_TRANSFORM;
            }
            case 9: {
                return INVALID_PROTOCOL;
            }
            case 10: {
                return UNSUPPORTED_CLIENT_TYPE;
            }
        }
        return null;
    }

    @Nullable
    public static PApplicationExceptionType findByName(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "UNKNOWN": {
                return UNKNOWN;
            }
            case "UNKNOWN_METHOD": {
                return UNKNOWN_METHOD;
            }
            case "INVALID_MESSAGE_TYPE": {
                return INVALID_MESSAGE_TYPE;
            }
            case "WRONG_METHOD_NAME": {
                return WRONG_METHOD_NAME;
            }
            case "BAD_SEQUENCE_ID": {
                return BAD_SEQUENCE_ID;
            }
            case "MISSING_RESULT": {
                return MISSING_RESULT;
            }
            case "INTERNAL_ERROR": {
                return INTERNAL_ERROR;
            }
            case "PROTOCOL_ERROR": {
                return PROTOCOL_ERROR;
            }
            case "INVALID_TRANSFORM": {
                return INVALID_TRANSFORM;
            }
            case "INVALID_PROTOCOL": {
                return INVALID_PROTOCOL;
            }
            case "UNSUPPORTED_CLIENT_TYPE": {
                return UNSUPPORTED_CLIENT_TYPE;
            }
        }
        return null;
    }

    @Nullable
    public static PApplicationExceptionType findByPojoName(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "UNKNOWN": {
                return UNKNOWN;
            }
            case "UNKNOWN_METHOD": {
                return UNKNOWN_METHOD;
            }
            case "INVALID_MESSAGE_TYPE": {
                return INVALID_MESSAGE_TYPE;
            }
            case "WRONG_METHOD_NAME": {
                return WRONG_METHOD_NAME;
            }
            case "BAD_SEQUENCE_ID": {
                return BAD_SEQUENCE_ID;
            }
            case "MISSING_RESULT": {
                return MISSING_RESULT;
            }
            case "INTERNAL_ERROR": {
                return INTERNAL_ERROR;
            }
            case "PROTOCOL_ERROR": {
                return PROTOCOL_ERROR;
            }
            case "INVALID_TRANSFORM": {
                return INVALID_TRANSFORM;
            }
            case "INVALID_PROTOCOL": {
                return INVALID_PROTOCOL;
            }
            case "UNSUPPORTED_CLIENT_TYPE": {
                return UNSUPPORTED_CLIENT_TYPE;
            }
        }
        return null;
    }

    @Nonnull
    public static PApplicationExceptionType valueForId(int id) {
        PApplicationExceptionType value = PApplicationExceptionType.findById(id);
        if (value == null) {
            throw new IllegalArgumentException("No p_service.PApplicationExceptionType for id " + id);
        }
        return value;
    }

    @Nonnull
    public static PApplicationExceptionType valueForName(@Nonnull String name) {
        PApplicationExceptionType value = PApplicationExceptionType.findByName(name);
        if (value == null) {
            throw new IllegalArgumentException("No p_service.PApplicationExceptionType for name \"" + name + "\"");
        }
        return value;
    }

    @Nonnull
    public static PApplicationExceptionType valueForPojoName(@Nonnull String name) {
        PApplicationExceptionType value = PApplicationExceptionType.findByPojoName(name);
        if (value == null) {
            throw new IllegalArgumentException("No p_service.PApplicationExceptionType for name \"" + name + "\"");
        }
        return value;
    }

    @Override
    @Nonnull
    public PEnumDescriptor<PApplicationExceptionType> descriptor() {
        return kDescriptor;
    }

    public static PEnumDescriptorProvider<PApplicationExceptionType> provider() {
        return new PEnumDescriptorProvider<PApplicationExceptionType>(kDescriptor);
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Descriptor
    extends PEnumDescriptor<PApplicationExceptionType> {
        public _Descriptor() {
            super("p_service", "PApplicationExceptionType", _Builder::new);
        }

        @Override
        @Nonnull
        public boolean isInnerType() {
            return false;
        }

        @Override
        @Nonnull
        public boolean isAutoType() {
            return false;
        }

        @Nonnull
        public PApplicationExceptionType[] getValues() {
            return PApplicationExceptionType.values();
        }

        @Override
        @Nullable
        public PApplicationExceptionType findById(int id) {
            return PApplicationExceptionType.findById(id);
        }

        @Override
        @Nullable
        public PApplicationExceptionType findByName(String name) {
            return PApplicationExceptionType.findByName(name);
        }

        @Override
        @Nullable
        public PApplicationExceptionType findByPojoName(String name) {
            return PApplicationExceptionType.findByPojoName(name);
        }
    }

    public static final class _Builder
    extends PEnumBuilder<PApplicationExceptionType> {
        private PApplicationExceptionType mValue;

        @Nonnull
        public _Builder setById(int value) {
            this.mValue = PApplicationExceptionType.findById(value);
            return this;
        }

        @Nonnull
        public _Builder setByName(String name) {
            this.mValue = PApplicationExceptionType.findByName(name);
            return this;
        }

        @Override
        public boolean valid() {
            return this.mValue != null;
        }

        @Override
        public PApplicationExceptionType build() {
            return this.mValue;
        }
    }
}

