/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;

public abstract class Serializer {
    public static final boolean DEFAULT_STRICT = false;

    public abstract <Message extends PMessage<Message>> int serialize(@Nonnull OutputStream var1, @Nonnull PMessageOrBuilder<Message> var2) throws IOException;

    public abstract <Message extends PMessage<Message>> int serialize(@Nonnull OutputStream var1, @Nonnull PServiceCall<Message> var2) throws IOException;

    @Nonnull
    public abstract <Message extends PMessage<Message>> Message deserialize(@Nonnull InputStream var1, @Nonnull PMessageDescriptor<Message> var2) throws IOException;

    @Nonnull
    public abstract <Message extends PMessage<Message>> PServiceCall<Message> deserialize(@Nonnull InputStream var1, @Nonnull PService var2) throws IOException;

    public abstract boolean binaryProtocol();

    public abstract void verifyEndOfContent(@Nonnull InputStream var1) throws IOException;

    @Nonnull
    public abstract String mediaType();

    protected boolean isRequestCallType(PServiceCallType type) {
        switch (type) {
            case CALL: 
            case ONEWAY: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName().replaceAll("Serializer", ""), this.mediaType());
    }
}

