/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PMessageDescriptorProvider;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;

@Immutable
public class PInterfaceDescriptor<T extends PMessage<T>>
extends PMessageDescriptor<T> {
    private final PField<T>[] fields;
    private final Map<Integer, PField<T>> fieldIdMap;
    private final Map<String, PField<T>> fieldNameMap;
    private final Map<String, PField<T>> fieldPojoNameMap;
    private final List<PMessageDescriptorProvider<?>> possibleTypeProviders;
    private final AtomicReference<List<PMessageDescriptor<?>>> possibleTypes;

    public PInterfaceDescriptor(String programName, String name, PField<T>[] fields, PMessageDescriptorProvider<?> ... possibleTypes) {
        super(programName, name, null, false);
        this.fields = fields;
        this.possibleTypeProviders = UnmodifiableList.copyOf((Object[])possibleTypes);
        this.possibleTypes = new AtomicReference();
        UnmodifiableMap.Builder fieldIdMap = UnmodifiableMap.builder((int)this.fields.length);
        UnmodifiableMap.Builder fieldNameMap = UnmodifiableMap.builder((int)this.fields.length);
        UnmodifiableMap.Builder fieldPojoNameMap = UnmodifiableMap.builder((int)this.fields.length);
        for (PField<T> field : fields) {
            fieldIdMap.put((Object)field.getId(), field);
            fieldNameMap.put((Object)field.getName(), field);
            fieldPojoNameMap.put((Object)field.getPojoName(), field);
        }
        this.fieldIdMap = fieldIdMap.build();
        this.fieldNameMap = fieldNameMap.build();
        this.fieldPojoNameMap = fieldPojoNameMap.build();
    }

    @Override
    public boolean isInnerType() {
        return false;
    }

    @Override
    public boolean isAutoType() {
        return false;
    }

    public List<PMessageDescriptor<?>> getPossibleTypes() {
        return this.possibleTypes.updateAndGet(list -> {
            if (list == null) {
                list = this.possibleTypeProviders.stream().map(PMessageDescriptorProvider::descriptor).collect(Collectors.toList());
            }
            return list;
        });
    }

    @Override
    @Nonnull
    public PMessageVariant getVariant() {
        return PMessageVariant.INTERFACE;
    }

    @Override
    @Nonnull
    public PField<T>[] getFields() {
        return Arrays.copyOf(this.fields, this.fields.length);
    }

    @Override
    public PField<T> findFieldByName(String name) {
        return this.fieldNameMap.get(name);
    }

    @Override
    public PField<T> findFieldByPojoName(String pojoName) {
        return this.fieldPojoNameMap.get(pojoName);
    }

    @Override
    public PField<T> findFieldById(int id) {
        return this.fieldIdMap.get(id);
    }

    @Override
    @Nonnull
    public PMessageBuilder<T> builder() {
        throw new UnsupportedOperationException("Interfaces cannot be built");
    }
}

