/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;

public enum PServiceCallType implements PEnumValue<PServiceCallType>
{
    CALL(1, "CALL"),
    REPLY(2, "REPLY"),
    EXCEPTION(3, "EXCEPTION"),
    ONEWAY(4, "ONEWAY");

    private final int mId;
    private final String mName;
    public static final PEnumDescriptor<PServiceCallType> kDescriptor;

    private PServiceCallType(int id, String name) {
        this.mId = id;
        this.mName = name;
    }

    public int asInteger() {
        return this.mId;
    }

    @Nonnull
    public String asString() {
        return this.mName;
    }

    @Nullable
    public static PServiceCallType findById(Integer id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case 1: {
                return CALL;
            }
            case 2: {
                return REPLY;
            }
            case 3: {
                return EXCEPTION;
            }
            case 4: {
                return ONEWAY;
            }
        }
        return null;
    }

    @Nullable
    public static PServiceCallType findByName(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "CALL": {
                return CALL;
            }
            case "REPLY": {
                return REPLY;
            }
            case "EXCEPTION": {
                return EXCEPTION;
            }
            case "ONEWAY": {
                return ONEWAY;
            }
        }
        return null;
    }

    @Nonnull
    public static PServiceCallType valueForId(int id) {
        PServiceCallType value = PServiceCallType.findById(id);
        if (value == null) {
            throw new IllegalArgumentException("No p_service.PServiceCallType for id " + id);
        }
        return value;
    }

    @Nonnull
    public static PServiceCallType valueForName(@Nonnull String name) {
        PServiceCallType value = PServiceCallType.findByName(name);
        if (value == null) {
            throw new IllegalArgumentException("No p_service.PServiceCallType for name \"" + name + "\"");
        }
        return value;
    }

    @Override
    @Nonnull
    public PEnumDescriptor<PServiceCallType> descriptor() {
        return kDescriptor;
    }

    public static PEnumDescriptorProvider<PServiceCallType> provider() {
        return new PEnumDescriptorProvider<PServiceCallType>(kDescriptor);
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Descriptor
    extends PEnumDescriptor<PServiceCallType> {
        public _Descriptor() {
            super("p_service", "PServiceCallType", _Builder::new);
        }

        @Override
        @Nonnull
        public boolean isInnerType() {
            return false;
        }

        @Override
        @Nonnull
        public boolean isAutoType() {
            return false;
        }

        @Nonnull
        public PServiceCallType[] getValues() {
            return PServiceCallType.values();
        }

        @Override
        @Nullable
        public PServiceCallType findById(int id) {
            return PServiceCallType.findById(id);
        }

        @Override
        @Nullable
        public PServiceCallType findByName(String name) {
            return PServiceCallType.findByName(name);
        }
    }

    public static final class _Builder
    extends PEnumBuilder<PServiceCallType> {
        private PServiceCallType mValue;

        @Nonnull
        public _Builder setById(int value) {
            this.mValue = PServiceCallType.findById(value);
            return this;
        }

        @Nonnull
        public _Builder setByName(String name) {
            this.mValue = PServiceCallType.findByName(name);
            return this;
        }

        @Override
        public boolean valid() {
            return this.mValue != null;
        }

        @Override
        public PServiceCallType build() {
            return this.mValue;
        }
    }
}

