/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.streams;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.Serializer;

public class MessageSpliterator<Message extends PMessage<Message>>
implements Spliterator<Message> {
    private final InputStream in;
    private final PMessageDescriptor<Message> descriptor;
    private final Serializer serializer;
    private Closeable closer;

    public MessageSpliterator(@Nonnull InputStream in, @Nonnull Serializer serializer, @Nonnull PMessageDescriptor<Message> descriptor) {
        this(in, serializer, descriptor, in);
    }

    public MessageSpliterator(@Nonnull InputStream in, @Nonnull Serializer serializer, @Nonnull PMessageDescriptor<Message> descriptor, @Nullable Closeable closer) {
        this.in = in;
        this.serializer = serializer;
        this.descriptor = descriptor;
        this.closer = closer;
    }

    @Override
    public boolean tryAdvance(Consumer<? super Message> action) {
        Message message = this.read();
        if (message != null) {
            action.accept(message);
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<Message> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getExactSizeIfKnown() {
        return -1L;
    }

    @Override
    public int characteristics() {
        return 1296;
    }

    @Override
    public Comparator<? super Message> getComparator() {
        return Comparable::compareTo;
    }

    private Message read() {
        try {
            if (this.in.markSupported()) {
                this.in.mark(2);
                if (this.in.read() < 0) {
                    return this.close(null);
                }
                this.in.reset();
            }
            return this.serializer.deserialize(this.in, this.descriptor);
        }
        catch (IOException e) {
            this.close(e);
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    private Message close(Exception cause) {
        if (this.closer != null) {
            try {
                this.closer.close();
            }
            catch (IOException e) {
                if (cause == null) {
                    throw new UncheckedIOException(e.getMessage(), e);
                }
                cause.addSuppressed(e);
            }
            finally {
                this.closer = null;
            }
        }
        return null;
    }
}

