/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;

@Immutable
public abstract class PEnumDescriptor<T extends PEnumValue<T>>
extends PDeclaredDescriptor<T> {
    public static final int DEFAULT_FIRST_VALUE = 0;
    private final Supplier<PEnumBuilder<T>> builderSupplier;

    public PEnumDescriptor(String packageName, String name, Supplier<PEnumBuilder<T>> provider) {
        super(packageName, name);
        this.builderSupplier = provider;
    }

    @Override
    @Nonnull
    public PType getType() {
        return PType.ENUM;
    }

    @Nonnull
    public abstract T[] getValues();

    @Nullable
    public abstract T findById(int var1);

    @Nullable
    public abstract T findByName(String var1);

    @Nonnull
    public T valueForId(int id) {
        T value = this.findById(id);
        if (value == null) {
            throw new IllegalArgumentException("No " + this.getQualifiedName() + " for id " + id);
        }
        return value;
    }

    @Nonnull
    public T valueForName(String name) {
        T value = this.findByName(name);
        if (value == null) {
            throw new IllegalArgumentException("No " + this.getQualifiedName() + " for name \"" + name + "\"");
        }
        return value;
    }

    @Nonnull
    public PEnumBuilder<T> builder() {
        return this.builderSupplier.get();
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        PEnumDescriptor other = (PEnumDescriptor)o;
        if (!this.getQualifiedName().equals(other.getQualifiedName()) || this.getValues().length != other.getValues().length) {
            return false;
        }
        for (PEnumValue value : this.getValues()) {
            T ovI = other.findById(value.asInteger());
            if (ovI == null || value.asString().equals(ovI.asString())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(PEnumDescriptor.class, this.getQualifiedName());
    }

    protected Supplier<PEnumBuilder<T>> getBuilderSupplier() {
        return this.builderSupplier;
    }
}

