/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.JsonSerializerException;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.json.JsonCompactible;
import net.morimekta.providence.serializer.json.JsonCompactibleDescriptor;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.CountingOutputStream;
import net.morimekta.util.io.IndentedPrintWriter;
import net.morimekta.util.io.Utf8StreamReader;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonToken;
import net.morimekta.util.json.JsonTokenizer;
import net.morimekta.util.json.JsonWriter;
import net.morimekta.util.json.PrettyJsonWriter;

public class JsonSerializer
extends Serializer {
    public static final String MEDIA_TYPE = "application/vnd.morimekta.providence.json";
    public static final String JSON_MEDIA_TYPE = "application/json";
    private static final JsonSerializer JSON_SERIALIZER = new JsonSerializer().named();
    private static final JsonSerializer PRETTY_JSON_SERIALIZER = JSON_SERIALIZER.pretty();
    private static final int PRETTY_READ_BUFFER_SIZE = 1024;
    private static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    private final boolean readStrict;
    private final boolean prettyPrint;
    private final IdType fieldIdType;
    private final IdType enumValueType;
    private final boolean flattenUnionOf;

    @Nonnull
    public static <Message extends PMessage<Message>> String toJsonString(PMessageOrBuilder<Message> message) {
        try {
            StringWriter out = new StringWriter();
            JSON_SERIALIZER.serialize(new PrintWriter(out), message);
            return out.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Nonnull
    public static <Message extends PMessage<Message>> String toPrettyJsonString(PMessageOrBuilder<Message> message) {
        try {
            StringWriter out = new StringWriter();
            PRETTY_JSON_SERIALIZER.serialize(new PrintWriter(out), message);
            return out.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Nonnull
    public static <Message extends PMessage<Message>> Message parseJsonString(String string, PMessageDescriptor<Message> descriptor) {
        try {
            StringReader in = new StringReader(string);
            return JSON_SERIALIZER.deserialize(in, descriptor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    public JsonSerializer() {
        this(false, false, IdType.ID, IdType.ID, false);
    }

    public JsonSerializer(boolean strict) {
        this(strict, false, IdType.ID, IdType.ID, false);
    }

    public JsonSerializer pretty() {
        return new JsonSerializer(this.readStrict, true, IdType.NAME, IdType.NAME, this.flattenUnionOf);
    }

    public JsonSerializer named() {
        return this.withNamedEnums().withNamedFields();
    }

    public JsonSerializer grpc() {
        return this.withNamedEnums().withPojoNamedFields();
    }

    public JsonSerializer withPojoNamedFields() {
        return new JsonSerializer(this.readStrict, this.prettyPrint, IdType.POJO, this.enumValueType, this.flattenUnionOf);
    }

    public JsonSerializer withNamedFields() {
        return new JsonSerializer(this.readStrict, this.prettyPrint, IdType.NAME, this.enumValueType, this.flattenUnionOf);
    }

    public JsonSerializer withNamedEnums() {
        return new JsonSerializer(this.readStrict, this.prettyPrint, this.fieldIdType, IdType.NAME, this.flattenUnionOf);
    }

    public JsonSerializer withIdFields() {
        return new JsonSerializer(this.readStrict, this.prettyPrint, IdType.ID, this.enumValueType, this.flattenUnionOf);
    }

    public JsonSerializer withIdEnums() {
        return new JsonSerializer(this.readStrict, this.prettyPrint, this.fieldIdType, IdType.ID, this.flattenUnionOf);
    }

    public JsonSerializer withFlattenUnionOf() {
        return new JsonSerializer(this.readStrict, this.prettyPrint, this.fieldIdType, this.enumValueType, true);
    }

    public <T extends PMessage<T>> void serialize(@Nonnull PrintWriter output, @Nonnull PMessageOrBuilder<T> message) throws IOException {
        PrettyJsonWriter jsonWriter = output instanceof IndentedPrintWriter ? new PrettyJsonWriter((IndentedPrintWriter)output) : (this.prettyPrint ? new PrettyJsonWriter(new IndentedPrintWriter((Writer)output)) : new JsonWriter(output));
        this.appendMessage((JsonWriter)jsonWriter, message);
        jsonWriter.flush();
    }

    public <T extends PMessage<T>> int serialize(@Nonnull OutputStream output, @Nonnull PMessageOrBuilder<T> message) throws IOException {
        CountingOutputStream counter = new CountingOutputStream(output);
        PrettyJsonWriter jsonWriter = this.prettyPrint ? new PrettyJsonWriter((OutputStream)counter) : new JsonWriter((OutputStream)counter);
        this.appendMessage((JsonWriter)jsonWriter, message);
        jsonWriter.flush();
        counter.flush();
        return counter.getByteCount();
    }

    public <T extends PMessage<T>> int serialize(@Nonnull OutputStream output, @Nonnull PServiceCall<T> call) throws IOException {
        CountingOutputStream counter = new CountingOutputStream(output);
        PrettyJsonWriter jsonWriter = this.prettyPrint ? new PrettyJsonWriter((OutputStream)counter) : new JsonWriter((OutputStream)counter);
        jsonWriter.array().value((CharSequence)call.getMethod());
        if (this.enumValueType == IdType.ID) {
            jsonWriter.value(call.getType().asInteger());
        } else {
            jsonWriter.valueUnescaped((CharSequence)call.getType().asString().toLowerCase(Locale.US));
        }
        jsonWriter.value(call.getSequence());
        this.appendMessage((JsonWriter)jsonWriter, (PMessageOrBuilder<?>)call.getMessage());
        jsonWriter.endArray().flush();
        counter.flush();
        return counter.getByteCount();
    }

    @Nonnull
    public <T extends PMessage<T>> T deserialize(@Nonnull InputStream input, @Nonnull PMessageDescriptor<T> type) throws IOException {
        return this.deserialize((Reader)new Utf8StreamReader(input), type);
    }

    public <T extends PMessage<T>> T deserialize(@Nonnull Reader input, @Nonnull PMessageDescriptor<T> type) throws IOException {
        try {
            JsonTokenizer tokenizer = new JsonTokenizer(input, this.prettyPrint ? 1024 : 32768);
            if (!tokenizer.hasNext()) {
                throw new SerializerException("Empty json body", new Object[0]);
            }
            return (T)Objects.requireNonNull((PMessage)this.parseTypedValue(tokenizer.expect("Impossible"), tokenizer, type, false));
        }
        catch (JsonException e) {
            throw new JsonSerializerException(e);
        }
    }

    @Nonnull
    public <T extends PMessage<T>> PServiceCall<T> deserialize(@Nonnull InputStream input, @Nonnull PService service) throws IOException {
        JsonTokenizer tokenizer = new JsonTokenizer(input, this.prettyPrint ? 1024 : 32768);
        return this.parseServiceCall(tokenizer, service);
    }

    @Override
    public boolean binaryProtocol() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyEndOfContent(@Nonnull InputStream input) throws IOException {
        JsonTokenizer tokenizer = new JsonTokenizer(input);
        try {
            List lines = tokenizer.getRemainingLines(true);
            if (lines.size() > 0) {
                throw new SerializerException("More content after end: " + (String)lines.get(0), new Object[0]).setExceptionType(PApplicationExceptionType.PROTOCOL_ERROR);
            }
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyEndOfContent(@Nonnull Reader input) throws IOException {
        JsonTokenizer tokenizer = new JsonTokenizer(input);
        try {
            List lines = tokenizer.getRemainingLines(true);
            if (lines.size() > 0) {
                throw new SerializerException("More content after end: " + (String)lines.get(0), new Object[0]).setExceptionType(PApplicationExceptionType.PROTOCOL_ERROR);
            }
        }
        finally {
            input.close();
        }
    }

    @Override
    @Nonnull
    public String mediaType() {
        if (this.fieldIdType == IdType.NAME || this.fieldIdType == IdType.POJO) {
            return JSON_MEDIA_TYPE;
        }
        return MEDIA_TYPE;
    }

    private JsonSerializer(boolean readStrict, boolean prettyPrint, IdType fieldIdType, IdType enumValueType, boolean flattenUnionOf) {
        this.readStrict = readStrict;
        this.prettyPrint = prettyPrint;
        this.fieldIdType = fieldIdType;
        this.enumValueType = enumValueType;
        this.flattenUnionOf = flattenUnionOf;
    }

    private <T extends PMessage<T>> PServiceCall<T> parseServiceCall(JsonTokenizer tokenizer, PService service) throws IOException {
        PServiceCallType type = null;
        String methodName = null;
        int sequence = 0;
        try {
            PMessageDescriptor descriptor;
            tokenizer.expectSymbol("service call start", new char[]{'['});
            methodName = tokenizer.expectString("method name").rawJsonLiteral();
            tokenizer.expectSymbol("entry sep", new char[]{','});
            JsonToken callTypeToken = tokenizer.expect("call type");
            if (callTypeToken.isInteger()) {
                byte typeKey = callTypeToken.byteValue();
                type = PServiceCallType.findById(Integer.valueOf(typeKey));
                if (type == null) {
                    throw new SerializerException("Service call type " + typeKey + " is not valid", new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
            } else if (callTypeToken.isLiteral()) {
                String typeName = callTypeToken.rawJsonLiteral();
                type = PServiceCallType.findByName(typeName.toUpperCase(Locale.US));
                if (type == null) {
                    throw new SerializerException("Service call type \"" + Strings.escape((CharSequence)typeName) + "\" is not valid", new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
            } else {
                throw new SerializerException("Invalid service call type token " + callTypeToken, new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
            }
            tokenizer.expectSymbol("entry sep", new char[]{','});
            sequence = tokenizer.expectNumber("Service call sequence").intValue();
            tokenizer.expectSymbol("entry sep", new char[]{','});
            if (type == PServiceCallType.EXCEPTION) {
                PApplicationException ex = (PApplicationException)this.parseTypedValue(tokenizer.expect("Message start"), tokenizer, PApplicationException.kDescriptor, false);
                tokenizer.expectSymbol("service call end", new char[]{']'});
                return new PServiceCall<PApplicationException>(methodName, type, sequence, ex);
            }
            PServiceMethod method = service.getMethod(methodName);
            if (method == null) {
                throw new SerializerException("No such method " + methodName + " on " + service.getQualifiedName(), new Object[0]).setExceptionType(PApplicationExceptionType.UNKNOWN_METHOD);
            }
            PMessageDescriptor pMessageDescriptor = descriptor = this.isRequestCallType(type) ? method.getRequestType() : method.getResponseType();
            if (descriptor == null) {
                throw new SerializerException("No %s type for %s.%s()", this.isRequestCallType(type) ? "request" : "response", service.getQualifiedName(), methodName).setExceptionType(PApplicationExceptionType.UNKNOWN_METHOD);
            }
            PMessage message = (PMessage)this.parseTypedValue(tokenizer.expect("message start"), tokenizer, descriptor, false);
            tokenizer.expectSymbol("service call end", new char[]{']'});
            return new PServiceCall<PMessage>(methodName, type, sequence, message);
        }
        catch (SerializerException se) {
            throw new SerializerException(se).setMethodName(methodName).setCallType(type).setSequenceNo(sequence);
        }
        catch (JsonException je) {
            throw new JsonSerializerException(je).setMethodName(methodName).setCallType(type).setSequenceNo(sequence);
        }
    }

    private <T extends PMessage<T>> T parseMessage(JsonTokenizer tokenizer, PMessageDescriptor<T> type) throws JsonException, IOException {
        JsonToken token;
        PMessageBuilder<T> builder = type.builder();
        if (type.getVariant() == PMessageVariant.UNION && type.getImplementing() != null && (token = tokenizer.peek("field spec")).isLiteral() && (token.rawJsonLiteral().equals("__typename") || token.rawJsonLiteral().equals("0"))) {
            tokenizer.next();
            tokenizer.expectSymbol("field value sep", new char[]{':'});
            token = tokenizer.expectString("type name");
            String typeName = token.rawJsonLiteral();
            PField<T> field = null;
            for (PField<T> f : type.getFields()) {
                if (!f.getDescriptor().getName().equals(typeName) && !f.getDescriptor().getQualifiedName().equals(typeName)) continue;
                field = f;
                break;
            }
            if (field == null) {
                if (this.readStrict) {
                    throw new JsonException("No field of type '" + typeName + "'", tokenizer, token);
                }
                while (tokenizer.expectSymbol("message end or sep", new char[]{'}', ','}) == ',') {
                    tokenizer.expectString("field spec");
                    tokenizer.expectSymbol("field value sep", new char[]{':'});
                    this.consume(tokenizer.expect("field value"), tokenizer);
                }
                return builder.build();
            }
            if (tokenizer.expectSymbol("message end or sep", new char[]{'}', ','}) == '}') {
                builder.set(field, type.builder().build());
                return builder.build();
            }
            builder.set(field, this.parseMessage(tokenizer, (PMessageDescriptor)field.getDescriptor()));
            return builder.build();
        }
        if (tokenizer.peek("message end or key").isSymbol('}')) {
            tokenizer.next();
        } else {
            int sep = 123;
            while (sep != 125) {
                JsonToken token2 = tokenizer.expectString("field spec");
                String key = token2.rawJsonLiteral();
                PField<T> field = Strings.isInteger((CharSequence)key) ? type.findFieldById(Integer.parseInt(key)) : (this.fieldIdType == IdType.POJO ? type.findFieldByPojoName(key) : type.findFieldByName(key));
                tokenizer.expectSymbol("field KV sep", new char[]{':'});
                if (field != null) {
                    Object value = this.parseTypedValue(tokenizer.expect("field value"), tokenizer, field.getDescriptor(), true);
                    builder.set(field.getId(), value);
                } else {
                    this.consume(tokenizer.expect("field value"), tokenizer);
                }
                sep = tokenizer.expectSymbol("message end or sep", new char[]{'}', ','});
            }
        }
        if (this.readStrict) {
            try {
                builder.validate();
            }
            catch (IllegalStateException e) {
                throw new SerializerException(e, e.getMessage(), new Object[0]);
            }
        }
        return builder.build();
    }

    private <T extends PMessage<T>> T parseCompactMessage(JsonTokenizer tokenizer, PMessageDescriptor<T> type) throws IOException, JsonException {
        PMessageBuilder<T> builder = type.builder();
        int i = 0;
        int sep = 91;
        while (sep != 93) {
            PField<T> field;
            if ((field = type.findFieldById(++i)) != null) {
                Object value = this.parseTypedValue(tokenizer.expect("field value"), tokenizer, field.getDescriptor(), true);
                builder.set(i, value);
            } else {
                this.consume(tokenizer.expect("compact field value"), tokenizer);
            }
            sep = tokenizer.expectSymbol("compact entry sep", new char[]{']', ','});
        }
        if (this.readStrict) {
            try {
                builder.validate();
            }
            catch (IllegalStateException e) {
                throw new SerializerException(e, e.getMessage(), new Object[0]);
            }
        }
        return builder.build();
    }

    private void consume(JsonToken token, JsonTokenizer tokenizer) throws IOException, JsonException {
        block6: {
            block7: {
                if (!token.isSymbol()) break block6;
                if (!token.isSymbol('[')) break block7;
                if (tokenizer.peek("lists end or value").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    int sep = 91;
                    while (sep != 93) {
                        this.consume(tokenizer.expect("list item"), tokenizer);
                        sep = tokenizer.expectSymbol("list sep", new char[]{']', ','});
                    }
                }
                break block6;
            }
            if (!token.isSymbol('{')) break block6;
            if (tokenizer.peek("map end or key").isSymbol('}')) {
                tokenizer.next();
            } else {
                int sep = 123;
                while (sep != 125) {
                    tokenizer.expectString("map key");
                    tokenizer.expectSymbol("map KV sep", new char[]{':'});
                    this.consume(tokenizer.expect("entry value"), tokenizer);
                    sep = tokenizer.expectSymbol("map end or sep", new char[]{'}', ','});
                }
            }
        }
    }

    Object parseTypedValue(JsonToken token, JsonTokenizer tokenizer, PDescriptor t, boolean allowNull) throws IOException, JsonException {
        if (token.isNull()) {
            if (!allowNull) {
                throw new SerializerException("Null value as body.", new Object[0]);
            }
            return null;
        }
        switch (t.getType()) {
            case VOID: {
                if (token.isBoolean()) {
                    return token.booleanValue() ? Boolean.TRUE : null;
                }
                throw new SerializerException("Not a void token value: '" + token + "'", new Object[0]);
            }
            case BOOL: {
                if (token.isBoolean()) {
                    return token.booleanValue();
                }
                throw new SerializerException("No boolean value for token: '" + token + "'", new Object[0]);
            }
            case BYTE: {
                if (token.isInteger()) {
                    return token.byteValue();
                }
                throw new SerializerException("Not a valid byte value: '" + token + "'", new Object[0]);
            }
            case I16: {
                if (token.isInteger()) {
                    return token.shortValue();
                }
                throw new SerializerException("Not a valid short value: '" + token + "'", new Object[0]);
            }
            case I32: {
                if (token.isInteger()) {
                    return token.intValue();
                }
                throw new SerializerException("Not a valid int value: '" + token + "'", new Object[0]);
            }
            case I64: {
                if (token.isInteger()) {
                    return token.longValue();
                }
                throw new SerializerException("Not a valid long value: '" + token + "'", new Object[0]);
            }
            case DOUBLE: {
                if (token.isNumber()) {
                    return token.doubleValue();
                }
                throw new SerializerException("Not a valid double value: '" + token + "'", new Object[0]);
            }
            case STRING: {
                if (token.isLiteral()) {
                    return token.decodeJsonLiteral();
                }
                throw new SerializerException("Not a valid string value: '" + token + "'", new Object[0]);
            }
            case BINARY: {
                if (token.isLiteral()) {
                    try {
                        return Binary.fromBase64((String)token.rawJsonLiteral());
                    }
                    catch (IllegalArgumentException e) {
                        throw new SerializerException(e, "Unable to parse Base64 data: " + token, new Object[0]);
                    }
                }
                throw new SerializerException("Not a valid binary value: " + token, new Object[0]);
            }
            case ENUM: {
                PEnumBuilder eb = ((PEnumDescriptor)t).builder();
                if (token.isInteger()) {
                    eb.setById(token.intValue());
                } else if (token.isLiteral()) {
                    eb.setByName(token.rawJsonLiteral());
                } else {
                    throw new SerializerException(token + " is not a enum value type", new Object[0]);
                }
                if (!allowNull && !eb.valid()) {
                    throw new SerializerException(token + " is not a known enum value for " + t.getQualifiedName(), new Object[0]);
                }
                return eb.build();
            }
            case MESSAGE: {
                PMessageDescriptor st = (PMessageDescriptor)t;
                if (token.isSymbol('{')) {
                    return this.parseMessage(tokenizer, st);
                }
                if (token.isSymbol('[')) {
                    if (this.isCompactible(st)) {
                        return this.parseCompactMessage(tokenizer, st);
                    }
                    throw new SerializerException(st.getName() + " is not compatible for compact struct notation.", new Object[0]);
                }
                throw new SerializerException("expected message start, found: '%s'", token);
            }
            case MAP: {
                PMap mapType = (PMap)t;
                PDescriptor itemType = mapType.itemDescriptor();
                PDescriptor keyType = mapType.keyDescriptor();
                if (!token.isSymbol('{')) {
                    throw new SerializerException("Invalid start of map '" + token + "'", new Object[0]);
                }
                PMap.Builder map = mapType.builder(10);
                if (tokenizer.peek("map end or value").isSymbol('}')) {
                    tokenizer.next();
                } else {
                    int sep = 123;
                    while (sep != 125) {
                        Object key = this.parseMapKey(tokenizer.expectString("map key").decodeJsonLiteral(), keyType);
                        tokenizer.expectSymbol("map K/V sep", new char[]{':'});
                        Object value = this.parseTypedValue(tokenizer.expect("map value"), tokenizer, itemType, false);
                        if (key != null && value != null) {
                            map.put(key, value);
                        }
                        sep = tokenizer.expectSymbol("map end or sep", new char[]{'}', ','});
                    }
                }
                return map.build();
            }
            case SET: {
                PDescriptor itemType = ((PSet)t).itemDescriptor();
                if (!token.isSymbol('[')) {
                    throw new SerializerException("Invalid start of set '" + token + "'", new Object[0]);
                }
                PSet.Builder set = ((PSet)t).builder(10);
                if (tokenizer.peek("set end or value").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    int sep = 91;
                    while (sep != 93) {
                        Object val = this.parseTypedValue(tokenizer.expect("set value"), tokenizer, itemType, !this.readStrict);
                        if (val != null) {
                            set.add(val);
                        }
                        sep = tokenizer.expectSymbol("set end or sep", new char[]{',', ']'});
                    }
                }
                return set.build();
            }
            case LIST: {
                PDescriptor itemType = ((PList)t).itemDescriptor();
                if (!token.isSymbol('[')) {
                    throw new SerializerException("Invalid start of list '" + token + "'", new Object[0]);
                }
                PList.Builder list = ((PList)t).builder(10);
                if (tokenizer.peek("list end or value").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    int sep = 91;
                    while (sep != 93) {
                        list.add(Objects.requireNonNull(this.parseTypedValue(tokenizer.expect("list value"), tokenizer, itemType, false)));
                        sep = tokenizer.expectSymbol("list end or sep", new char[]{',', ']'});
                    }
                }
                return list.build();
            }
        }
        throw new SerializerException("Unhandled item type " + t.getQualifiedName(), new Object[0]);
    }

    private boolean isCompactible(PMessageDescriptor descriptor) {
        return descriptor instanceof JsonCompactibleDescriptor && ((JsonCompactibleDescriptor)((Object)descriptor)).isJsonCompactible();
    }

    private boolean isCompact(PMessageOrBuilder message) {
        return message instanceof JsonCompactible && ((JsonCompactible)((Object)message)).jsonCompact();
    }

    private Object parseMapKey(String key, PDescriptor keyType) throws SerializerException {
        try {
            switch (keyType.getType()) {
                case BOOL: {
                    if (key.equalsIgnoreCase("true")) {
                        return Boolean.TRUE;
                    }
                    if (key.equalsIgnoreCase("false")) {
                        return Boolean.FALSE;
                    }
                    throw new SerializerException("Invalid boolean value: \"" + Strings.escape((CharSequence)key) + "\"", new Object[0]);
                }
                case BYTE: {
                    return Byte.parseByte(key);
                }
                case I16: {
                    return Short.parseShort(key);
                }
                case I32: {
                    return Integer.parseInt(key);
                }
                case I64: {
                    return Long.parseLong(key);
                }
                case DOUBLE: {
                    try {
                        JsonTokenizer tokenizer = new JsonTokenizer((InputStream)new ByteArrayInputStream(key.getBytes(StandardCharsets.US_ASCII)));
                        JsonToken token = tokenizer.expect("double number");
                        if (!token.isNumber()) {
                            throw new SerializerException("Unable to parse double from key \"" + key + "\"", new Object[0]);
                        }
                        if (tokenizer.hasNext()) {
                            throw new SerializerException("Garbage after double: \"" + key + "\"", new Object[0]);
                        }
                        return token.doubleValue();
                    }
                    catch (SerializerException e) {
                        throw e;
                    }
                    catch (IOException | JsonException e) {
                        throw new SerializerException(e, "Unable to parse double from key \"" + key + "\"", new Object[0]);
                    }
                }
                case STRING: {
                    return key;
                }
                case BINARY: {
                    try {
                        return Binary.fromBase64((String)key);
                    }
                    catch (IllegalArgumentException e) {
                        throw new SerializerException(e, "Unable to parse Base64 data", new Object[0]);
                    }
                }
                case ENUM: {
                    PEnumBuilder eb = ((PEnumDescriptor)keyType).builder();
                    if (Strings.isInteger((CharSequence)key)) {
                        eb.setById(Integer.parseInt(key));
                    } else {
                        eb.setByName(key);
                    }
                    if (this.readStrict && !eb.valid()) {
                        throw new SerializerException("\"%s\" is not a known enum value for %s", Strings.escape((CharSequence)key), keyType.getQualifiedName());
                    }
                    return eb.build();
                }
                case MESSAGE: {
                    PMessageDescriptor st = (PMessageDescriptor)keyType;
                    if (!st.isSimple()) {
                        throw new SerializerException("Only simple structs can be used as map key. %s is not.", st.getQualifiedName());
                    }
                    ByteArrayInputStream input = new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8));
                    try {
                        JsonTokenizer tokenizer = new JsonTokenizer((InputStream)input);
                        if ('{' == tokenizer.expectSymbol("message start", new char[]{'{', '['})) {
                            return this.parseMessage(tokenizer, st);
                        }
                        return this.parseCompactMessage(tokenizer, st);
                    }
                    catch (IOException | JsonException e) {
                        throw new SerializerException(e, "Error parsing message key: " + e.getMessage(), new Object[0]);
                    }
                }
            }
            throw new SerializerException("Illegal key type: %s", new Object[]{keyType.getType()});
        }
        catch (NumberFormatException nfe) {
            throw new SerializerException(nfe, "Unable to parse numeric value %s", key);
        }
    }

    private void appendMessage(JsonWriter writer, PMessageOrBuilder<?> message) throws SerializerException {
        PDescriptor type = message.descriptor();
        if (message instanceof PUnion) {
            writer.object();
            if (((PUnion)message).unionFieldIsSet()) {
                PField field = ((PUnion)message).unionField();
                if (this.flattenUnionOf && ((PMessageDescriptor)type).getImplementing() != null) {
                    message = (PMessageOrBuilder)message.get(field.getId());
                    type = message.descriptor();
                    writer.keyUnescaped((CharSequence)(this.fieldIdType == IdType.ID ? "0" : "__typename")).valueUnescaped((CharSequence)((PDeclaredDescriptor)type).getName());
                    for (PField iField : ((PMessageDescriptor)type).getFields()) {
                        if (!message.has(iField.getId())) continue;
                        Object value = message.get(iField.getId());
                        if (IdType.ID.equals((Object)this.fieldIdType)) {
                            writer.key(iField.getId());
                        } else if (IdType.POJO.equals((Object)this.fieldIdType)) {
                            writer.keyUnescaped((CharSequence)field.getPojoName());
                        } else {
                            writer.keyUnescaped((CharSequence)iField.getName());
                        }
                        this.appendTypedValue(writer, iField.getDescriptor(), value);
                    }
                } else {
                    Object value = message.get(field.getId());
                    if (IdType.ID.equals((Object)this.fieldIdType)) {
                        writer.key(field.getId());
                    } else if (IdType.POJO.equals((Object)this.fieldIdType)) {
                        writer.keyUnescaped((CharSequence)field.getPojoName());
                    } else {
                        writer.keyUnescaped((CharSequence)field.getName());
                    }
                    this.appendTypedValue(writer, field.getDescriptor(), value);
                }
            }
            writer.endObject();
        } else if (this.isCompact(message)) {
            writer.array();
            for (PField field : ((PMessageDescriptor)type).getFields()) {
                if (!message.has(field.getId())) break;
                this.appendTypedValue(writer, field.getDescriptor(), message.get(field.getId()));
            }
            writer.endArray();
        } else {
            writer.object();
            for (PField field : ((PMessageDescriptor)type).getFields()) {
                if (!message.has(field.getId())) continue;
                Object value = message.get(field.getId());
                if (IdType.ID.equals((Object)this.fieldIdType)) {
                    writer.key(field.getId());
                } else if (IdType.POJO.equals((Object)this.fieldIdType)) {
                    writer.keyUnescaped((CharSequence)field.getPojoName());
                } else {
                    writer.keyUnescaped((CharSequence)field.getName());
                }
                this.appendTypedValue(writer, field.getDescriptor(), value);
            }
            writer.endObject();
        }
    }

    void appendTypedValue(JsonWriter writer, PDescriptor type, Object value) throws SerializerException {
        switch (type.getType()) {
            case VOID: {
                writer.value(true);
                break;
            }
            case MESSAGE: {
                PMessage message = (PMessage)value;
                this.appendMessage(writer, message);
                break;
            }
            case MAP: {
                writer.object();
                PMap mapType = (PMap)type;
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    this.appendPrimitiveKey(writer, entry.getKey());
                    this.appendTypedValue(writer, mapType.itemDescriptor(), entry.getValue());
                }
                writer.endObject();
                break;
            }
            case SET: 
            case LIST: {
                writer.array();
                PContainer containerType = (PContainer)type;
                Collection collection = (Collection)value;
                for (Object i : collection) {
                    this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                }
                writer.endArray();
                break;
            }
            default: {
                this.appendPrimitive(writer, value);
            }
        }
    }

    private void appendPrimitiveKey(JsonWriter writer, Object primitive) throws SerializerException {
        if (primitive instanceof PEnumValue) {
            if (IdType.ID.equals((Object)this.enumValueType)) {
                writer.key(((PEnumValue)primitive).asInteger());
            } else {
                writer.keyUnescaped((CharSequence)((PEnumValue)primitive).asString());
            }
        } else if (primitive instanceof Boolean) {
            writer.key(((Boolean)primitive).booleanValue());
        } else if (primitive instanceof Byte) {
            writer.key(((Byte)primitive).byteValue());
        } else if (primitive instanceof Short) {
            writer.key(((Short)primitive).shortValue());
        } else if (primitive instanceof Integer) {
            writer.key(((Integer)primitive).intValue());
        } else if (primitive instanceof Long) {
            writer.key(((Long)primitive).longValue());
        } else if (primitive instanceof Double) {
            writer.key(((Double)primitive).doubleValue());
        } else if (primitive instanceof String) {
            writer.key((CharSequence)((String)primitive));
        } else if (primitive instanceof Binary) {
            writer.key((Binary)primitive);
        } else if (primitive instanceof PMessage) {
            PMessage message = (PMessage)primitive;
            if (!((PMessageDescriptor)message.descriptor()).isSimple()) {
                throw new SerializerException("Only simple messages can be used as map keys. " + message.descriptor().getQualifiedName() + " is not.", new Object[0]);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter json = new JsonWriter((OutputStream)baos);
            this.appendMessage(json, message);
            json.flush();
            writer.key((CharSequence)new String(baos.toByteArray(), StandardCharsets.UTF_8));
        } else {
            throw new SerializerException("illegal simple type class " + primitive.getClass().getSimpleName(), new Object[0]);
        }
    }

    private void appendPrimitive(JsonWriter writer, Object primitive) throws SerializerException {
        if (primitive instanceof PEnumValue) {
            if (IdType.ID.equals((Object)this.enumValueType)) {
                writer.value(((PEnumValue)primitive).asInteger());
            } else {
                writer.valueUnescaped((CharSequence)((PEnumValue)primitive).asString());
            }
        } else if (primitive instanceof Boolean) {
            writer.value(((Boolean)primitive).booleanValue());
        } else if (primitive instanceof Byte) {
            writer.value(((Byte)primitive).byteValue());
        } else if (primitive instanceof Short) {
            writer.value(((Short)primitive).shortValue());
        } else if (primitive instanceof Integer) {
            writer.value(((Integer)primitive).intValue());
        } else if (primitive instanceof Long) {
            writer.value(((Long)primitive).longValue());
        } else if (primitive instanceof Double) {
            writer.value(((Double)primitive).doubleValue());
        } else if (primitive instanceof CharSequence) {
            writer.value((CharSequence)((String)primitive));
        } else if (primitive instanceof Binary) {
            writer.value((Binary)primitive);
        } else {
            throw new SerializerException("illegal primitive type class " + primitive.getClass().getSimpleName(), new Object[0]);
        }
    }

    private static enum IdType {
        ID,
        NAME,
        POJO;

    }
}

