/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer.pretty;

import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import net.morimekta.providence.serializer.pretty.PrettyToken;
import net.morimekta.providence.serializer.pretty.PrettyTokenType;
import net.morimekta.util.io.Utf8StreamReader;
import net.morimekta.util.lexer.TokenizerBase;

public class PrettyTokenizer
extends TokenizerBase<PrettyTokenType, PrettyToken> {
    public PrettyTokenizer(InputStream in) {
        this(in, 2048);
    }

    public PrettyTokenizer(InputStream in, int bufferSize) {
        this((Reader)new Utf8StreamReader(in), bufferSize, false);
    }

    public PrettyTokenizer(Reader in, int bufferSize, boolean preLoadAll) {
        super(in, bufferSize, preLoadAll);
    }

    protected boolean startString() {
        return this.lastChar == 34 || this.lastChar == 39;
    }

    protected PrettyToken genericToken(char[] buffer, int offset, int len, @Nonnull PrettyTokenType type, int lineNo, int linePos) {
        return new PrettyToken(buffer, offset, len, type, lineNo, linePos);
    }

    protected PrettyToken identifierToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        return new PrettyToken(buffer, offset, len, PrettyTokenType.IDENTIFIER, lineNo, linePos);
    }

    protected PrettyToken stringToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        return new PrettyToken(buffer, offset, len, PrettyTokenType.STRING, lineNo, linePos);
    }

    protected PrettyToken numberToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        return new PrettyToken(buffer, offset, len, PrettyTokenType.NUMBER, lineNo, linePos);
    }

    protected PrettyToken symbolToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        return new PrettyToken(buffer, offset, len, PrettyTokenType.SYMBOL, lineNo, linePos);
    }
}

