/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer.pretty;

import java.util.regex.Pattern;
import net.morimekta.providence.serializer.pretty.PrettyTokenType;
import net.morimekta.util.lexer.Token;

public class PrettyToken
extends Token<PrettyTokenType> {
    public static final char kMessageStart = '{';
    public static final char kMessageEnd = '}';
    public static final char kKeyValueSep = ':';
    public static final char kFieldValueSep = '=';
    public static final char kParamsStart = '(';
    public static final char kParamsEnd = ')';
    public static final char kListStart = '[';
    public static final char kListEnd = ']';
    public static final char kListSep = ',';
    public static final char kFieldSep = ';';
    public static final char kIdentifierSep = '.';
    public static final char kLiteralDoubleQuote = '\"';
    public static final String B64 = "b64";
    public static final String HEX = "hex";
    private static final Pattern RE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_QUALIFIED_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_REFERENCE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*([.][_a-zA-Z][_a-zA-Z0-9]*)*");
    private static final Pattern RE_INTEGER = Pattern.compile("-?(0|[1-9][0-9]*|0[0-7]+|0x[0-9a-fA-F]+)");
    private static final Pattern RE_REAL = Pattern.compile("-?(0?\\.[0-9]+|[1-9][0-9]*\\.[0-9]*)([eE][+-]?[0-9][0-9]*)?");

    public PrettyToken(char[] fb, int off, int len, PrettyTokenType type, int lineNo, int linePos) {
        super(fb, off, len, (Object)type, lineNo, linePos);
    }

    public boolean isSymbol(char symbol) {
        return this.len == 1 && this.fb[this.off] == symbol;
    }

    public boolean isStringLiteral() {
        return this.type == PrettyTokenType.STRING;
    }

    public boolean isIdentifier() {
        return RE_IDENTIFIER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isQualifiedIdentifier() {
        return RE_QUALIFIED_IDENTIFIER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isReferenceIdentifier() {
        return RE_REFERENCE_IDENTIFIER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isInteger() {
        return RE_INTEGER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isReal() {
        return RE_REAL.matcher((CharSequence)((Object)this)).matches();
    }
}

