/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer.pretty;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.pretty.PrettyToken;
import net.morimekta.util.Strings;
import net.morimekta.util.lexer.LexerException;

public class PrettyException
extends SerializerException {
    private static final long serialVersionUID = 1513434504497049610L;
    private int lineNo;
    private int linePos;
    private CharSequence line;
    private String file;
    private int length;

    public PrettyException(LexerException e, String format, Object ... args) {
        super((Throwable)e, format, args);
        if (e.getLine() != null) {
            this.setLine(e.getLine());
            this.setLineNo(e.getLineNo());
            this.setLinePos(e.getLinePos());
            this.setLength(e.getLength());
        }
    }

    public PrettyException(String format, Object ... args) {
        super(format, args);
    }

    public PrettyException(Throwable cause, String format, Object ... args) {
        super(cause, format, args);
    }

    public PrettyException(PrettyToken token, String format, Object ... args) {
        super(format, args);
        this.setLinePos(token.linePos());
        this.setLineNo(token.lineNo());
        this.setLength(token.length());
        this.setLine(token.line());
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getLinePos() {
        return this.linePos;
    }

    public int getLength() {
        return this.length;
    }

    @Nullable
    public String getLine() {
        return this.line == null ? null : this.line.toString();
    }

    @Nullable
    public String getFile() {
        return this.file;
    }

    public PrettyException setLineNo(int lineNo) {
        this.lineNo = lineNo;
        return this;
    }

    public PrettyException setLinePos(int linePos) {
        this.linePos = linePos;
        return this;
    }

    public PrettyException setLength(int len) {
        this.length = len;
        return this;
    }

    public PrettyException setLine(CharSequence line) {
        this.line = line;
        return this;
    }

    public PrettyException setFile(String file) {
        this.file = file;
        return this;
    }

    @Override
    public PrettyException initCause(Throwable cause) {
        return (PrettyException)super.initCause(cause);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "\n" + this.displayString();
    }

    @Override
    @Nonnull
    public String displayString() {
        if (this.lineNo > 0) {
            String fileSpec = "";
            if (this.file != null) {
                fileSpec = " in " + this.file;
            }
            if (this.line != null) {
                if (this.length > 1) {
                    return String.format(Locale.US, "Error%s on line %d, row %d-%d: %s%n%s%n%s%s", fileSpec, this.lineNo, this.linePos, this.linePos + this.length - 1, this.getMessage(), this.line, Strings.times((String)"-", (int)(this.linePos - 1)), Strings.times((String)"^", (int)Math.max(1, this.length)));
                }
                return String.format(Locale.US, "Error%s on line %d, row %d: %s%n%s%n%s^", fileSpec, this.lineNo, this.linePos, this.getMessage(), this.line, Strings.times((String)"-", (int)(this.linePos - 1)));
            }
            return String.format(Locale.US, "Error%s on line %d, row %d: %s", fileSpec, this.getLineNo(), this.getLinePos(), this.getMessage());
        }
        if (this.file != null) {
            return String.format(Locale.US, "Error in %s: %s", this.file, this.getMessage());
        }
        return String.format(Locale.US, "Error: %s", this.getMessage());
    }
}

