/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;

public interface PField<M extends PMessage<M>> {
    public int getId();

    @Nonnull
    public PRequirement getRequirement();

    @Nonnull
    default public PType getType() {
        return this.getDescriptor().getType();
    }

    @Nonnull
    public PDescriptor getDescriptor();

    @Nullable
    public PStructDescriptor getArgumentsType();

    @Nonnull
    public String getName();

    @Nonnull
    public String getPojoName();

    public boolean hasDefaultValue();

    public Object getDefaultValue();

    @Nonnull
    public PMessageDescriptor<M> onMessageType();

    @Nonnull
    public static String asString(PField field) {
        StringBuilder builder = new StringBuilder();
        builder.append("field(").append(field.getId()).append(": ");
        if (field.getRequirement() != PRequirement.DEFAULT) {
            builder.append(field.getRequirement().label).append(" ");
        }
        builder.append(field.getDescriptor().getQualifiedName()).append(' ').append(field.getName()).append(')');
        return builder.toString();
    }

    @Nonnull
    public static String asIfString(PField field) {
        StringBuilder builder = new StringBuilder();
        builder.append("field(");
        if (field.getRequirement() != PRequirement.DEFAULT) {
            builder.append(field.getRequirement().label).append(" ");
        }
        builder.append(field.getDescriptor().getQualifiedName()).append(' ').append(field.getName()).append(')');
        return builder.toString();
    }
}

