/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.util.Pair;

public class MessageValidator<M extends PMessage<M>, E extends Exception> {
    private final Function<String, E> onMismatch;
    private final List<Pair<String, Validation<M, E>>> predicateList;

    public void validate(PMessageOrBuilder<M> message) throws E {
        if (message instanceof PMessageBuilder) {
            message = ((PMessageBuilder)message).build();
        }
        for (Pair<String, Validation<M, E>> predicate : this.predicateList) {
            if (((Validation)predicate.second).test((PMessage)message)) continue;
            throw (Exception)this.onMismatch.apply((String)predicate.first);
        }
    }

    public static <M extends PMessage<M>, E extends Exception> Builder<M, E> builder(@Nonnull PMessageDescriptor<M> descriptor, @Nonnull Function<String, E> onMismatch) {
        return new Builder(descriptor, onMismatch);
    }

    private MessageValidator(Function<String, E> onMismatch, List<Pair<String, Validation<M, E>>> predicateList) {
        this.onMismatch = onMismatch;
        this.predicateList = predicateList;
    }

    public static class Builder<M extends PMessage<M>, E extends Exception> {
        private final PMessageDescriptor<M> descriptor;
        private final Function<String, E> onMismatch;
        private final List<Pair<String, Validation<M, E>>> predicateList;

        @Nonnull
        public MessageValidator<M, E> build() {
            return new MessageValidator(this.onMismatch, this.predicateList);
        }

        @Nonnull
        public Builder<M, E> expect(@Nonnull String text, @Nonnull Predicate<M> predicate) {
            this.predicateList.add(Pair.create((Object)text, predicate::test));
            return this;
        }

        @Nonnull
        public <M2 extends PMessage<M2>> Builder<M, E> expect(@Nonnull PField<M> field, @Nonnull PMessageDescriptor<M2> descriptor, @Nonnull Consumer<Builder<M2, E>> builderConsumer) {
            if (!field.getDescriptor().equals(descriptor)) {
                throw new IllegalArgumentException("Field type mismatch, " + field.getName() + " is not a " + descriptor.getQualifiedName());
            }
            Builder<M2, E> builder = MessageValidator.builder(descriptor, this.onMismatch);
            builderConsumer.accept(builder);
            MessageValidator validator = builder.build();
            Validation predicate = message -> {
                validator.validate((PMessageOrBuilder)message.get(field));
                return true;
            };
            this.predicateList.add(Pair.create((Object)"validation", predicate));
            return this;
        }

        @Nonnull
        public Builder<M, E> expectNotNull() {
            return this.expectNotNull("null " + this.descriptor.getQualifiedName() + " value");
        }

        @Nonnull
        public Builder<M, E> expectNotNull(String text) {
            this.predicateList.add(Pair.create((Object)text, Objects::nonNull));
            return this;
        }

        @Nonnull
        @SafeVarargs
        public final Builder<M, E> expectPresent(PField<M> ... fields) {
            for (PField<M> field : fields) {
                this.expectPresent(field.getName() + " not present on " + this.descriptor.getQualifiedName(), field);
            }
            return this;
        }

        @Nonnull
        public Builder<M, E> expectPresent(@Nonnull String text, @Nonnull PField<M> field) {
            this.predicateList.add(Pair.create((Object)text, message -> message.has(field)));
            return this;
        }

        @Nonnull
        @SafeVarargs
        public final Builder<M, E> expectMissing(PField<M> ... fields) {
            for (PField<M> field : fields) {
                this.expectMissing(field.getName() + " present on " + this.descriptor.getQualifiedName(), field);
            }
            return this;
        }

        @Nonnull
        public Builder<M, E> expectMissing(@Nonnull String text, @Nonnull PField<M> field) {
            this.predicateList.add(Pair.create((Object)text, message -> !message.has(field)));
            return this;
        }

        private Builder(PMessageDescriptor<M> descriptor, @Nonnull Function<String, E> onMismatch) {
            this.descriptor = descriptor;
            this.onMismatch = onMismatch;
            this.predicateList = new ArrayList<Pair<String, Validation<M, E>>>();
        }
    }

    @FunctionalInterface
    public static interface Validation<M extends PMessage<M>, E extends Exception> {
        public boolean test(M var1) throws E;
    }
}

