/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.pretty.PrettyException;
import net.morimekta.providence.serializer.pretty.PrettyLexer;
import net.morimekta.providence.serializer.pretty.PrettyToken;
import net.morimekta.providence.serializer.pretty.PrettyTokenType;
import net.morimekta.providence.serializer.pretty.PrettyTokenizer;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.CountingOutputStream;
import net.morimekta.util.io.IndentedPrintWriter;
import net.morimekta.util.lexer.LexerException;
import net.morimekta.util.lexer.Tokenizer;
import net.morimekta.util.lexer.UncheckedLexerException;

public class PrettySerializer
extends Serializer {
    public static final String MEDIA_TYPE = "text/plain";
    private static final PrettySerializer DEBUG_STRING_SERIALIZER = new PrettySerializer();
    private static final String INDENT = "  ";
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String LIST_SEP = ",";
    private final String indent;
    private final String space;
    private final String newline;
    private final String entrySep;
    private final boolean strict;
    private final boolean prefixWithQualifiedName;

    @Nonnull
    public static <Message extends PMessage<Message>> String toDebugString(PMessageOrBuilder<Message> message) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DEBUG_STRING_SERIALIZER.serialize((OutputStream)out, message);
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    @Nonnull
    public static <Message extends PMessage<Message>> Message parseDebugString(String string, PMessageDescriptor<Message> descriptor) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
            return DEBUG_STRING_SERIALIZER.deserialize((InputStream)in, descriptor);
        }
        catch (LexerException e) {
            throw new UncheckedLexerException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    public PrettySerializer() {
        this(false);
    }

    public PrettySerializer(boolean strict) {
        this(INDENT, SPACE, NEWLINE, "", strict, false);
    }

    public PrettySerializer compact() {
        return new PrettySerializer("", "", "", LIST_SEP, this.strict, false);
    }

    public PrettySerializer string() {
        return new PrettySerializer("", "", "", LIST_SEP, this.strict, true);
    }

    public PrettySerializer config() {
        return new PrettySerializer(this.indent, this.space, this.newline, this.entrySep, this.strict, true);
    }

    private PrettySerializer(String indent, String space, String newline, String entrySep, boolean strict, boolean prefixWithQualifiedName) {
        this.indent = indent;
        this.space = space;
        this.newline = newline;
        this.entrySep = entrySep;
        this.strict = strict;
        this.prefixWithQualifiedName = prefixWithQualifiedName;
    }

    @Override
    public <Message extends PMessage<Message>> int serialize(@Nonnull OutputStream out, @Nonnull PMessageOrBuilder<Message> message) {
        CountingOutputStream cout = new CountingOutputStream(out);
        IndentedPrintWriter builder = new IndentedPrintWriter((OutputStream)cout, this.indent, this.newline);
        if (this.prefixWithQualifiedName) {
            builder.append((CharSequence)message.descriptor().getQualifiedName()).append((CharSequence)this.space);
        }
        this.appendMessage(builder, message, false);
        builder.flush();
        return cout.getByteCount();
    }

    @Override
    public <Message extends PMessage<Message>> int serialize(@Nonnull OutputStream out, @Nonnull PServiceCall<Message> call) {
        CountingOutputStream cout = new CountingOutputStream(out);
        IndentedPrintWriter builder = new IndentedPrintWriter((OutputStream)cout, this.indent, this.newline);
        if (call.getSequence() != 0) {
            builder.format("%d: ", new Object[]{call.getSequence()});
        }
        builder.format("%s %s", new Object[]{call.getType().asString().toLowerCase(Locale.US), call.getMethod()}).begin(this.indent + this.indent);
        this.appendMessage(builder, (PMessageOrBuilder<?>)call.getMessage(), true);
        builder.end().newline().flush();
        return cout.getByteCount();
    }

    @Override
    @Nonnull
    public <Message extends PMessage<Message>> PServiceCall<Message> deserialize(@Nonnull InputStream input, @Nonnull PService service) throws IOException {
        String methodName = null;
        int sequence = 0;
        PServiceCallType callType = null;
        try {
            PApplicationException message;
            PrettyLexer lexer = new PrettyLexer(input);
            PrettyToken token = (PrettyToken)lexer.expect("Sequence or type");
            if (token.isInteger()) {
                sequence = (int)token.parseInteger();
                lexer.expect("Sequence type sep", t -> t.isSymbol(':'));
                token = (PrettyToken)lexer.expect("Call Type", PrettyToken::isIdentifier);
            }
            if ((callType = PServiceCallType.findByName(token.toString().toUpperCase(Locale.US))) == null) {
                throw new PrettyException(token, "No such call type %s", new Object[]{token}).setLine(token.line()).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
            }
            token = (PrettyToken)lexer.expect("method name", PrettyToken::isIdentifier);
            methodName = token.toString();
            PServiceMethod method = service.getMethod(methodName);
            if (method == null) {
                throw new PrettyException(token, "no such method %s on service %s", methodName, service.getQualifiedName()).setLine(token.line()).setExceptionType(PApplicationExceptionType.UNKNOWN_METHOD);
            }
            lexer.expect("call params start", t -> t.isSymbol('('));
            switch (callType) {
                case CALL: 
                case ONEWAY: {
                    message = this.readMessage(lexer, method.getRequestType(), true);
                    break;
                }
                case REPLY: {
                    message = this.readMessage(lexer, Optional.ofNullable(method.getResponseType()).orElseThrow(() -> new PrettyException("No reply type for method %s", method.getName())), true);
                    break;
                }
                case EXCEPTION: {
                    message = this.readMessage(lexer, PApplicationException.kDescriptor, true);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unreachable code reached");
                }
            }
            return new PServiceCall<PApplicationException>(methodName, callType, sequence, message);
        }
        catch (LexerException e) {
            throw new PrettyException(e, e.getMessage(), new Object[0]);
        }
        catch (PrettyException e) {
            e.setCallType(callType).setSequenceNo(sequence).setMethodName(methodName);
            throw e;
        }
        catch (IOException e) {
            throw new SerializerException(e, e.getMessage(), new Object[0]).setCallType(callType).setSequenceNo(sequence).setMethodName(methodName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nonnull
    public <Message extends PMessage<Message>> Message deserialize(@Nonnull InputStream input, @Nonnull PMessageDescriptor<Message> descriptor) throws IOException {
        try {
            PrettyTokenizer tokenizer = new PrettyTokenizer(input);
            PrettyLexer lexer = new PrettyLexer((Tokenizer<PrettyTokenType, PrettyToken>)tokenizer);
            PrettyToken first = (PrettyToken)lexer.peek("start of message");
            if (first.isSymbol('{')) {
                lexer.next();
                return this.readMessage(lexer, descriptor, false);
            } else {
                if (!first.isQualifiedIdentifier()) throw tokenizer.failure(first, "Expected message start or qualifier, but got '" + (Object)((Object)first) + "'", new Object[0]);
                if (!first.toString().equals(descriptor.getQualifiedName())) throw tokenizer.failure(first, "Expected qualifier " + descriptor.getQualifiedName() + " or message start, but got '" + (Object)((Object)first) + "'", new Object[0]);
                lexer.next();
                lexer.expectSymbol("message start after qualifier", new char[]{'{'});
            }
            return this.readMessage(lexer, descriptor, false);
        }
        catch (LexerException e) {
            throw new PrettyException(e, e.getMessage(), new Object[0]);
        }
    }

    private <Message extends PMessage<Message>> Message readMessage(PrettyLexer tokenizer, PMessageDescriptor<Message> descriptor, boolean params) throws IOException {
        PBuilder builder = descriptor.builder();
        PrettyToken token = (PrettyToken)tokenizer.expect("message field or end");
        while (!(!params ? token.isSymbol('}') : token.isSymbol(')'))) {
            if (!token.isIdentifier()) {
                throw new PrettyException(token, "Expected field name, but got '%s'", Strings.escape((CharSequence)((Object)token))).setLine(token.line());
            }
            PField<Message> field = descriptor.findFieldByName(token.toString());
            tokenizer.expectSymbol("field value separator", new char[]{'='});
            if (field == null) {
                this.consumeValue(tokenizer, (PrettyToken)tokenizer.expect("field value"));
            } else {
                ((PMessageBuilder)builder).set(field.getId(), this.readFieldValue(tokenizer, (PrettyToken)tokenizer.expect("field value"), field.getDescriptor()));
            }
            if (!(token = (PrettyToken)tokenizer.expect("Message field or end")).isSymbol(',') && !token.isSymbol(';')) continue;
            token = (PrettyToken)tokenizer.expect("Message field or end");
        }
        return (Message)((PMessage)builder.build());
    }

    private Object readFieldValue(PrettyLexer lexer, PrettyToken token, PDescriptor descriptor) throws IOException {
        switch (descriptor.getType()) {
            case VOID: {
                switch (token.toString().toLowerCase(Locale.US)) {
                    case "1": 
                    case "t": 
                    case "true": 
                    case "y": 
                    case "yes": {
                        return Boolean.TRUE;
                    }
                }
                throw new PrettyException(token, "Invalid void value " + (Object)((Object)token), new Object[0]).setLine(token.line());
            }
            case BOOL: {
                switch (token.toString().toLowerCase(Locale.US)) {
                    case "1": 
                    case "t": 
                    case "true": 
                    case "y": 
                    case "yes": {
                        return Boolean.TRUE;
                    }
                    case "0": 
                    case "f": 
                    case "false": 
                    case "n": 
                    case "no": {
                        return Boolean.FALSE;
                    }
                }
                throw new PrettyException(token, "Invalid boolean value " + (Object)((Object)token), new Object[0]).setLine(token.line());
            }
            case BYTE: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > 127L || val < -128L) {
                        throw new PrettyException(token, "Byte value out of bounds: " + (Object)((Object)token), new Object[0]).setLine(token.line());
                    }
                    return (byte)val;
                }
                throw new PrettyException(token, "Invalid byte value: " + (Object)((Object)token), new Object[0]).setLine(token.line());
            }
            case I16: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > 32767L || val < -32768L) {
                        throw new PrettyException(token, "Short value out of bounds: " + (Object)((Object)token), new Object[0]).setLine(token.line());
                    }
                    return (short)val;
                }
                throw new PrettyException(token, "Invalid byte value: " + (Object)((Object)token), new Object[0]).setLine(token.line());
            }
            case I32: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                        throw new PrettyException(token, "Integer value out of bounds: " + (Object)((Object)token), new Object[0]).setLine(token.line());
                    }
                    return (int)val;
                }
                throw new PrettyException(token, "Invalid byte value: " + (Object)((Object)token), new Object[0]).setLine(token.line());
            }
            case I64: {
                if (token.isInteger()) {
                    return token.parseInteger();
                }
                throw new PrettyException(token, "Invalid byte value: " + (Object)((Object)token), new Object[0]).setLine(token.line());
            }
            case DOUBLE: {
                try {
                    return token.parseDouble();
                }
                catch (NumberFormatException nfe) {
                    throw new PrettyException(token, "Number format error: " + nfe.getMessage(), new Object[0]).setLine(token.line());
                }
            }
            case STRING: {
                if (!token.isStringLiteral()) {
                    throw new PrettyException(token, "Expected string literal, but got '%s'", new Object[]{token}).setLine(token.line());
                }
                return token.decodeString(this.strict);
            }
            case BINARY: {
                switch (token.toString()) {
                    case "b64": {
                        lexer.expectSymbol("binary content start", new char[]{'('});
                        PrettyToken binary = lexer.readBinary(')');
                        if (binary == null) {
                            return Binary.empty();
                        }
                        try {
                            return Binary.fromBase64((String)binary.toString().replaceAll("[\\s\\n=]*", ""));
                        }
                        catch (IllegalArgumentException e) {
                            throw lexer.failure(binary, e.getMessage(), new Object[0]).initCause((Throwable)e);
                        }
                    }
                    case "hex": {
                        lexer.expectSymbol("binary content start", new char[]{'('});
                        PrettyToken binary = lexer.readBinary(')');
                        if (binary == null) {
                            return Binary.empty();
                        }
                        try {
                            return Binary.fromHexString((String)binary.toString().replaceAll("[\\s\\n]*", ""));
                        }
                        catch (IllegalArgumentException e) {
                            throw lexer.failure(binary, e.getMessage(), new Object[0]).initCause((Throwable)e);
                        }
                    }
                }
                throw new PrettyException(token, "Unrecognized binary format " + (Object)((Object)token), new Object[0]).setLine(token.line());
            }
            case ENUM: {
                PBuilder b = ((PEnumDescriptor)descriptor).builder();
                ((PEnumBuilder)b).setByName(token.toString());
                if (this.strict && !((PEnumBuilder)b).valid()) {
                    throw new PrettyException(token, "No such " + descriptor.getQualifiedName() + " value " + (Object)((Object)token), new Object[0]).setLine(token.line());
                }
                return b.build();
            }
            case MESSAGE: {
                if (!token.isSymbol('{')) {
                    throw new PrettyException(token, "Expected message start, but got '%s'", new Object[]{token}).setLine(token.line());
                }
                return this.readMessage(lexer, (PMessageDescriptor)descriptor, false);
            }
            case MAP: {
                if (!token.isSymbol('{')) {
                    throw new PrettyException(token, "Expected map start, but got '%s'", new Object[]{token}).setLine(token.line());
                }
                PMap pMap = (PMap)descriptor;
                PDescriptor kDesc = pMap.keyDescriptor();
                PDescriptor iDesc = pMap.itemDescriptor();
                PBuilder builder = pMap.builder(10);
                token = (PrettyToken)lexer.expect("list end or value");
                while (!token.isSymbol('}')) {
                    Object key = this.readFieldValue(lexer, token, kDesc);
                    lexer.expectSymbol("map kv sep", new char[]{':'});
                    Object value = this.readFieldValue(lexer, (PrettyToken)lexer.expect("map value"), iDesc);
                    builder.put(key, value);
                    token = (PrettyToken)lexer.expect("map sep, end or value");
                    if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
                    token = (PrettyToken)lexer.expect("map end or value");
                }
                return builder.build();
            }
            case LIST: {
                if (!token.isSymbol('[')) {
                    throw new PrettyException(token, "Expected list start, but got '%s'", new Object[]{token}).setLine(token.line());
                }
                PList pList = (PList)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PBuilder builder = pList.builder(10);
                token = (PrettyToken)lexer.expect("list end or value");
                while (!token.isSymbol(']')) {
                    builder.add(this.readFieldValue(lexer, token, iDesc));
                    token = (PrettyToken)lexer.expect("list sep, end or value");
                    if (!token.isSymbol(',')) continue;
                    token = (PrettyToken)lexer.expect("list end or value");
                }
                return builder.build();
            }
            case SET: {
                if (!token.isSymbol('[')) {
                    throw new PrettyException(token, "Expected set start, but got '%s'", new Object[]{token}).setLine(token.line());
                }
                PSet pList = (PSet)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PBuilder builder = pList.builder(10);
                token = (PrettyToken)lexer.expect("set end or value");
                while (!token.isSymbol(']')) {
                    builder.add(this.readFieldValue(lexer, token, iDesc));
                    token = (PrettyToken)lexer.expect("set sep, end or value");
                    if (!token.isSymbol(',')) continue;
                    token = (PrettyToken)lexer.expect("set end or value");
                }
                return builder.build();
            }
        }
        throw new IllegalStateException("Unhandled field type: " + (Object)((Object)descriptor.getType()));
    }

    @Override
    public boolean binaryProtocol() {
        return false;
    }

    @Override
    public void verifyEndOfContent(@Nonnull InputStream input) throws IOException {
        try {
            PrettyLexer tokenizer = new PrettyLexer(input);
            PrettyToken next = (PrettyToken)tokenizer.next();
            if (next != null) {
                throw new PrettyException(next, "More content after end: " + (Object)((Object)next), new Object[0]);
            }
        }
        catch (LexerException e) {
            throw new PrettyException(e, "More content after end: " + e.getMessage(), new Object[0]);
        }
        finally {
            input.close();
        }
    }

    @Override
    @Nonnull
    public String mediaType() {
        return MEDIA_TYPE;
    }

    private void appendMessage(IndentedPrintWriter builder, PMessageOrBuilder<?> message, boolean encloseParams) {
        PDescriptor type = message.descriptor();
        boolean empty = true;
        if (encloseParams) {
            builder.append('(');
        } else {
            builder.append('{');
        }
        builder.begin();
        if (message instanceof PUnion) {
            if (((PUnion)message).unionFieldIsSet()) {
                PField field = ((PUnion)message).unionField();
                Object o = message.get(field.getId());
                builder.appendln().append((CharSequence)field.getName()).append((CharSequence)this.space).append('=').append((CharSequence)this.space);
                this.appendTypedValue(builder, field.getDescriptor(), o);
                empty = false;
            }
        } else {
            boolean first = true;
            for (PField field : ((PMessageDescriptor)type).getFields()) {
                if (!message.has(field.getId())) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append((CharSequence)this.entrySep);
                }
                Object o = message.get(field.getId());
                builder.appendln().append((CharSequence)field.getName()).append((CharSequence)this.space).append('=').append((CharSequence)this.space);
                this.appendTypedValue(builder, field.getDescriptor(), o);
                empty = false;
            }
        }
        builder.end();
        if (!empty) {
            builder.appendln();
        }
        if (encloseParams) {
            builder.append(')');
        } else {
            builder.append('}');
        }
    }

    private void appendTypedValue(IndentedPrintWriter writer, PDescriptor descriptor, Object o) {
        switch (descriptor.getType()) {
            case LIST: 
            case SET: {
                PContainer containerType = (PContainer)descriptor;
                PDescriptor itemType = containerType.itemDescriptor();
                Collection collection = (Collection)o;
                if (collection.isEmpty()) {
                    writer.append('[').append(']');
                    break;
                }
                PPrimitive primitive = PPrimitive.findByName(itemType.getName());
                if (primitive != null && primitive != PPrimitive.STRING && primitive != PPrimitive.BINARY && collection.size() <= 10) {
                    writer.append('[');
                    boolean first = true;
                    for (Object i : collection) {
                        if (first) {
                            first = false;
                        } else {
                            writer.append(',').append((CharSequence)this.space);
                        }
                        this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                    }
                    writer.append(']');
                    break;
                }
                writer.append('[').begin();
                boolean first = true;
                for (Object i : collection) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',');
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                }
                writer.end().appendln(']');
                break;
            }
            case MAP: {
                PMap mapType = (PMap)descriptor;
                Map map = (Map)o;
                if (map.isEmpty()) {
                    writer.append('{').append('}');
                    break;
                }
                writer.append('{').begin();
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append((CharSequence)this.entrySep);
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, mapType.keyDescriptor(), entry.getKey());
                    writer.append(':').append((CharSequence)this.space);
                    this.appendTypedValue(writer, mapType.itemDescriptor(), entry.getValue());
                }
                writer.end().appendln('}');
                break;
            }
            case VOID: {
                writer.print(true);
                break;
            }
            case MESSAGE: {
                PMessage message = (PMessage)o;
                this.appendMessage(writer, message, false);
                break;
            }
            default: {
                this.appendPrimitive(writer, o);
            }
        }
    }

    private void appendPrimitive(IndentedPrintWriter writer, Object o) {
        if (o instanceof PEnumValue) {
            writer.print(((PEnumValue)o).asString());
        } else if (o instanceof CharSequence) {
            writer.print('\"');
            writer.print(Strings.escape((CharSequence)((CharSequence)o)));
            writer.print('\"');
        } else if (o instanceof Binary) {
            Binary b = (Binary)o;
            writer.append((CharSequence)"b64").append('(').append((CharSequence)b.toBase64()).append(')');
        } else if (o instanceof Boolean) {
            writer.print(((Boolean)o).booleanValue());
        } else if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long) {
            writer.print(o.toString());
        } else if (o instanceof Double) {
            Double d = (Double)o;
            if (d.equals(d.longValue())) {
                writer.print(d.longValue());
            } else {
                writer.print(d.doubleValue());
            }
        } else {
            throw new IllegalArgumentException("Unknown primitive type class " + o.getClass().getSimpleName());
        }
    }

    private void consumeValue(PrettyLexer lexer, PrettyToken token) throws IOException {
        if (token.isSymbol('{')) {
            token = (PrettyToken)lexer.expect("map or message first entry");
            if (!token.isSymbol('}')) {
                boolean idKey = token.isIdentifier();
                this.consumeValue(lexer, token);
                if (((PrettyToken)lexer.expectSymbol("map", new char[]{':', '='})).isSymbol('=')) {
                    if (!idKey) {
                        throw lexer.failure(token, "Invalid field name token", new Object[0]);
                    }
                    this.consumeValue(lexer, (PrettyToken)lexer.expect("message field value"));
                    token = this.nextNotLineSep(lexer);
                    while (!token.isSymbol('}')) {
                        if (!token.isIdentifier()) {
                            throw lexer.failure(token, "Invalid field name token", new Object[0]);
                        }
                        lexer.expectSymbol("message field value sep", new char[]{'='});
                        this.consumeValue(lexer, (PrettyToken)lexer.expect("message field value"));
                        token = this.nextNotLineSep(lexer);
                    }
                } else {
                    this.consumeValue(lexer, (PrettyToken)lexer.expect("map entry value"));
                    token = this.nextNotLineSep(lexer);
                    while (!token.isSymbol('}')) {
                        this.consumeValue(lexer, token);
                        lexer.expectSymbol("message field value sep", new char[]{':'});
                        this.consumeValue(lexer, (PrettyToken)lexer.expect("message field value"));
                        token = this.nextNotLineSep(lexer);
                    }
                }
                if (!token.isSymbol('=')) {
                    while (!token.isSymbol('}')) {
                        this.consumeValue(lexer, token);
                        lexer.expectSymbol("key value sep.", new char[]{':'});
                        this.consumeValue(lexer, (PrettyToken)lexer.expect("map value"));
                        token = this.nextNotLineSep(lexer);
                    }
                } else {
                    while (!token.isSymbol('}')) {
                        if (!token.isIdentifier()) {
                            throw new PrettyException(token, "Invalid field name: " + (Object)((Object)token), new Object[0]).setLine(token.line());
                        }
                        lexer.expectSymbol("field value sep.", new char[]{'='});
                        this.consumeValue(lexer, (PrettyToken)lexer.expect(""));
                        token = this.nextNotLineSep(lexer);
                    }
                }
            }
        } else if (token.isSymbol('[')) {
            token = (PrettyToken)lexer.expect("");
            while (!token.isSymbol(']')) {
                this.consumeValue(lexer, token);
                if (!((PrettyToken)lexer.expectSymbol("list separator or end", new char[]{',', ']'})).isSymbol(']')) {
                    token = (PrettyToken)lexer.expect("list value or end");
                    continue;
                }
                break;
            }
        } else if (token.toString().equals("hex") || token.toString().equals("b64")) {
            lexer.expectSymbol("binary body start", new char[]{'('});
            lexer.readBinary(')');
        } else if (!(token.isReal() || token.isInteger() || token.isStringLiteral() || token.isIdentifier())) {
            throw new PrettyException(token, "Unknown value token '%s'", new Object[]{token}).setLine(token.line());
        }
    }

    private PrettyToken nextNotLineSep(PrettyLexer lexer) throws IOException {
        if (((PrettyToken)lexer.peek("message field or end")).isSymbol(',')) {
            lexer.next();
        }
        return (PrettyToken)lexer.expect("message field or end");
    }
}

