/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer.binary;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

public class BinaryFormatUtils {
    public static <Message extends PMessage<Message>> Message readMessage(BigEndianBinaryReader input, PMessageDescriptor<Message> descriptor, boolean strict) throws IOException {
        PBuilder builder = descriptor.builder();
        if (builder instanceof BinaryReader) {
            ((BinaryReader)((Object)builder)).readBinary(input, strict);
        } else {
            FieldInfo fieldInfo = BinaryFormatUtils.readFieldInfo(input);
            while (fieldInfo != null) {
                PField<Message> field = descriptor.findFieldById(fieldInfo.getId());
                if (field != null) {
                    Object value = BinaryFormatUtils.readFieldValue(input, fieldInfo, field.getDescriptor(), strict);
                    ((PMessageBuilder)builder).set(field.getId(), value);
                } else {
                    BinaryFormatUtils.readFieldValue(input, fieldInfo, null, false);
                }
                fieldInfo = BinaryFormatUtils.readFieldInfo(input);
            }
            if (strict) {
                try {
                    ((PMessageBuilder)builder).validate();
                }
                catch (IllegalStateException e) {
                    throw new SerializerException(e, e.getMessage(), new Object[0]);
                }
            }
        }
        return (Message)((PMessage)builder.build());
    }

    public static void consumeMessage(BigEndianBinaryReader in) throws IOException {
        FieldInfo fieldInfo;
        while ((fieldInfo = BinaryFormatUtils.readFieldInfo(in)) != null) {
            BinaryFormatUtils.readFieldValue(in, fieldInfo, null, false);
        }
    }

    private static FieldInfo readFieldInfo(BigEndianBinaryReader in) throws IOException {
        byte type = in.expectByte();
        if (type == 0) {
            return null;
        }
        return new FieldInfo(in.expectShort(), type);
    }

    public static <T> T readFieldValue(BigEndianBinaryReader in, FieldInfo fieldInfo, PDescriptor fieldType, boolean strict) throws IOException {
        if (fieldType != null && BinaryType.forType(fieldType.getType()) != fieldInfo.type) {
            throw new SerializerException("Wrong field type for id=%d: expected %s, got %s", fieldInfo.id, BinaryType.asString(BinaryType.forType(fieldType.getType())), BinaryType.asString(fieldInfo.getType()));
        }
        switch (fieldInfo.type) {
            case 1: {
                return (T)Boolean.TRUE;
            }
            case 2: {
                return (T)Boolean.valueOf(in.expectByte() != 0);
            }
            case 3: {
                return (T)Byte.valueOf(in.expectByte());
            }
            case 6: {
                return (T)Short.valueOf(in.expectShort());
            }
            case 8: {
                int val = in.expectInt();
                if (fieldType instanceof PEnumDescriptor) {
                    PBuilder builder = ((PEnumDescriptor)fieldType).builder();
                    ((PEnumBuilder)builder).setById(val);
                    return builder.build();
                }
                return (T)Integer.valueOf(val);
            }
            case 10: {
                return (T)Long.valueOf(in.expectLong());
            }
            case 4: {
                return (T)Double.valueOf(in.expectDouble());
            }
            case 11: {
                int len = in.expectUInt32();
                byte[] data = in.expectBytes(len);
                if (fieldType != null && fieldType.getType() == PType.STRING) {
                    return (T)new String(data, StandardCharsets.UTF_8);
                }
                return (T)Binary.wrap((byte[])data);
            }
            case 12: {
                if (fieldType == null) {
                    BinaryFormatUtils.consumeMessage(in);
                    return null;
                }
                return (T)BinaryFormatUtils.readMessage(in, (PMessageDescriptor)fieldType, strict);
            }
            case 13: {
                PBuilder<Map<T, T>> out;
                byte keyT = in.expectByte();
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor keyType = null;
                PDescriptor valueType = null;
                if (fieldType != null) {
                    PMap mapType = (PMap)fieldType;
                    keyType = mapType.keyDescriptor();
                    valueType = mapType.itemDescriptor();
                    out = mapType.builder(size);
                } else {
                    out = new PMap.DefaultBuilder(size);
                }
                FieldInfo keyInfo = new FieldInfo(1, keyT);
                FieldInfo itemInfo = new FieldInfo(2, itemT);
                for (int i = 0; i < size; ++i) {
                    T key = BinaryFormatUtils.readFieldValue(in, keyInfo, keyType, strict);
                    T value = BinaryFormatUtils.readFieldValue(in, itemInfo, valueType, strict);
                    if (key != null && value != null) {
                        out.put(key, value);
                        continue;
                    }
                    if (!strict) continue;
                    if (key == null) {
                        throw new SerializerException("Null key in map", new Object[0]);
                    }
                    throw new SerializerException("Null value in map", new Object[0]);
                }
                return (T)out.build();
            }
            case 14: {
                PBuilder<Set<T>> out;
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor entryType = null;
                if (fieldType != null) {
                    PSet setType = (PSet)fieldType;
                    entryType = setType.itemDescriptor();
                    out = setType.builder(size);
                } else {
                    out = new PSet.DefaultBuilder(size);
                }
                FieldInfo itemInfo = new FieldInfo(0, itemT);
                for (int i = 0; i < size; ++i) {
                    T value = BinaryFormatUtils.readFieldValue(in, itemInfo, entryType, strict);
                    if (value != null) {
                        out.add(value);
                        continue;
                    }
                    if (!strict) continue;
                    throw new SerializerException("Null value in set", new Object[0]);
                }
                return (T)out.build();
            }
            case 15: {
                PBuilder<List<T>> out;
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor entryType = null;
                if (fieldType != null) {
                    PList listType = (PList)fieldType;
                    entryType = listType.itemDescriptor();
                    out = listType.builder(size);
                } else {
                    out = new PList.DefaultBuilder(size);
                }
                FieldInfo itemInfo = new FieldInfo(0, itemT);
                for (int i = 0; i < size; ++i) {
                    T value = BinaryFormatUtils.readFieldValue(in, itemInfo, entryType, strict);
                    if (value != null) {
                        out.add(value);
                        continue;
                    }
                    if (!strict) continue;
                    throw new SerializerException("Null value in list", new Object[0]);
                }
                return (T)out.build();
            }
        }
        throw new SerializerException("unknown data type: " + fieldInfo.getType(), new Object[0]);
    }

    public static <Message extends PMessage<Message>> int writeMessage(BigEndianBinaryWriter writer, PMessageOrBuilder<Message> message) throws IOException {
        if (message instanceof BinaryWriter) {
            return ((BinaryWriter)((Object)message)).writeBinary(writer);
        }
        int len = 0;
        if (message instanceof PUnion) {
            if (((PUnion)message).unionFieldIsSet()) {
                PField field = ((PUnion)message).unionField();
                len += BinaryFormatUtils.writeFieldSpec(writer, BinaryType.forType(field.getDescriptor().getType()), field.getId());
                len += BinaryFormatUtils.writeFieldValue(writer, message.get(field.getId()), field.getDescriptor());
            }
        } else {
            for (PField field : ((PMessageDescriptor)message.descriptor()).getFields()) {
                if (!message.has(field.getId())) continue;
                len += BinaryFormatUtils.writeFieldSpec(writer, BinaryType.forType(field.getDescriptor().getType()), field.getId());
                len += BinaryFormatUtils.writeFieldValue(writer, message.get(field.getId()), field.getDescriptor());
            }
        }
        return len += writer.writeUInt8(0);
    }

    private static int writeFieldSpec(BigEndianBinaryWriter out, byte type, int key) throws IOException {
        out.writeByte(type);
        out.writeShort((short)key);
        return 3;
    }

    private static int writeFieldValue(BigEndianBinaryWriter out, Object value, PDescriptor descriptor) throws IOException {
        switch (descriptor.getType()) {
            case VOID: {
                return 0;
            }
            case BOOL: {
                return out.writeByte((Boolean)value != false ? (byte)1 : 0);
            }
            case BYTE: {
                return out.writeByte(((Byte)value).byteValue());
            }
            case I16: {
                return out.writeShort(((Short)value).shortValue());
            }
            case I32: {
                return out.writeInt(((Integer)value).intValue());
            }
            case I64: {
                return out.writeLong(((Long)value).longValue());
            }
            case DOUBLE: {
                return out.writeDouble(((Double)value).doubleValue());
            }
            case BINARY: {
                Binary binary = (Binary)value;
                int len = out.writeUInt32(binary.length());
                return len + out.writeBinary(binary);
            }
            case STRING: {
                Binary binary = Binary.wrap((byte[])value.toString().getBytes(StandardCharsets.UTF_8));
                int len = out.writeUInt32(binary.length());
                return len + out.writeBinary(binary);
            }
            case ENUM: {
                return out.writeInt(((PEnumValue)value).asInteger());
            }
            case MAP: {
                Map map = (Map)value;
                PMap pMap = (PMap)descriptor;
                int len = out.writeByte(BinaryType.forType(pMap.keyDescriptor().getType()));
                len += out.writeByte(BinaryType.forType(pMap.itemDescriptor().getType()));
                len += out.writeUInt32(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    len += BinaryFormatUtils.writeFieldValue(out, entry.getKey(), pMap.keyDescriptor());
                    len += BinaryFormatUtils.writeFieldValue(out, entry.getValue(), pMap.itemDescriptor());
                }
                return len;
            }
            case SET: 
            case LIST: {
                Collection coll = (Collection)value;
                PContainer pSet = (PContainer)descriptor;
                int len = out.writeByte(BinaryType.forType(pSet.itemDescriptor().getType()));
                len += out.writeUInt32(coll.size());
                for (Object item : coll) {
                    len += BinaryFormatUtils.writeFieldValue(out, item, pSet.itemDescriptor());
                }
                return len;
            }
            case MESSAGE: {
                int size = BinaryFormatUtils.writeMessage(out, (PMessage)value);
                return size;
            }
        }
        throw new SerializerException("Unhandled field type: " + (Object)((Object)descriptor.getType()), new Object[0]);
    }

    public static class FieldInfo {
        private final int id;
        private final byte type;

        public FieldInfo(int id, byte type) {
            this.id = id;
            this.type = type;
        }

        public String toString() {
            return String.format(Locale.US, "field(%d: %s)", this.id, BinaryType.asString(this.type));
        }

        public int getId() {
            return this.id;
        }

        public byte getType() {
            return this.type;
        }
    }
}

