/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.types;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.types.TypeReference;
import net.morimekta.providence.types.WritableTypeRegistry;
import net.morimekta.util.collect.UnmodifiableList;

public class SimpleTypeRegistry
extends WritableTypeRegistry {
    private final Set<String> knownPrograms = new HashSet<String>();
    private final Map<TypeReference, PDeclaredDescriptor<?>> declaredTypes = new LinkedHashMap();
    private final Map<TypeReference, PService> services = new LinkedHashMap<TypeReference, PService>();
    private final Map<TypeReference, TypeReference> typedefs = new LinkedHashMap<TypeReference, TypeReference>();
    private final Map<TypeReference, PValueProvider> constants = new LinkedHashMap<TypeReference, PValueProvider>();

    @Override
    public boolean isKnownProgram(@Nonnull String programName) {
        return this.knownPrograms.contains(programName);
    }

    @Override
    @Nonnull
    public Optional<TypeReference> getTypedef(@Nonnull TypeReference reference) {
        return Optional.ofNullable(this.typedefs.get(reference));
    }

    @Override
    public List<PDeclaredDescriptor<?>> getDeclaredTypes() {
        return UnmodifiableList.copyOf(this.declaredTypes.values());
    }

    @Override
    @Nonnull
    public Optional<PDeclaredDescriptor<?>> getDeclaredType(@Nonnull TypeReference reference) {
        return Optional.ofNullable(this.declaredTypes.get(reference));
    }

    @Override
    @Nonnull
    public Optional<PService> getService(@Nonnull TypeReference reference) {
        return Optional.ofNullable(this.services.get(reference));
    }

    @Override
    @Nonnull
    public <T> Optional<T> getConstantValue(@Nonnull TypeReference reference) {
        return Optional.ofNullable(this.constants.get(reference)).map(PValueProvider::get);
    }

    @Override
    public void registerTypedef(@Nonnull TypeReference reference, @Nonnull TypeReference target) {
        if (this.typedefs.containsKey(reference)) {
            return;
        }
        if (reference.isNativeType()) {
            throw new IllegalArgumentException("Registering typedef with native type name '" + reference + "'");
        }
        if (reference.equals(this.finalTypeReference(target))) {
            throw new IllegalArgumentException("Typedef defining back to itself: " + reference);
        }
        this.knownPrograms.add(reference.programName);
        this.typedefs.put(reference, target);
    }

    @Override
    public void registerConstant(@Nonnull TypeReference reference, @Nonnull PValueProvider value) {
        if (this.constants.containsKey(reference)) {
            return;
        }
        if (reference.isNativeType()) {
            throw new IllegalArgumentException("Registering const with native type name '" + reference + "'");
        }
        this.knownPrograms.add(reference.programName);
        this.constants.put(reference, value);
    }

    @Override
    public void registerService(@Nonnull PService service) {
        TypeReference reference = TypeReference.ref(service.getProgramName(), service.getName());
        if (this.services.containsKey(reference)) {
            return;
        }
        this.knownPrograms.add(service.getProgramName());
        this.services.put(reference, service);
        for (PServiceMethod pServiceMethod : service.getMethods()) {
            PUnionDescriptor returnType = pServiceMethod.getResponseType();
            if (returnType != null) {
                this.registerType(returnType);
            }
            PStructDescriptor requestType = pServiceMethod.getRequestType();
            this.registerType(requestType);
        }
    }

    @Override
    public <T> void registerType(PDeclaredDescriptor<T> declaredType) {
        TypeReference reference = TypeReference.ref(declaredType.getProgramName(), declaredType.getName());
        if (this.declaredTypes.containsKey(reference)) {
            return;
        }
        this.knownPrograms.add(reference.programName);
        this.declaredTypes.put(reference, declaredType);
        if (declaredType instanceof PMessageDescriptor) {
            PMessageDescriptor descriptor = (PMessageDescriptor)declaredType;
            for (PField field : descriptor.getFields()) {
                if (!(field.getDescriptor() instanceof PMessageDescriptor) && !(field.getDescriptor() instanceof PEnumDescriptor)) continue;
                this.registerType((PDeclaredDescriptor)field.getDescriptor());
            }
        }
    }
}

