/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PInterfaceDescriptor;

public abstract class PMessageDescriptor<T extends PMessage<T>>
extends PDeclaredDescriptor<T> {
    private final Supplier<PMessageBuilder<T>> builderSupplier;
    private final boolean simple;

    public PMessageDescriptor(String programName, String name, Supplier<PMessageBuilder<T>> builderSupplier, boolean simple) {
        super(programName, name);
        this.builderSupplier = builderSupplier;
        this.simple = simple;
    }

    @Nonnull
    public abstract PField<T>[] getFields();

    @Nullable
    public abstract PField<T> findFieldByName(String var1);

    @Nullable
    public abstract PField<T> findFieldById(int var1);

    @Nonnull
    public PField<T> fieldForName(String name) {
        PField<T> field = this.findFieldByName(name);
        if (field == null) {
            throw new IllegalArgumentException("No field \"" + name + "\" in " + this.getQualifiedName());
        }
        return field;
    }

    @Nullable
    public PInterfaceDescriptor<?> getImplementing() {
        return null;
    }

    @Nonnull
    public PField<T> fieldForId(int id) {
        PField<T> field = this.findFieldById(id);
        if (field == null) {
            throw new IllegalArgumentException("No field key " + id + " in " + this.getQualifiedName());
        }
        return field;
    }

    @Nonnull
    public abstract PMessageVariant getVariant();

    public boolean isSimple() {
        return this.simple;
    }

    @Override
    @Nonnull
    public PType getType() {
        return PType.MESSAGE;
    }

    @Override
    @Nonnull
    public PMessageBuilder<T> builder() {
        return this.builderSupplier.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        PMessageDescriptor other = (PMessageDescriptor)o;
        if (!this.getQualifiedName().equals(other.getQualifiedName()) || !this.getVariant().equals((Object)other.getVariant()) || this.getFields().length != other.getFields().length) {
            return false;
        }
        for (PField<T> field : this.getFields()) {
            if (field.equals(other.findFieldById(field.getId()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = Objects.hash(new Object[]{this.getClass(), this.getQualifiedName(), this.getVariant()});
        for (PField<T> field : this.getFields()) {
            hash += Objects.hash(hash *= 28547, field.hashCode());
        }
        return hash;
    }

    protected Supplier<PMessageBuilder<T>> getBuilderSupplier() {
        return this.builderSupplier;
    }
}

