/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.util.Binary;

public class MessageUtil {
    private static final Pattern UNSIGNED = Pattern.compile("(0|[1-9][0-9]*)");
    private static final Pattern HEX = Pattern.compile("0x[0-9a-fA-F]+");

    public static <M extends PMessage<M>, B extends PMessageBuilder<M>> B getTargetModifications(PMessageOrBuilder<M> source, PMessageOrBuilder<M> target) {
        PMessageBuilder<Object> builder = target instanceof PMessageBuilder ? ((PMessage)((PMessageBuilder)target).build()).mutate() : ((PMessage)target).mutate();
        for (PField field : ((PMessageDescriptor)source.descriptor()).getFields()) {
            if (source.has(field) == target.has(field) && Objects.equals(source.get(field), target.get(field))) continue;
            builder.set(field, target.get(field));
        }
        return (B)builder;
    }

    @Nonnull
    public static PField[] keyPathToFields(@Nonnull PMessageDescriptor descriptor, @Nonnull String key) {
        ArrayList fields = new ArrayList();
        String[] parts = key.split("\\.", 127);
        for (int i = 0; i < parts.length - 1; ++i) {
            String name = parts[i];
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Empty field name in '" + key + "'");
            }
            PField field = descriptor.findFieldByName(name);
            if (field == null) {
                throw new IllegalArgumentException("Message " + descriptor.getQualifiedName() + " has no field named " + name);
            }
            if (field.getType() != PType.MESSAGE) {
                throw new IllegalArgumentException("Field '" + name + "' is not of message type in " + descriptor.getQualifiedName());
            }
            fields.add(field);
            descriptor = (PMessageDescriptor)field.getDescriptor();
        }
        String name = parts[parts.length - 1];
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Empty field name in '" + key + "'");
        }
        PField field = descriptor.findFieldByName(name);
        if (field == null) {
            throw new IllegalArgumentException("Message " + descriptor.getQualifiedName() + " has no field named " + name);
        }
        fields.add(field);
        return fields.toArray(new PField[0]);
    }

    @Nonnull
    public static <T> Optional<T> getInMessage(@Nullable PMessageOrBuilder message, PField ... fields) {
        if (fields.length == 0) {
            throw new IllegalArgumentException("No fields arguments");
        }
        PField field = fields[0];
        if (fields.length > 1) {
            if (field.getType() != PType.MESSAGE) {
                throw new IllegalArgumentException("Intermediate field " + field.getName() + " is not a message");
            }
            return MessageUtil.getInMessage(message == null ? (PMessage)field.getDefaultValue() : (PMessageOrBuilder)Optional.ofNullable((PMessage)message.get(field.getId())).orElse((PMessage)field.getDefaultValue()), Arrays.copyOfRange(fields, 1, fields.length));
        }
        return Optional.ofNullable(message == null ? field.getDefaultValue() : Optional.ofNullable(message.get(field.getId())).orElseGet(() -> field.getDefaultValue()));
    }

    @Nonnull
    public static <T> Optional<T> optionalInMessage(@Nullable PMessageOrBuilder message, PField ... fields) {
        if (fields.length == 0) {
            throw new IllegalArgumentException("No fields arguments");
        }
        if (message == null) {
            return Optional.empty();
        }
        PField field = fields[0];
        if (!message.has(field.getId())) {
            return Optional.empty();
        }
        if (fields.length > 1) {
            if (field.getType() != PType.MESSAGE) {
                throw new IllegalArgumentException("Intermediate field " + field.getName() + " is not a message");
            }
            return MessageUtil.optionalInMessage((PMessage)message.get(field), Arrays.copyOfRange(fields, 1, fields.length));
        }
        return Optional.of(message.get(field.getId()));
    }

    @Nonnull
    public static Map<String, Object> toMap(@Nonnull PMessageOrBuilder<?> message) {
        TreeMap<String, Object> out = new TreeMap<String, Object>();
        block5: for (PField field : ((PMessageDescriptor)message.descriptor()).getFields()) {
            if (!message.has(field)) continue;
            switch (field.getType()) {
                case MESSAGE: {
                    out.put(field.getName(), MessageUtil.toMap((PMessageOrBuilder)message.get(field)));
                    continue block5;
                }
                case SET: 
                case LIST: {
                    out.put(field.getName(), MessageUtil.toCollectionInternal((Collection)message.get(field)));
                    continue block5;
                }
                case MAP: {
                    out.put(field.getName(), MessageUtil.toMapInternal((Map)message.get(field)));
                    continue block5;
                }
                default: {
                    out.put(field.getName(), message.get(field));
                }
            }
        }
        return out;
    }

    public static Optional<Object> coerce(@Nonnull PDescriptor valueType, Object value) {
        return MessageUtil.coerceInternal(valueType, value, false);
    }

    public static Optional<Object> coerceStrict(@Nonnull PDescriptor valueType, Object value) {
        return MessageUtil.coerceInternal(valueType, value, true);
    }

    private static Collection<Object> toCollectionInternal(Collection collection) {
        AbstractCollection out = collection instanceof SortedSet ? new TreeSet(((SortedSet)collection).comparator()) : (collection instanceof Set ? new HashSet() : new ArrayList());
        for (Object item : collection) {
            if (item instanceof PMessageOrBuilder) {
                out.add(MessageUtil.toMap((PMessageOrBuilder)item));
                continue;
            }
            if (item instanceof Collection) {
                out.add(MessageUtil.toCollectionInternal((Collection)item));
                continue;
            }
            if (item instanceof Map) {
                out.add(MessageUtil.toMapInternal((Map)item));
                continue;
            }
            out.add(item);
        }
        return out;
    }

    static Map<Object, Object> toMapInternal(Map<Object, Object> collection) {
        AbstractMap out = collection instanceof SortedMap ? new TreeMap(((SortedMap)collection).comparator()) : new HashMap();
        for (Map.Entry<Object, Object> item : collection.entrySet()) {
            Object value = item.getValue() instanceof PMessageOrBuilder ? MessageUtil.toMap((PMessageOrBuilder)item.getValue()) : (item.getValue() instanceof Collection ? MessageUtil.toCollectionInternal((Collection)item.getValue()) : (item.getValue() instanceof Map ? MessageUtil.toMapInternal((Map)item.getValue()) : item.getValue()));
            out.put((Object)item.getKey(), (Object)value);
        }
        return out;
    }

    private static Optional<Object> coerceInternal(@Nonnull PDescriptor valueType, Object val, boolean strict) {
        if (val == null) {
            return Optional.empty();
        }
        switch (valueType.getType()) {
            case VOID: {
                if (val == Boolean.TRUE) {
                    return Optional.of(Boolean.TRUE);
                }
                if (val != Boolean.FALSE) break;
                throw new IllegalArgumentException("Invalid void value " + val.toString());
            }
            case BOOL: {
                if (val instanceof Boolean) {
                    return Optional.of(val);
                }
                if (val instanceof Number && !(val instanceof Float) && !(val instanceof Double)) {
                    return Optional.of(((Number)val).longValue() != 0L);
                }
                if (val instanceof PEnumValue) {
                    return Optional.of(((PEnumValue)val).asInteger() != 0);
                }
                if (strict || !(val instanceof CharSequence)) break;
                switch (val.toString().toLowerCase(Locale.US)) {
                    case "true": 
                    case "t": 
                    case "yes": 
                    case "y": 
                    case "1": {
                        return Optional.of(Boolean.TRUE);
                    }
                    case "false": 
                    case "f": 
                    case "no": 
                    case "n": 
                    case "0": {
                        return Optional.of(Boolean.FALSE);
                    }
                }
                throw new IllegalArgumentException("Unknown boolean value for string '" + val + "'");
            }
            case BYTE: {
                if (val instanceof Number) {
                    return Optional.of((byte)MessageUtil.asInteger(valueType, (Number)val, -128, 127));
                }
                if (val instanceof Boolean) {
                    return Optional.of((Boolean)val != false ? (byte)1 : 0);
                }
                if (val instanceof PEnumValue) {
                    return Optional.of((byte)MessageUtil.asInteger(valueType, ((PEnumValue)val).asInteger(), -128, 127));
                }
                if (strict || !(val instanceof CharSequence)) break;
                try {
                    CharSequence cs = (CharSequence)val;
                    if (HEX.matcher(cs).matches()) {
                        return Optional.of(Byte.parseByte(cs.subSequence(2, cs.length()).toString(), 16));
                    }
                    return Optional.of(Byte.parseByte(val.toString()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid string value '" + val + "' for type byte", e);
                }
            }
            case I16: {
                if (val instanceof Number) {
                    return Optional.of((short)MessageUtil.asInteger(valueType, (Number)val, Short.MIN_VALUE, Short.MAX_VALUE));
                }
                if (val instanceof Boolean) {
                    return Optional.of((Boolean)val != false ? (short)1 : 0);
                }
                if (val instanceof PEnumValue) {
                    return Optional.of((short)MessageUtil.asInteger(valueType, ((PEnumValue)val).asInteger(), Short.MIN_VALUE, Short.MAX_VALUE));
                }
                if (strict || !(val instanceof CharSequence)) break;
                try {
                    CharSequence cs = (CharSequence)val;
                    if (HEX.matcher(cs).matches()) {
                        return Optional.of(Short.parseShort(cs.subSequence(2, cs.length()).toString(), 16));
                    }
                    return Optional.of(Short.parseShort(val.toString()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid string value '" + val + "' for type i16", e);
                }
            }
            case I32: {
                if (val instanceof Number) {
                    return Optional.of(MessageUtil.asInteger(valueType, (Number)val, Integer.MIN_VALUE, Integer.MAX_VALUE));
                }
                if (val instanceof Boolean) {
                    return Optional.of((Boolean)val != false ? 1 : 0);
                }
                if (val instanceof PEnumValue) {
                    return Optional.of(((PEnumValue)val).asInteger());
                }
                if (strict || !(val instanceof CharSequence)) break;
                try {
                    CharSequence cs = (CharSequence)val;
                    if (HEX.matcher(cs).matches()) {
                        return Optional.of(Integer.parseInt(cs.subSequence(2, cs.length()).toString(), 16));
                    }
                    return Optional.of(Integer.parseInt(val.toString()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid string value '" + val + "' for type i32", e);
                }
            }
            case I64: {
                if (val instanceof Float || val instanceof Double) {
                    long l = ((Number)val).longValue();
                    if ((double)l != ((Number)val).doubleValue()) {
                        throw new IllegalArgumentException("Truncating long decimals from " + val.toString());
                    }
                    return Optional.of(l);
                }
                if (val instanceof Number) {
                    return Optional.of(((Number)val).longValue());
                }
                if (val instanceof Boolean) {
                    return Optional.of((Boolean)val != false ? 1L : 0L);
                }
                if (val instanceof PEnumValue) {
                    return Optional.of(Long.valueOf(((PEnumValue)val).asInteger()));
                }
                if (strict || !(val instanceof CharSequence)) break;
                try {
                    CharSequence cs = (CharSequence)val;
                    if (HEX.matcher(cs).matches()) {
                        return Optional.of(Long.parseLong(cs.subSequence(2, cs.length()).toString(), 16));
                    }
                    return Optional.of(Long.parseLong(val.toString()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid string value '" + val + "' for type i64", e);
                }
            }
            case DOUBLE: {
                if (val instanceof Number) {
                    return Optional.of(((Number)val).doubleValue());
                }
                if (strict || !(val instanceof PEnumValue)) break;
                return Optional.of(Double.valueOf(((PEnumValue)val).asInteger()));
            }
            case STRING: {
                if (val instanceof CharSequence) {
                    return Optional.of(val.toString());
                }
                if (strict) break;
                if (val instanceof PEnumValue) {
                    return Optional.of(((PEnumValue)val).asString());
                }
                return Optional.of(val.toString());
            }
            case BINARY: {
                if (val instanceof Binary) {
                    return Optional.of(val);
                }
                if (strict || !(val instanceof CharSequence)) break;
                return Optional.of(Binary.fromBase64((String)val.toString()));
            }
            case ENUM: {
                PEnumDescriptor ed = (PEnumDescriptor)valueType;
                if (val instanceof PEnumValue) {
                    Object verified = ((PEnumDescriptor)valueType).findById(((PEnumValue)val).asInteger());
                    if (val.equals(verified)) {
                        return Optional.of(verified);
                    }
                } else {
                    if (val instanceof Number && !(val instanceof Double) && !(val instanceof Float)) {
                        int i = ((Number)val).intValue();
                        Object ev = ed.findById(i);
                        if (ev != null) {
                            return Optional.of(ev);
                        }
                        throw new IllegalArgumentException("Unknown " + valueType.getQualifiedName() + " value for id " + val.toString());
                    }
                    if (val instanceof CharSequence) {
                        CharSequence cs = (CharSequence)val;
                        if (!strict && UNSIGNED.matcher(cs).matches()) {
                            int i = Integer.parseInt(val.toString());
                            Object ev = ed.findById(i);
                            if (ev != null) {
                                return Optional.of(ev);
                            }
                        } else if (!strict && HEX.matcher(cs).matches()) {
                            int i = Integer.parseInt(cs.subSequence(2, cs.length()).toString(), 16);
                            Object ev = ed.findById(i);
                            if (ev != null) {
                                return Optional.of(ev);
                            }
                        } else {
                            Object ev = ed.findByName(val.toString());
                            if (ev != null) {
                                return Optional.of(ev);
                            }
                        }
                        throw new IllegalArgumentException("Unknown " + valueType.getQualifiedName() + " value for string '" + val.toString() + "'");
                    }
                }
                throw new IllegalArgumentException("Invalid value type " + val.getClass() + " for enum " + valueType.toString());
            }
            case MESSAGE: {
                if (val instanceof PMessage) {
                    if (valueType.equals(((PMessage)val).descriptor())) {
                        return Optional.of(val);
                    }
                    throw new IllegalArgumentException("Unable to cast message type " + ((PMessage)val).descriptor().getQualifiedName() + " to " + valueType.getQualifiedName());
                }
                if (val instanceof PMessageBuilder) {
                    if (valueType.equals(((PMessageBuilder)val).descriptor())) {
                        return Optional.of(((PMessageBuilder)val).build());
                    }
                    throw new IllegalArgumentException("Unable to cast message type " + ((PMessageBuilder)val).descriptor().getQualifiedName() + " to " + valueType.getQualifiedName());
                }
                if (!strict && val instanceof Map) {
                    PMessageDescriptor md = (PMessageDescriptor)valueType;
                    PBuilder builder = md.builder();
                    for (Map.Entry entry : ((Map)val).entrySet()) {
                        if (!(entry.getKey() instanceof CharSequence)) {
                            throw new IllegalArgumentException("Invalid message map key: " + entry.getKey().toString());
                        }
                        PField field = md.findFieldByName(entry.getKey().toString());
                        if (field == null) {
                            throw new IllegalArgumentException("No such field " + entry.getKey() + " in " + md.getQualifiedName());
                        }
                        ((PMessageBuilder)builder).set(field.getId(), MessageUtil.coerceInternal(field.getDescriptor(), entry.getValue(), false).orElse(null));
                    }
                    return Optional.of(builder.build());
                }
                throw new IllegalArgumentException("Invalid value type " + val.getClass() + " for message " + valueType.toString());
            }
            case LIST: {
                if (val instanceof Collection) {
                    PList pl = (PList)valueType;
                    PBuilder builder = pl.builder(((Collection)val).size());
                    for (Object o : (Collection)val) {
                        Object value = MessageUtil.coerceInternal(pl.itemDescriptor(), o, strict).orElse(null);
                        if (value != null) {
                            builder.add(value);
                            continue;
                        }
                        if (!strict) continue;
                        throw new IllegalArgumentException("Null value in list");
                    }
                    return Optional.of(builder.build());
                }
                throw new IllegalArgumentException("Invalid value type " + val.getClass() + " for " + valueType.toString());
            }
            case MAP: {
                if (val instanceof Map) {
                    PMap pl = (PMap)valueType;
                    PBuilder builder = pl.builder(((Map)val).size());
                    for (Map.Entry entry : ((Map)val).entrySet()) {
                        Object key = MessageUtil.coerceInternal(pl.keyDescriptor(), entry.getKey(), strict).orElse(null);
                        Object value = MessageUtil.coerceInternal(pl.itemDescriptor(), entry.getValue(), strict).orElse(null);
                        if (key != null && value != null) {
                            builder.put(key, value);
                            continue;
                        }
                        if (!strict) continue;
                        throw new IllegalArgumentException("Null key or value in map");
                    }
                    return Optional.of(builder.build());
                }
                throw new IllegalArgumentException("Invalid value type " + val.getClass() + " for " + valueType.toString());
            }
            case SET: {
                if (val instanceof Collection) {
                    PSet pl = (PSet)valueType;
                    PBuilder builder = pl.builder(((Collection)val).size());
                    for (Object o : (Collection)val) {
                        Object value = MessageUtil.coerceInternal(pl.itemDescriptor(), o, strict).orElse(null);
                        if (value != null) {
                            builder.add(value);
                            continue;
                        }
                        if (!strict) continue;
                        throw new IllegalArgumentException("Null value in set");
                    }
                    return Optional.of(builder.build());
                }
                throw new IllegalArgumentException("Invalid value type " + val.getClass() + " for " + valueType.toString());
            }
        }
        throw new IllegalArgumentException("Invalid value type " + val.getClass() + " for type " + (Object)((Object)valueType.getType()));
    }

    private static int asInteger(PDescriptor descriptor, Number value, int min, int max) {
        if (value instanceof Float || value instanceof Double) {
            long l = value.longValue();
            if ((double)l != value.doubleValue()) {
                throw new IllegalArgumentException("Truncating " + descriptor.getName() + " decimals from " + value.toString());
            }
            return MessageUtil.validateInRange(descriptor.getName(), l, min, max);
        }
        return MessageUtil.validateInRange(descriptor.getName(), value.longValue(), min, max);
    }

    private static int validateInRange(String type, long l, int min, int max) throws IllegalArgumentException {
        if (l < (long)min) {
            throw new IllegalArgumentException(type + " value outside of bounds: " + l + " < " + min);
        }
        if (l > (long)max) {
            throw new IllegalArgumentException(type + " value outside of bounds: " + l + " > " + max);
        }
        return (int)l;
    }

    private MessageUtil() {
    }
}

