/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.mio.rolling;

import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.morimekta.providence.mio.RollingFileMessageWriter;

public class TimeBasedRollingPolicy
implements RollingFileMessageWriter.RollingPolicy {
    static final Pattern FILE_PATTERN = Pattern.compile("(.*)[%]d[{]([^{}]*)[}](.*)");
    private final String filePrefix;
    private final String fileSuffix;
    private final int units;
    private final TimeUnit resolution;
    private final DateTimeFormatter formatter;
    private final Clock clock;
    private long lastUpdateTs;

    public TimeBasedRollingPolicy(TimeUnit resolution, String rollingFilePattern) {
        this(1, resolution, rollingFilePattern);
    }

    public TimeBasedRollingPolicy(int units, TimeUnit resolution, String rollingFilePattern) {
        this(units, resolution, rollingFilePattern, Clock.systemDefaultZone());
    }

    public TimeBasedRollingPolicy(TimeUnit resolution, String rollingFilePattern, Clock clock) {
        this(1, resolution, rollingFilePattern, clock);
    }

    public TimeBasedRollingPolicy(int units, TimeUnit resolution, String rollingFilePattern, Clock clock) {
        Matcher matcher = FILE_PATTERN.matcher(rollingFilePattern);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("No timestamp input in rolling file pattern");
        }
        if (units < 1) {
            throw new IllegalArgumentException("Invalid duration: " + units);
        }
        this.filePrefix = matcher.group(1);
        this.fileSuffix = matcher.group(3);
        this.units = units;
        this.resolution = resolution;
        this.formatter = TimeBasedRollingPolicy.getFormatter(matcher.group(2), resolution);
        this.clock = clock;
    }

    @Override
    public void maybeUpdateCurrentFile(@Nonnull RollingFileMessageWriter.CurrentFileUpdater onRollFile, boolean initialCall) throws IOException {
        long ts = this.resolution.toMillis((long)this.units * (this.resolution.convert(this.clock.millis(), TimeUnit.MILLISECONDS) / (long)this.units));
        if (initialCall || ts != this.lastUpdateTs) {
            onRollFile.updateCurrentFile(this.filePrefix + this.fileTimestamp(ts) + this.fileSuffix);
            this.lastUpdateTs = ts;
        }
    }

    private String fileTimestamp(long ts) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(ts), Clock.systemUTC().getZone()).withZoneSameLocal(this.clock.getZone());
        return this.formatter.format(zdt);
    }

    protected static DateTimeFormatter getFormatter(String timestampPattern, TimeUnit resolution) {
        if (timestampPattern.length() > 0) {
            return DateTimeFormatter.ofPattern(timestampPattern);
        }
        switch (resolution) {
            case DAYS: {
                return DateTimeFormatter.ofPattern("yyyy-MM-dd");
            }
            case HOURS: {
                return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH");
            }
            case MINUTES: {
                return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
            }
        }
        throw new IllegalArgumentException("Not a valid log rotation resolution: " + resolution.toString() + ", must be days, hours or minutes");
    }
}

