/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.mio;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.mio.FileMessageWriter;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.serializer.Serializer;

public class RollingFileMessageWriter
implements MessageWriter {
    private final Serializer serializer;
    private final File directory;
    private final String currentName;
    private final RollingPolicy rollingPolicy;
    private final CleanupPolicy cleanupPolicy;
    private File currentFile;
    private FileMessageWriter currentWriter;
    private boolean shouldDoCleanup;

    public RollingFileMessageWriter(@Nonnull File directory, @Nonnull Serializer serializer, @Nonnull String currentName, @Nonnull RollingPolicy rollingPolicy) {
        this(directory, serializer, currentName, rollingPolicy, null);
    }

    public RollingFileMessageWriter(@Nonnull File directory, @Nonnull Serializer serializer, @Nonnull String currentName, @Nonnull RollingPolicy rollingPolicy, @Nullable CleanupPolicy cleanupPolicy) {
        try {
            this.directory = directory.getCanonicalFile().getAbsoluteFile();
            this.serializer = serializer;
            this.currentName = currentName;
            this.rollingPolicy = rollingPolicy;
            this.cleanupPolicy = cleanupPolicy;
            Files.createDirectories(directory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int write(Message message) throws IOException {
        FileMessageWriter writer = this.getWriter();
        int i = writer.write(message);
        return i += writer.separator();
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int write(PServiceCall<Message, Field> call) throws IOException {
        FileMessageWriter writer = this.getWriter();
        int i = writer.write(call);
        return i += writer.separator();
    }

    @Override
    public int separator() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.currentWriter != null) {
            try {
                this.currentWriter.close();
            }
            finally {
                this.currentWriter = null;
            }
        }
    }

    private void updateWriter(String rollToFile) throws IOException {
        if (rollToFile.contains(File.separator)) {
            throw new IllegalArgumentException("rolling file path " + rollToFile + " is not contained in output directory.");
        }
        this.close();
        this.currentFile = new File(this.directory, rollToFile);
        Path link = new File(this.directory, this.currentName).toPath();
        this.currentWriter = new FileMessageWriter(this.currentFile, this.serializer, true);
        this.currentWriter.getOutputStream();
        if (!rollToFile.equals(this.currentName)) {
            Path tmp = Files.createTempFile(this.directory.toPath(), ".pvd.", ".link", new FileAttribute[0]);
            Files.deleteIfExists(tmp);
            Files.createSymbolicLink(tmp, this.currentFile.toPath(), new FileAttribute[0]);
            Files.move(tmp, link, StandardCopyOption.REPLACE_EXISTING);
        }
        if (this.cleanupPolicy != null) {
            this.shouldDoCleanup = true;
        }
    }

    private FileMessageWriter getWriter() throws IOException {
        this.rollingPolicy.maybeUpdateCurrentFile(this::updateWriter, this.currentWriter == null);
        if (this.currentWriter == null) {
            this.updateWriter(this.currentName);
        }
        if (this.shouldDoCleanup) {
            this.shouldDoCleanup = false;
            String[] files = this.directory.list();
            if (files != null && files.length > 2) {
                List<String> toDelete = this.cleanupPolicy.getFilesToDelete(Arrays.stream(files).filter(f -> !f.equals(this.currentName) && !f.equals(this.currentFile.getName())).collect(Collectors.toList()), this.currentFile.getName());
                toDelete.forEach(del -> {
                    try {
                        Files.deleteIfExists(new File(this.directory, (String)del).toPath());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e.getMessage(), e);
                    }
                });
            }
        }
        return this.currentWriter;
    }

    @FunctionalInterface
    public static interface CleanupPolicy {
        @Nonnull
        public List<String> getFilesToDelete(@Nonnull List<String> var1, @Nonnull String var2);
    }

    @FunctionalInterface
    public static interface CurrentFileUpdater {
        public void updateCurrentFile(@Nonnull String var1) throws IOException;
    }

    @FunctionalInterface
    public static interface RollingPolicy {
        public void maybeUpdateCurrentFile(@Nonnull CurrentFileUpdater var1, boolean var2) throws IOException;
    }
}

