/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.mio.rolling;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.morimekta.providence.mio.RollingFileMessageWriter;

public class SizeBasedRollingPolicy
implements RollingFileMessageWriter.RollingPolicy {
    private final long rollOnFileSize;
    private final File directory;
    private final String fileNameFormat;
    private long currentFileId;
    private File currentFile;

    public SizeBasedRollingPolicy(File directory, long rollOnFileSizeInBytes, String fileNameFormat) {
        this.directory = directory;
        this.rollOnFileSize = rollOnFileSizeInBytes;
        this.fileNameFormat = fileNameFormat;
        this.currentFileId = 1L;
        this.currentFile = new File(directory, String.format(Locale.US, fileNameFormat, this.currentFileId));
        try {
            while (this.currentFile.exists() && Files.size(this.currentFile.toPath()) >= rollOnFileSizeInBytes) {
                ++this.currentFileId;
                this.currentFile = new File(directory, String.format(Locale.US, fileNameFormat, this.currentFileId));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Override
    public void maybeUpdateCurrentFile(@Nonnull RollingFileMessageWriter.CurrentFileUpdater onRollFile, boolean initialCall) throws IOException {
        if (initialCall) {
            onRollFile.updateCurrentFile(this.currentFile.getName());
        } else if (Files.size(this.currentFile.toPath()) >= this.rollOnFileSize) {
            ++this.currentFileId;
            this.currentFile = new File(this.directory, String.format(Locale.US, this.fileNameFormat, this.currentFileId));
            Files.deleteIfExists(this.currentFile.toPath());
            onRollFile.updateCurrentFile(this.currentFile.getName());
        }
    }
}

