/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.PrettySerializer;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.streams.MessageStreams;

public class ProvidenceHelper {
    private static final PrettySerializer DEBUG_STRING_SERIALIZER = new PrettySerializer();

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> Message fromJsonResource(String path, PMessageDescriptor<Message, Field> descriptor) throws IOException {
        return ProvidenceHelper.fromResource(path, descriptor, new JsonSerializer(true));
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> ArrayList<Message> arrayListFromJsonResource(String path, PMessageDescriptor<Message, Field> descriptor) throws IOException {
        return ProvidenceHelper.arrayListFromResource(path, descriptor, new JsonSerializer(true));
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> Message fromResource(String resource, PMessageDescriptor<Message, Field> descriptor, Serializer serializer) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream in = classLoader.getResourceAsStream(resource);
        if (in == null && (in = ProvidenceHelper.class.getResourceAsStream(resource)) == null) {
            throw new IOException("No such resource " + resource);
        }
        return serializer.deserialize((InputStream)new BufferedInputStream(in), descriptor);
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> ArrayList<Message> arrayListFromResource(String path, PMessageDescriptor<Message, Field> descriptor, Serializer serializer) throws IOException {
        return MessageStreams.resource(path, serializer, descriptor).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> String debugString(Message message) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEBUG_STRING_SERIALIZER.serialize((OutputStream)baos, message);
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> Message parseDebugString(String string, PMessageDescriptor<Message, Field> descriptor) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
            return DEBUG_STRING_SERIALIZER.deserialize((InputStream)bais, descriptor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Nonnull
    public static <T> Optional<T> optionalInMessage(PMessage message, PField ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("No fields arguments.");
        }
        PField field = fields[0];
        if (!message.has(field.getId())) {
            return Optional.empty();
        }
        if (fields.length > 1) {
            if (field.getType() != PType.MESSAGE) {
                throw new IllegalArgumentException("Field " + field.getName() + " is not a message.");
            }
            return ProvidenceHelper.optionalInMessage((PMessage)message.get(field), Arrays.copyOfRange(fields, 1, fields.length));
        }
        return Optional.of(message.get(field.getId()));
    }

    private ProvidenceHelper() {
    }
}

