/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

public class BinarySerializer
extends Serializer {
    public static final String MEDIA_TYPE = "application/vnd.apache.thrift.binary";
    public static final String ALT_MEDIA_TYPE = "application/x-thrift";
    private static final int VERSION_MASK = -65536;
    private static final int VERSION_1 = -2147418112;
    private static final int MAX_METHOD_NAME_LEN = 255;
    private final boolean strict;
    private final boolean versioned;

    public BinarySerializer() {
        this(false);
    }

    public BinarySerializer(boolean readStrict) {
        this(readStrict, true);
    }

    public BinarySerializer(boolean readStrict, boolean versioned) {
        this.strict = readStrict;
        this.versioned = versioned;
    }

    @Override
    public boolean binaryProtocol() {
        return true;
    }

    @Override
    @Nonnull
    public String mediaType() {
        return MEDIA_TYPE;
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(@Nonnull OutputStream os, @Nonnull Message message) throws IOException {
        BigEndianBinaryWriter writer = new BigEndianBinaryWriter(os);
        return BinaryFormatUtils.writeMessage(writer, message);
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(@Nonnull OutputStream os, @Nonnull PServiceCall<Message, Field> call) throws IOException {
        BigEndianBinaryWriter out = new BigEndianBinaryWriter(os);
        byte[] method = call.getMethod().getBytes(StandardCharsets.UTF_8);
        int len = method.length;
        if (this.versioned) {
            len += out.writeInt(0x80010000 | call.getType().asInteger());
            len += out.writeInt(method.length);
            out.write(method);
        } else {
            len += out.writeInt(method.length);
            out.write(method);
            len += out.writeByte((byte)call.getType().asInteger());
        }
        len += out.writeInt(call.getSequence());
        return len += BinaryFormatUtils.writeMessage(out, call.getMessage());
    }

    @Override
    @Nonnull
    public <Message extends PMessage<Message, Field>, Field extends PField> Message deserialize(@Nonnull InputStream input, @Nonnull PMessageDescriptor<Message, Field> descriptor) throws IOException {
        BigEndianBinaryReader reader = new BigEndianBinaryReader(input);
        return BinaryFormatUtils.readMessage(reader, descriptor, this.strict);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nonnull
    public <Message extends PMessage<Message, Field>, Field extends PField> PServiceCall<Message, Field> deserialize(@Nonnull InputStream is, @Nonnull PService service) throws IOException {
        BigEndianBinaryReader in = new BigEndianBinaryReader(is);
        String methodName = null;
        int sequence = 0;
        PServiceCallType type = null;
        try {
            int typeKey;
            int methodNameLen = in.expectInt();
            if (methodNameLen <= 0) {
                int version = methodNameLen & 0xFFFF0000;
                if (version != -2147418112) throw new SerializerException("Bad protocol version: %08x", version >>> 16).setExceptionType(PApplicationExceptionType.INVALID_PROTOCOL);
                typeKey = methodNameLen & 0xFF;
                methodNameLen = in.expectInt();
                if (methodNameLen > 255) {
                    throw new SerializerException("Exceptionally long method name of %s bytes", methodNameLen).setExceptionType(PApplicationExceptionType.PROTOCOL_ERROR);
                }
                if (methodNameLen < 1) {
                    throw new SerializerException("Exceptionally short method name of %s bytes", methodNameLen).setExceptionType(PApplicationExceptionType.PROTOCOL_ERROR);
                }
                methodName = new String(in.expectBytes(methodNameLen), StandardCharsets.UTF_8);
            } else {
                if (this.strict && this.versioned) {
                    throw new SerializerException("Missing protocol version", new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_PROTOCOL);
                }
                if (methodNameLen > 255) {
                    if (methodNameLen >>> 24 == 60) {
                        throw new SerializerException("Received HTML in service call", new Object[0]).setExceptionType(PApplicationExceptionType.PROTOCOL_ERROR);
                    }
                    if (methodNameLen >>> 24 != 123 && methodNameLen >>> 24 != 91) throw new SerializerException("Exceptionally long method name of %s bytes", methodNameLen).setExceptionType(PApplicationExceptionType.PROTOCOL_ERROR);
                    throw new SerializerException("Received JSON in service call", new Object[0]).setExceptionType(PApplicationExceptionType.PROTOCOL_ERROR);
                }
                methodName = new String(in.expectBytes(methodNameLen), StandardCharsets.UTF_8);
                typeKey = in.expectByte();
            }
            sequence = in.expectInt();
            type = PServiceCallType.findById(typeKey);
            PServiceMethod method = service.getMethod(methodName);
            if (type == null) {
                throw new SerializerException("Invalid call type " + typeKey, new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
            }
            if (type == PServiceCallType.EXCEPTION) {
                PApplicationException pApplicationException = BinaryFormatUtils.readMessage(in, PApplicationException.kDescriptor, this.strict);
                return new PServiceCall(methodName, type, sequence, pApplicationException);
            }
            if (method == null) {
                throw new SerializerException("No such method " + methodName + " on " + service.getQualifiedName(), new Object[0]).setExceptionType(PApplicationExceptionType.UNKNOWN_METHOD);
            }
            PMessageDescriptor pMessageDescriptor = this.isRequestCallType(type) ? method.getRequestType() : method.getResponseType();
            Object message = BinaryFormatUtils.readMessage(in, pMessageDescriptor, this.strict);
            return new PServiceCall(methodName, type, sequence, message);
        }
        catch (SerializerException se) {
            throw new SerializerException(se).setMethodName(methodName).setCallType(type).setSequenceNo(sequence);
        }
        catch (IOException e) {
            throw new SerializerException(e, e.getMessage(), new Object[0]).setMethodName(methodName).setCallType(type).setSequenceNo(sequence);
        }
    }
}

