/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.JsonSerializerException;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.json.JsonCompactible;
import net.morimekta.providence.serializer.json.JsonCompactibleDescriptor;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.CountingOutputStream;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonToken;
import net.morimekta.util.json.JsonTokenizer;
import net.morimekta.util.json.JsonWriter;
import net.morimekta.util.json.PrettyJsonWriter;

public class JsonSerializer
extends Serializer {
    public static final String MEDIA_TYPE = "application/vnd.morimekta.providence.json";
    public static final String JSON_MEDIA_TYPE = "application/json";
    private static final int PRETTY_READ_BUFFER_SIZE = 1024;
    private static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    private final boolean readStrict;
    private final IdType fieldIdType;
    private final IdType enumValueType;
    private final boolean prettyPrint;

    public JsonSerializer() {
        this(false, false, IdType.ID, IdType.ID);
    }

    public JsonSerializer(boolean strict) {
        this(strict, false, IdType.ID, IdType.ID);
    }

    public JsonSerializer pretty() {
        return new JsonSerializer(this.readStrict, true, IdType.NAME, IdType.NAME);
    }

    public JsonSerializer named() {
        return this.withNamedEnums().withNamedFields();
    }

    public JsonSerializer withNamedFields() {
        return new JsonSerializer(this.readStrict, this.prettyPrint, IdType.NAME, this.enumValueType);
    }

    public JsonSerializer withNamedEnums() {
        return new JsonSerializer(this.readStrict, this.prettyPrint, this.fieldIdType, IdType.NAME);
    }

    public <T extends PMessage<T, F>, F extends PField> int serialize(@Nonnull OutputStream output, @Nonnull T message) throws IOException {
        CountingOutputStream counter = new CountingOutputStream(output);
        PrettyJsonWriter jsonWriter = this.prettyPrint ? new PrettyJsonWriter((OutputStream)counter) : new JsonWriter((OutputStream)counter);
        this.appendMessage((JsonWriter)jsonWriter, message);
        jsonWriter.flush();
        counter.flush();
        return counter.getByteCount();
    }

    public <T extends PMessage<T, F>, F extends PField> int serialize(@Nonnull OutputStream output, @Nonnull PServiceCall<T, F> call) throws IOException {
        CountingOutputStream counter = new CountingOutputStream(output);
        PrettyJsonWriter jsonWriter = this.prettyPrint ? new PrettyJsonWriter((OutputStream)counter) : new JsonWriter((OutputStream)counter);
        jsonWriter.array().value((CharSequence)call.getMethod());
        if (this.enumValueType == IdType.ID) {
            jsonWriter.value(call.getType().asInteger());
        } else {
            jsonWriter.valueUnescaped((CharSequence)call.getType().asString().toLowerCase());
        }
        jsonWriter.value(call.getSequence());
        this.appendMessage((JsonWriter)jsonWriter, (PMessage<?, ?>)call.getMessage());
        jsonWriter.endArray().flush();
        counter.flush();
        return counter.getByteCount();
    }

    @Nonnull
    public <T extends PMessage<T, TF>, TF extends PField> T deserialize(@Nonnull InputStream input, @Nonnull PMessageDescriptor<T, TF> type) throws IOException {
        try {
            JsonTokenizer tokenizer = new JsonTokenizer(input, this.prettyPrint ? 1024 : 32768);
            if (!tokenizer.hasNext()) {
                throw new SerializerException("Empty json body", new Object[0]);
            }
            return (T)Objects.requireNonNull((PMessage)this.parseTypedValue(tokenizer.next(), tokenizer, type, false));
        }
        catch (JsonException e) {
            throw new JsonSerializerException(e);
        }
    }

    @Nonnull
    public <T extends PMessage<T, F>, F extends PField> PServiceCall<T, F> deserialize(@Nonnull InputStream input, @Nonnull PService service) throws IOException {
        JsonTokenizer tokenizer = new JsonTokenizer(input, this.prettyPrint ? 1024 : 32768);
        return this.parseServiceCall(tokenizer, service);
    }

    @Override
    public boolean binaryProtocol() {
        return false;
    }

    @Override
    @Nonnull
    public String mediaType() {
        if (this.fieldIdType == IdType.NAME) {
            return JSON_MEDIA_TYPE;
        }
        return MEDIA_TYPE;
    }

    private JsonSerializer(boolean readStrict, boolean prettyPrint, IdType fieldIdType, IdType enumValueType) {
        this.readStrict = readStrict;
        this.prettyPrint = prettyPrint;
        this.fieldIdType = fieldIdType;
        this.enumValueType = enumValueType;
    }

    private <T extends PMessage<T, F>, F extends PField> PServiceCall<T, F> parseServiceCall(JsonTokenizer tokenizer, PService service) throws IOException {
        PServiceCallType type = null;
        String methodName = null;
        int sequence = 0;
        try {
            PMessageDescriptor descriptor;
            tokenizer.expectSymbol("service call start", new char[]{'['});
            methodName = tokenizer.expectString("method name").rawJsonLiteral();
            tokenizer.expectSymbol("entry sep", new char[]{','});
            JsonToken callTypeToken = tokenizer.expect("call type");
            if (callTypeToken.isInteger()) {
                byte typeKey = callTypeToken.byteValue();
                type = PServiceCallType.findById(typeKey);
                if (type == null) {
                    throw new SerializerException("Service call type " + typeKey + " is not valid", new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
            } else if (callTypeToken.isLiteral()) {
                String typeName = callTypeToken.rawJsonLiteral();
                type = PServiceCallType.findByName(typeName.toUpperCase());
                if (type == null) {
                    throw new SerializerException("Service call type \"" + Strings.escape((CharSequence)typeName) + "\" is not valid", new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
            } else {
                throw new SerializerException("Invalid service call type token " + callTypeToken.asString(), new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
            }
            tokenizer.expectSymbol("entry sep", new char[]{','});
            sequence = tokenizer.expectNumber("Service call sequence").intValue();
            tokenizer.expectSymbol("entry sep", new char[]{','});
            if (type == PServiceCallType.EXCEPTION) {
                PApplicationException ex = (PApplicationException)this.parseTypedValue(tokenizer.expect("Message start"), tokenizer, PApplicationException.kDescriptor, false);
                tokenizer.expectSymbol("service call end", new char[]{']'});
                return new PServiceCall(methodName, type, sequence, ex);
            }
            PServiceMethod method = service.getMethod(methodName);
            if (method == null) {
                throw new SerializerException("No such method " + methodName + " on " + service.getQualifiedName(), new Object[0]).setExceptionType(PApplicationExceptionType.UNKNOWN_METHOD);
            }
            PMessageDescriptor pMessageDescriptor = descriptor = this.isRequestCallType(type) ? method.getRequestType() : method.getResponseType();
            if (descriptor == null) {
                throw new SerializerException("No %s type for %s.%s()", this.isRequestCallType(type) ? "request" : "response", service.getQualifiedName(), methodName).setExceptionType(PApplicationExceptionType.UNKNOWN_METHOD);
            }
            PMessage message = (PMessage)this.parseTypedValue(tokenizer.expect("message start"), tokenizer, descriptor, false);
            tokenizer.expectSymbol("service call end", new char[]{']'});
            return new PServiceCall(methodName, type, sequence, message);
        }
        catch (SerializerException se) {
            throw new SerializerException(se).setMethodName(methodName).setCallType(type).setSequenceNo(sequence);
        }
        catch (JsonException je) {
            throw new JsonSerializerException(je).setMethodName(methodName).setCallType(type).setSequenceNo(sequence);
        }
    }

    private <T extends PMessage<T, F>, F extends PField> T parseMessage(JsonTokenizer tokenizer, PMessageDescriptor<T, F> type) throws JsonException, IOException {
        PBuilder builder = type.builder();
        if (tokenizer.peek("message end or key").isSymbol('}')) {
            tokenizer.next();
        } else {
            int sep = 123;
            while (sep != 125) {
                JsonToken token = tokenizer.expectString("field spec");
                String key = token.rawJsonLiteral();
                F field = Strings.isInteger((CharSequence)key) ? type.findFieldById(Integer.parseInt(key)) : type.findFieldByName(key);
                tokenizer.expectSymbol("field KV sep", new char[]{':'});
                if (field != null) {
                    Object value = this.parseTypedValue(tokenizer.expect("field value"), tokenizer, field.getDescriptor(), true);
                    ((PMessageBuilder)builder).set(field.getId(), value);
                } else {
                    this.consume(tokenizer.expect("field value"), tokenizer);
                }
                sep = tokenizer.expectSymbol("message end or sep", new char[]{'}', ','});
            }
        }
        if (this.readStrict) {
            try {
                ((PMessageBuilder)builder).validate();
            }
            catch (IllegalStateException e) {
                throw new SerializerException(e, e.getMessage(), new Object[0]);
            }
        }
        return (T)((PMessage)builder.build());
    }

    private <T extends PMessage<T, F>, F extends PField> T parseCompactMessage(JsonTokenizer tokenizer, PMessageDescriptor<T, F> type) throws IOException, JsonException {
        PBuilder builder = type.builder();
        int i = 0;
        int sep = 91;
        while (sep != 93) {
            F field;
            if ((field = type.findFieldById(++i)) != null) {
                Object value = this.parseTypedValue(tokenizer.expect("field value"), tokenizer, field.getDescriptor(), true);
                ((PMessageBuilder)builder).set(i, value);
            } else {
                this.consume(tokenizer.expect("compact field value"), tokenizer);
            }
            sep = tokenizer.expectSymbol("compact entry sep", new char[]{']', ','});
        }
        if (this.readStrict) {
            try {
                ((PMessageBuilder)builder).validate();
            }
            catch (IllegalStateException e) {
                throw new SerializerException(e, e.getMessage(), new Object[0]);
            }
        }
        return (T)((PMessage)builder.build());
    }

    private void consume(JsonToken token, JsonTokenizer tokenizer) throws IOException, JsonException {
        block6: {
            block7: {
                if (!token.isSymbol()) break block6;
                if (!token.isSymbol('[')) break block7;
                if (tokenizer.peek("lists end or value").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    int sep = 91;
                    while (sep != 93) {
                        this.consume(tokenizer.expect("list item"), tokenizer);
                        sep = tokenizer.expectSymbol("list sep", new char[]{']', ','});
                    }
                }
                break block6;
            }
            if (!token.isSymbol('{')) break block6;
            if (tokenizer.peek("map end or key").isSymbol('}')) {
                tokenizer.next();
            } else {
                int sep = 123;
                while (sep != 125) {
                    tokenizer.expectString("map key");
                    tokenizer.expectSymbol("map KV sep", new char[]{':'});
                    this.consume(tokenizer.expect("entry value"), tokenizer);
                    sep = tokenizer.expectSymbol("map end or sep", new char[]{'}', ','});
                }
            }
        }
    }

    private Object parseTypedValue(JsonToken token, JsonTokenizer tokenizer, PDescriptor t, boolean allowNull) throws IOException, JsonException {
        if (token.isNull()) {
            if (!allowNull) {
                throw new SerializerException("Null value as body.", new Object[0]);
            }
            return null;
        }
        switch (t.getType()) {
            case VOID: {
                if (token.isBoolean()) {
                    return token.booleanValue() ? Boolean.TRUE : null;
                }
                throw new SerializerException("Not a void token value: '" + token.asString() + "'", new Object[0]);
            }
            case BOOL: {
                if (token.isBoolean()) {
                    return token.booleanValue();
                }
                throw new SerializerException("No boolean value for token: '" + token.asString() + "'", new Object[0]);
            }
            case BYTE: {
                if (token.isInteger()) {
                    return token.byteValue();
                }
                throw new SerializerException("Not a valid byte value: '" + token.asString() + "'", new Object[0]);
            }
            case I16: {
                if (token.isInteger()) {
                    return token.shortValue();
                }
                throw new SerializerException("Not a valid short value: '" + token.asString() + "'", new Object[0]);
            }
            case I32: {
                if (token.isInteger()) {
                    return token.intValue();
                }
                throw new SerializerException("Not a valid int value: '" + token.asString() + "'", new Object[0]);
            }
            case I64: {
                if (token.isInteger()) {
                    return token.longValue();
                }
                throw new SerializerException("Not a valid long value: '" + token.asString() + "'", new Object[0]);
            }
            case DOUBLE: {
                if (token.isNumber()) {
                    return token.doubleValue();
                }
                throw new SerializerException("Not a valid double value: '" + token.asString() + "'", new Object[0]);
            }
            case STRING: {
                if (token.isLiteral()) {
                    return token.decodeJsonLiteral();
                }
                throw new SerializerException("Not a valid string value: '" + token.asString() + "'", new Object[0]);
            }
            case BINARY: {
                if (token.isLiteral()) {
                    try {
                        return Binary.fromBase64((String)token.rawJsonLiteral());
                    }
                    catch (IllegalArgumentException e) {
                        throw new SerializerException(e, "Unable to parse Base64 data: " + token.asString(), new Object[0]);
                    }
                }
                throw new SerializerException("Not a valid binary value: " + token.asString(), new Object[0]);
            }
            case ENUM: {
                PBuilder eb = ((PEnumDescriptor)t).builder();
                if (token.isInteger()) {
                    ((PEnumBuilder)eb).setById(token.intValue());
                } else if (token.isLiteral()) {
                    ((PEnumBuilder)eb).setByName(token.rawJsonLiteral());
                } else {
                    throw new SerializerException(token.asString() + " is not a enum value type", new Object[0]);
                }
                if (!allowNull && !((PEnumBuilder)eb).valid()) {
                    throw new SerializerException(token.asString() + " is not a known enum value for " + t.getQualifiedName(), new Object[0]);
                }
                return eb.build();
            }
            case MESSAGE: {
                PMessageDescriptor st = (PMessageDescriptor)t;
                if (token.isSymbol('{')) {
                    return this.parseMessage(tokenizer, st);
                }
                if (token.isSymbol('[')) {
                    if (this.isCompactible(st)) {
                        return this.parseCompactMessage(tokenizer, st);
                    }
                    throw new SerializerException(st.getName() + " is not compatible for compact struct notation.", new Object[0]);
                }
                throw new SerializerException("expected message start, found: '%s'", token.asString());
            }
            case MAP: {
                PMap mapType = (PMap)t;
                PDescriptor itemType = mapType.itemDescriptor();
                PDescriptor keyType = mapType.keyDescriptor();
                if (!token.isSymbol('{')) {
                    throw new SerializerException("Invalid start of map '" + token.asString() + "'", new Object[0]);
                }
                PBuilder map = mapType.builder();
                if (tokenizer.peek("map end or value").isSymbol('}')) {
                    tokenizer.next();
                } else {
                    int sep = 123;
                    while (sep != 125) {
                        Object key = this.parseMapKey(tokenizer.expectString("map key").decodeJsonLiteral(), keyType);
                        tokenizer.expectSymbol("map K/V sep", new char[]{':'});
                        Object value = this.parseTypedValue(tokenizer.expect("map value"), tokenizer, itemType, false);
                        if (key != null && value != null) {
                            map.put(key, value);
                        }
                        sep = tokenizer.expectSymbol("map end or sep", new char[]{'}', ','});
                    }
                }
                return map.build();
            }
            case SET: {
                PDescriptor itemType = ((PSet)t).itemDescriptor();
                if (!token.isSymbol('[')) {
                    throw new SerializerException("Invalid start of set '" + token.asString() + "'", new Object[0]);
                }
                PBuilder set = ((PSet)t).builder();
                if (tokenizer.peek("set end or value").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    int sep = 91;
                    while (sep != 93) {
                        Object val = this.parseTypedValue(tokenizer.expect("set value"), tokenizer, itemType, !this.readStrict);
                        if (val != null) {
                            set.add(val);
                        }
                        sep = tokenizer.expectSymbol("set end or sep", new char[]{',', ']'});
                    }
                }
                return set.build();
            }
            case LIST: {
                PDescriptor itemType = ((PList)t).itemDescriptor();
                if (!token.isSymbol('[')) {
                    throw new SerializerException("Invalid start of list '" + token.asString() + "'", new Object[0]);
                }
                PBuilder list = ((PList)t).builder();
                if (tokenizer.peek("list end or value").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    int sep = 91;
                    while (sep != 93) {
                        list.add(this.parseTypedValue(tokenizer.expect("list value"), tokenizer, itemType, false));
                        sep = tokenizer.expectSymbol("list end or sep", new char[]{',', ']'});
                    }
                }
                return list.build();
            }
        }
        throw new SerializerException("Unhandled item type " + t.getQualifiedName(), new Object[0]);
    }

    private boolean isCompactible(PMessageDescriptor descriptor) {
        return descriptor instanceof JsonCompactibleDescriptor && ((JsonCompactibleDescriptor)((Object)descriptor)).isJsonCompactible();
    }

    private boolean isCompact(PMessage message) {
        return message instanceof JsonCompactible && ((JsonCompactible)((Object)message)).jsonCompact();
    }

    private Object parseMapKey(String key, PDescriptor keyType) throws SerializerException {
        try {
            switch (keyType.getType()) {
                case BOOL: {
                    if (key.equalsIgnoreCase("true")) {
                        return Boolean.TRUE;
                    }
                    if (key.equalsIgnoreCase("false")) {
                        return Boolean.FALSE;
                    }
                    throw new SerializerException("Invalid boolean value: \"" + Strings.escape((CharSequence)key) + "\"", new Object[0]);
                }
                case BYTE: {
                    return Byte.parseByte(key);
                }
                case I16: {
                    return Short.parseShort(key);
                }
                case I32: {
                    return Integer.parseInt(key);
                }
                case I64: {
                    return Long.parseLong(key);
                }
                case DOUBLE: {
                    try {
                        JsonTokenizer tokenizer = new JsonTokenizer((InputStream)new ByteArrayInputStream(key.getBytes(StandardCharsets.US_ASCII)));
                        JsonToken token = tokenizer.next();
                        if (!token.isNumber()) {
                            throw new SerializerException("Unable to parse double from key \"" + key + "\"", new Object[0]);
                        }
                        if (tokenizer.hasNext()) {
                            throw new SerializerException("Garbage after double: \"" + key + "\"", new Object[0]);
                        }
                        return token.doubleValue();
                    }
                    catch (SerializerException e) {
                        throw e;
                    }
                    catch (IOException | JsonException e) {
                        throw new SerializerException(e, "Unable to parse double from key \"" + key + "\"", new Object[0]);
                    }
                }
                case STRING: {
                    return key;
                }
                case BINARY: {
                    try {
                        return Binary.fromBase64((String)key);
                    }
                    catch (IllegalArgumentException e) {
                        throw new SerializerException(e, "Unable to parse Base64 data", new Object[0]);
                    }
                }
                case ENUM: {
                    PBuilder eb = ((PEnumDescriptor)keyType).builder();
                    if (Strings.isInteger((CharSequence)key)) {
                        ((PEnumBuilder)eb).setById(Integer.parseInt(key));
                    } else {
                        ((PEnumBuilder)eb).setByName(key);
                    }
                    if (this.readStrict && !((PEnumBuilder)eb).valid()) {
                        throw new SerializerException("\"%s\" is not a known enum value for %s", Strings.escape((CharSequence)key), keyType.getQualifiedName());
                    }
                    return eb.build();
                }
                case MESSAGE: {
                    PMessageDescriptor st = (PMessageDescriptor)keyType;
                    if (!st.isSimple()) {
                        throw new SerializerException("Only simple structs can be used as map key. %s is not.", st.getQualifiedName());
                    }
                    ByteArrayInputStream input = new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8));
                    try {
                        JsonTokenizer tokenizer = new JsonTokenizer((InputStream)input);
                        if ('{' == tokenizer.expectSymbol("message start", new char[]{'{', '['})) {
                            return this.parseMessage(tokenizer, st);
                        }
                        return this.parseCompactMessage(tokenizer, st);
                    }
                    catch (IOException | JsonException e) {
                        throw new SerializerException(e, "Error parsing message key: " + e.getMessage(), new Object[0]);
                    }
                }
            }
            throw new SerializerException("Illegal key type: %s", new Object[]{keyType.getType()});
        }
        catch (NumberFormatException nfe) {
            throw new SerializerException(nfe, "Unable to parse numeric value %s", key);
        }
    }

    private void appendMessage(JsonWriter writer, PMessage<?, ?> message) throws SerializerException {
        PDescriptor type = message.descriptor();
        if (message instanceof PUnion) {
            writer.object();
            if (((PUnion)message).unionFieldIsSet()) {
                Object field = ((PUnion)message).unionField();
                Object value = message.get(field.getId());
                if (IdType.ID.equals((Object)this.fieldIdType)) {
                    writer.key(field.getId());
                } else {
                    writer.keyUnescaped((CharSequence)field.getName());
                }
                this.appendTypedValue(writer, field.getDescriptor(), value);
            }
            writer.endObject();
        } else if (this.isCompact(message)) {
            writer.array();
            for (PField field : type.getFields()) {
                if (!message.has(field.getId())) break;
                this.appendTypedValue(writer, field.getDescriptor(), message.get(field.getId()));
            }
            writer.endArray();
        } else {
            writer.object();
            for (PField field : type.getFields()) {
                if (!message.has(field.getId())) continue;
                Object value = message.get(field.getId());
                if (IdType.ID.equals((Object)this.fieldIdType)) {
                    writer.key(field.getId());
                } else {
                    writer.keyUnescaped((CharSequence)field.getName());
                }
                this.appendTypedValue(writer, field.getDescriptor(), value);
            }
            writer.endObject();
        }
    }

    private void appendTypedValue(JsonWriter writer, PDescriptor type, Object value) throws SerializerException {
        switch (type.getType()) {
            case VOID: {
                writer.value(true);
                break;
            }
            case MESSAGE: {
                PMessage message = (PMessage)value;
                this.appendMessage(writer, message);
                break;
            }
            case MAP: {
                writer.object();
                PMap mapType = (PMap)type;
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    this.appendPrimitiveKey(writer, entry.getKey());
                    this.appendTypedValue(writer, mapType.itemDescriptor(), entry.getValue());
                }
                writer.endObject();
                break;
            }
            case SET: 
            case LIST: {
                writer.array();
                PContainer containerType = (PContainer)type;
                Collection collection = (Collection)value;
                for (Object i : collection) {
                    this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                }
                writer.endArray();
                break;
            }
            default: {
                this.appendPrimitive(writer, value);
            }
        }
    }

    private void appendPrimitiveKey(JsonWriter writer, Object primitive) throws SerializerException {
        if (primitive instanceof PEnumValue) {
            if (IdType.ID.equals((Object)this.fieldIdType)) {
                writer.key(((PEnumValue)primitive).asInteger());
            } else {
                writer.keyUnescaped((CharSequence)primitive.toString());
            }
        } else if (primitive instanceof Boolean) {
            writer.key(((Boolean)primitive).booleanValue());
        } else if (primitive instanceof Byte) {
            writer.key(((Byte)primitive).byteValue());
        } else if (primitive instanceof Short) {
            writer.key(((Short)primitive).shortValue());
        } else if (primitive instanceof Integer) {
            writer.key(((Integer)primitive).intValue());
        } else if (primitive instanceof Long) {
            writer.key(((Long)primitive).longValue());
        } else if (primitive instanceof Double) {
            writer.key(((Double)primitive).doubleValue());
        } else if (primitive instanceof String) {
            writer.key((CharSequence)((String)primitive));
        } else if (primitive instanceof Binary) {
            writer.key((Binary)primitive);
        } else if (primitive instanceof PMessage) {
            PMessage message = (PMessage)primitive;
            if (!((PMessageDescriptor)message.descriptor()).isSimple()) {
                throw new SerializerException("Only simple messages can be used as map keys. " + message.descriptor().getQualifiedName() + " is not.", new Object[0]);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter json = new JsonWriter((OutputStream)baos);
            this.appendMessage(json, message);
            json.flush();
            writer.key((CharSequence)new String(baos.toByteArray(), StandardCharsets.UTF_8));
        } else {
            throw new SerializerException("illegal simple type class " + primitive.getClass().getSimpleName(), new Object[0]);
        }
    }

    private void appendPrimitive(JsonWriter writer, Object primitive) throws SerializerException {
        if (primitive instanceof PEnumValue) {
            if (IdType.ID.equals((Object)this.enumValueType)) {
                writer.value(((PEnumValue)primitive).asInteger());
            } else {
                writer.valueUnescaped((CharSequence)primitive.toString());
            }
        } else if (primitive instanceof Boolean) {
            writer.value(((Boolean)primitive).booleanValue());
        } else if (primitive instanceof Byte) {
            writer.value(((Byte)primitive).byteValue());
        } else if (primitive instanceof Short) {
            writer.value(((Short)primitive).shortValue());
        } else if (primitive instanceof Integer) {
            writer.value(((Integer)primitive).intValue());
        } else if (primitive instanceof Long) {
            writer.value(((Long)primitive).longValue());
        } else if (primitive instanceof Double) {
            writer.value(((Double)primitive).doubleValue());
        } else if (primitive instanceof CharSequence) {
            writer.value((CharSequence)((String)primitive));
        } else if (primitive instanceof Binary) {
            writer.value((Binary)primitive);
        } else {
            throw new SerializerException("illegal primitive type class " + primitive.getClass().getSimpleName(), new Object[0]);
        }
    }

    private static enum IdType {
        ID,
        NAME;

    }
}

