/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PContainerProvider;
import net.morimekta.providence.descriptor.PDescriptorProvider;

public class PSet<Item>
extends PContainer<Set<Item>> {
    private final Supplier<Builder<Item>> builderSupplier;

    public PSet(PDescriptorProvider itemType, Supplier<Builder<Item>> builderSupplier) {
        super(itemType);
        this.builderSupplier = builderSupplier;
    }

    @Override
    @Nonnull
    public String getName() {
        return "set<" + this.itemDescriptor().getName() + ">";
    }

    @Override
    @Nonnull
    public String getQualifiedName(String programContext) {
        return "set<" + this.itemDescriptor().getQualifiedName(programContext) + ">";
    }

    @Override
    @Nonnull
    public PType getType() {
        return PType.SET;
    }

    @Override
    @Nullable
    public Object getDefaultValue() {
        return Collections.EMPTY_SET;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PSet)) {
            return false;
        }
        PSet other = (PSet)o;
        return other.itemDescriptor().equals(this.itemDescriptor());
    }

    public int hashCode() {
        return PSet.class.hashCode() + this.itemDescriptor().hashCode();
    }

    @Override
    @Nonnull
    public Builder<Item> builder() {
        return this.builderSupplier.get();
    }

    @Nonnull
    public static <I> PContainerProvider<Set<I>, PSet<I>> provider(PDescriptorProvider itemDesc) {
        return PSet.provider(itemDesc, DefaultBuilder::new);
    }

    @Nonnull
    public static <I extends Comparable<I>> PContainerProvider<Set<I>, PSet<I>> sortedProvider(PDescriptorProvider itemDesc) {
        return PSet.provider(itemDesc, SortedBuilder::new);
    }

    @Nonnull
    public static <I extends Comparable<I>> PContainerProvider<Set<I>, PSet<I>> orderedProvider(PDescriptorProvider itemDesc) {
        return PSet.provider(itemDesc, OrderedBuilder::new);
    }

    private static <I> PContainerProvider<Set<I>, PSet<I>> provider(PDescriptorProvider itemDesc, Supplier<Builder<I>> builderFactory) {
        return new PContainerProvider<Set<I>, PSet<I>>(new PSet(itemDesc, builderFactory));
    }

    public static class OrderedBuilder<I>
    extends DefaultBuilder<I> {
    }

    public static class SortedBuilder<I extends Comparable<I>>
    implements Builder<I> {
        private ImmutableSortedSet.Builder<I> builder = ImmutableSortedSet.naturalOrder();

        @Override
        @Nonnull
        public Builder<I> add(@Nonnull I value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public Builder<I> addAll(@Nonnull Collection<I> items) {
            this.builder.addAll(items);
            return this;
        }

        @Override
        @Nonnull
        public Set<I> build() {
            return this.builder.build();
        }
    }

    public static class DefaultBuilder<I>
    implements Builder<I> {
        private ImmutableSet.Builder<I> builder = ImmutableSet.builder();

        @Override
        @Nonnull
        public Builder<I> add(@Nonnull I value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public Builder<I> addAll(@Nonnull Collection<I> items) {
            this.builder.addAll(items);
            return this;
        }

        @Override
        @Nonnull
        public Set<I> build() {
            return this.builder.build();
        }
    }

    public static interface Builder<I>
    extends PBuilder<Set<I>> {
        @Nonnull
        public Builder<I> add(@Nonnull I var1);

        @Nonnull
        public Builder<I> addAll(@Nonnull Collection<I> var1);

        @Override
        @Nonnull
        public Set<I> build();
    }
}

