/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.json.JsonException;

public class JsonSerializerException
extends SerializerException {
    private static final long serialVersionUID = 1493883783445793582L;

    public JsonSerializerException(@Nonnull JsonException e) {
        super(e, e.getMessage(), new Object[0]);
    }

    @Override
    @Nonnull
    public synchronized JsonException getCause() {
        return (JsonException)super.getCause();
    }

    public String getLine() {
        return this.getCause().getLine();
    }

    public int getLineNo() {
        return this.getCause().getLineNo();
    }

    public int getLinePos() {
        return this.getCause().getLinePos();
    }

    public int getLen() {
        return this.getCause().getLen();
    }

    @Override
    public synchronized Throwable initCause(Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper(this.getClass()).omitNullValues().addValue((Object)this.getMessage());
        if (this.getExceptionType() != PApplicationExceptionType.PROTOCOL_ERROR) {
            tsh.add("e", (Object)this.getExceptionType());
        }
        if (!Strings.isNullOrEmpty((String)this.getLine())) {
            tsh.add("line", this.getLineNo()).add("pos", this.getLinePos());
        }
        if (!Strings.isNullOrEmpty((String)this.getMethodName())) {
            tsh.add("method", (Object)this.getMethodName()).add("type", (Object)this.getCallType()).add("seq", this.getSequenceNo());
        }
        return tsh.toString();
    }

    @Override
    public String asString() {
        if (this.getLine() != null) {
            return String.format("JSON Error%s on line %d: %s%n%s%n%s%s", this.getMethodName().isEmpty() ? "" : " in " + this.getMethodName(), this.getLineNo(), this.getLocalizedMessage(), this.getLine(), net.morimekta.util.Strings.times((String)"-", (int)(this.getLinePos() - 1)), net.morimekta.util.Strings.times((String)"^", (int)this.getLen()));
        }
        return String.format("JSON Error: %s", this.getLocalizedMessage());
    }
}

