/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PContainerProvider;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.util.collect.UnmodifiableList;

public class PList<Item>
extends PContainer<List<Item>> {
    private final IntFunction<Builder<Item>> builderSupplier;

    public PList(PDescriptorProvider itemType, IntFunction<Builder<Item>> builderSupplier) {
        super(itemType);
        this.builderSupplier = builderSupplier;
    }

    @Override
    @Nonnull
    public String getName() {
        return "list<" + this.itemDescriptor().getName() + ">";
    }

    @Override
    @Nonnull
    public String getQualifiedName(String programContext) {
        return "list<" + this.itemDescriptor().getQualifiedName(programContext) + ">";
    }

    @Override
    @Nonnull
    public PType getType() {
        return PType.LIST;
    }

    @Override
    @Nullable
    public Object getDefaultValue() {
        return Collections.EMPTY_LIST;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PList)) {
            return false;
        }
        PList other = (PList)o;
        return other.itemDescriptor().equals(this.itemDescriptor());
    }

    public int hashCode() {
        return PList.class.hashCode() + this.itemDescriptor().hashCode();
    }

    @Override
    @Nonnull
    public Builder<Item> builder(int capacity) {
        return this.builderSupplier.apply(capacity);
    }

    @Nonnull
    public static <I> PContainerProvider<List<I>, PList<I>> provider(PDescriptorProvider itemDesc) {
        return PList.provider(itemDesc, DefaultBuilder::new);
    }

    @Nonnull
    public static <I> PContainerProvider<List<I>, PList<I>> provider(PDescriptorProvider itemDesc, IntFunction<Builder<I>> builderFactory) {
        return new PContainerProvider<List<I>, PList<I>>(new PList(itemDesc, builderFactory));
    }

    public static class DefaultBuilder<I>
    implements Builder<I> {
        private UnmodifiableList.Builder<I> builder;

        public DefaultBuilder() {
            this(10);
        }

        public DefaultBuilder(int capacity) {
            this.builder = UnmodifiableList.builder((int)capacity);
        }

        @Override
        @Nonnull
        public DefaultBuilder<I> add(@Nonnull I value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public DefaultBuilder<I> addAll(@Nonnull Collection<I> items) {
            this.builder.addAll(items);
            return this;
        }

        @Override
        @Nonnull
        public List<I> build() {
            return this.builder.build();
        }
    }

    public static interface Builder<I>
    extends PBuilder<List<I>> {
        @Nonnull
        public Builder<I> add(@Nonnull I var1);

        @Nonnull
        public Builder<I> addAll(@Nonnull Collection<I> var1);

        @Override
        @Nonnull
        public List<I> build();
    }
}

