/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.DefaultSerializerProvider;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class Any
implements PMessage<Any, _Field>,
Comparable<Any>,
Serializable,
BinaryWriter {
    private static final String kDefaultType = "";
    private static final String kDefaultMediaType = "application/vnd.apache.thrift.binary";
    private static final long serialVersionUID = -1774169565792574332L;
    private final transient String mType;
    private final transient String mMediaType;
    private final transient Binary mData;
    private final transient String mText;
    private volatile transient int tHashCode;
    private transient Any tSerializeInstance;
    public static final PStructDescriptor<Any, _Field> kDescriptor = new _Descriptor();

    private Any(_Builder builder) {
        this.mType = builder.isSetType() ? builder.mType : kDefaultType;
        this.mMediaType = builder.mMediaType;
        this.mData = builder.mData;
        this.mText = builder.mText;
    }

    public boolean hasType() {
        return true;
    }

    @Nonnull
    public String getType() {
        return this.mType;
    }

    public boolean hasMediaType() {
        return this.mMediaType != null;
    }

    public String getMediaType() {
        return this.hasMediaType() ? this.mMediaType : kDefaultMediaType;
    }

    @Nonnull
    public Optional<String> optionalMediaType() {
        return Optional.ofNullable(this.mMediaType);
    }

    public boolean hasData() {
        return this.mData != null;
    }

    public Binary getData() {
        return this.mData;
    }

    @Nonnull
    public Optional<Binary> optionalData() {
        return Optional.ofNullable(this.mData);
    }

    public boolean hasText() {
        return this.mText != null;
    }

    public String getText() {
        return this.mText;
    }

    @Nonnull
    public Optional<String> optionalText() {
        return Optional.ofNullable(this.mText);
    }

    @Override
    public boolean has(int key) {
        switch (key) {
            case 1: {
                return true;
            }
            case 2: {
                return this.mMediaType != null;
            }
            case 4: {
                return this.mData != null;
            }
            case 5: {
                return this.mText != null;
            }
        }
        return false;
    }

    @Override
    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)this.mType;
            }
            case 2: {
                return (T)this.mMediaType;
            }
            case 4: {
                return (T)this.mData;
            }
            case 5: {
                return (T)this.mText;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Any other = (Any)o;
        return Objects.equals(this.mType, other.mType) && Objects.equals(this.mMediaType, other.mMediaType) && Objects.equals(this.mData, other.mData) && Objects.equals(this.mText, other.mText);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(Any.class, _Field.TYPE, this.mType, _Field.MEDIA_TYPE, this.mMediaType, _Field.DATA, this.mData, _Field.TEXT, this.mText);
        }
        return this.tHashCode;
    }

    public String toString() {
        return "putil.Any" + this.asString();
    }

    @Override
    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        out.append("type:").append('\"').append(Strings.escape((CharSequence)this.mType)).append('\"');
        if (this.hasMediaType()) {
            out.append(',');
            out.append("media_type:").append('\"').append(Strings.escape((CharSequence)this.mMediaType)).append('\"');
        }
        if (this.hasData()) {
            out.append(',');
            out.append("data:").append("b64(").append(this.mData.toBase64()).append(')');
        }
        if (this.hasText()) {
            out.append(',');
            out.append("text:").append('\"').append(Strings.escape((CharSequence)this.mText)).append('\"');
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Any other) {
        int c = this.mType.compareTo(other.mType);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mMediaType != null, other.mMediaType != null);
        if (c != 0) {
            return c;
        }
        if (this.mMediaType != null && (c = this.mMediaType.compareTo(other.mMediaType)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mData != null, other.mData != null);
        if (c != 0) {
            return c;
        }
        if (this.mData != null && (c = this.mData.compareTo(other.mData)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mText != null, other.mText != null);
        if (c != 0) {
            return c;
        }
        if (this.mText != null && (c = this.mText.compareTo(other.mText)) != 0) {
            return c;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        BinarySerializer.INSTANCE.serialize((OutputStream)oos, this);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.tSerializeInstance = BinarySerializer.INSTANCE.deserialize((InputStream)ois, kDescriptor);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.tSerializeInstance;
    }

    public <M extends PMessage<M, F>, F extends PField> boolean wrappedTypeIs(@Nonnull PMessageDescriptor<M, F> descriptor) {
        return descriptor.getQualifiedName().equals(this.getType());
    }

    public <M extends PMessage<M, F>, F extends PField> M unwrapMessage(@Nonnull PMessageDescriptor<M, F> descriptor) {
        return this.unwrapMessage(descriptor, new DefaultSerializerProvider());
    }

    public <M extends PMessage<M, F>, F extends PField> M unwrapMessage(@Nonnull PMessageDescriptor<M, F> descriptor, @Nonnull SerializerProvider provider) {
        if (!descriptor.getQualifiedName().equals(this.getType())) {
            throw new IllegalStateException("Any type " + this.getType() + " does not match requested " + descriptor.getQualifiedName());
        }
        try {
            Serializer serializer = provider.getSerializer(this.getMediaType());
            if (this.hasData()) {
                return serializer.deserialize(this.getData().getInputStream(), descriptor);
            }
            if (this.hasText()) {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.getText().getBytes(StandardCharsets.UTF_8));
                return serializer.deserialize((InputStream)bais, descriptor);
            }
            throw new SerializerException("Neither data, nor text de deserialize.", new Object[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Override
    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        length += writer.writeByte((byte)11);
        length += writer.writeShort((short)1);
        Binary tmp_1 = Binary.wrap((byte[])this.mType.getBytes(StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_1.length());
        length += writer.writeBinary(tmp_1);
        if (this.hasMediaType()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)2);
            Binary tmp_2 = Binary.wrap((byte[])this.mMediaType.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }
        if (this.hasData()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)4);
            length += writer.writeUInt32(this.mData.length());
            length += writer.writeBinary(this.mData);
        }
        if (this.hasText()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)5);
            Binary tmp_3 = Binary.wrap((byte[])this.mText.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_3.length());
            length += writer.writeBinary(tmp_3);
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PStructDescriptorProvider<Any, _Field> provider() {
        return new _Provider();
    }

    @Override
    @Nonnull
    public PStructDescriptor<Any, _Field> descriptor() {
        return kDescriptor;
    }

    public static <M extends PMessage<M, F>, F extends PField> Any wrapMessage(@Nonnull M message) {
        return Any.wrapMessage(message, new BinarySerializer());
    }

    public static <M extends PMessage<M, F>, F extends PField> Any wrapMessage(@Nonnull M message, @Nonnull Serializer serializer) {
        try {
            _Builder builder = Any.builder();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            serializer.serialize((OutputStream)baos, message);
            if (serializer.binaryProtocol()) {
                builder.setData(Binary.wrap((byte[])baos.toByteArray()));
            } else {
                builder.setText(new String(baos.toByteArray(), StandardCharsets.UTF_8));
            }
            builder.setType(message.descriptor().getQualifiedName());
            builder.setMediaType(serializer.mediaType());
            return builder.build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<Any, _Field>
    implements BinaryReader {
        private BitSet optionals = new BitSet(4);
        private BitSet modified = new BitSet(4);
        private String mType = "";
        private String mMediaType;
        private Binary mData;
        private String mText;

        public _Builder() {
        }

        public _Builder(Any base) {
            this();
            this.optionals.set(0);
            this.mType = base.mType;
            if (base.hasMediaType()) {
                this.optionals.set(1);
                this.mMediaType = base.mMediaType;
            }
            if (base.hasData()) {
                this.optionals.set(2);
                this.mData = base.mData;
            }
            if (base.hasText()) {
                this.optionals.set(3);
                this.mText = base.mText;
            }
        }

        @Nonnull
        public _Builder merge(Any from) {
            this.optionals.set(0);
            this.modified.set(0);
            this.mType = from.getType();
            if (from.hasMediaType()) {
                this.optionals.set(1);
                this.modified.set(1);
                this.mMediaType = from.getMediaType();
            }
            if (from.hasData()) {
                this.optionals.set(2);
                this.modified.set(2);
                this.mData = from.getData();
            }
            if (from.hasText()) {
                this.optionals.set(3);
                this.modified.set(3);
                this.mText = from.getText();
            }
            return this;
        }

        @Nonnull
        public _Builder setType(String value) {
            if (value == null) {
                return this.clearType();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mType = value;
            return this;
        }

        public boolean isSetType() {
            return this.optionals.get(0);
        }

        public boolean isModifiedType() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearType() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mType = Any.kDefaultType;
            return this;
        }

        public String getType() {
            return this.mType;
        }

        @Nonnull
        public _Builder setMediaType(String value) {
            if (value == null) {
                return this.clearMediaType();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mMediaType = value;
            return this;
        }

        public boolean isSetMediaType() {
            return this.optionals.get(1);
        }

        public boolean isModifiedMediaType() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearMediaType() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mMediaType = null;
            return this;
        }

        public String getMediaType() {
            return this.isSetMediaType() ? this.mMediaType : Any.kDefaultMediaType;
        }

        @Nonnull
        public _Builder setData(Binary value) {
            if (value == null) {
                return this.clearData();
            }
            this.optionals.set(2);
            this.modified.set(2);
            this.mData = value;
            return this;
        }

        public boolean isSetData() {
            return this.optionals.get(2);
        }

        public boolean isModifiedData() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearData() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mData = null;
            return this;
        }

        public Binary getData() {
            return this.mData;
        }

        @Nonnull
        public _Builder setText(String value) {
            if (value == null) {
                return this.clearText();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mText = value;
            return this;
        }

        public boolean isSetText() {
            return this.optionals.get(3);
        }

        public boolean isModifiedText() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearText() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mText = null;
            return this;
        }

        public String getText() {
            return this.mText;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            _Builder other = (_Builder)o;
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mType, other.mType) && Objects.equals(this.mMediaType, other.mMediaType) && Objects.equals(this.mData, other.mData) && Objects.equals(this.mText, other.mText);
        }

        public int hashCode() {
            return Objects.hash(Any.class, this.optionals, _Field.TYPE, this.mType, _Field.MEDIA_TYPE, this.mMediaType, _Field.DATA, this.mData, _Field.TEXT, this.mText);
        }

        @Override
        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setType((String)value);
                    break;
                }
                case 2: {
                    this.setMediaType((String)value);
                    break;
                }
                case 4: {
                    this.setData((Binary)value);
                    break;
                }
                case 5: {
                    this.setText((String)value);
                    break;
                }
            }
            return this;
        }

        @Override
        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 4: {
                    return this.optionals.get(2);
                }
                case 5: {
                    return this.optionals.get(3);
                }
            }
            return false;
        }

        @Override
        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 4: {
                    return this.modified.get(2);
                }
                case 5: {
                    return this.modified.get(3);
                }
            }
            return false;
        }

        @Nonnull
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearType();
                    break;
                }
                case 2: {
                    this.clearMediaType();
                    break;
                }
                case 4: {
                    this.clearData();
                    break;
                }
                case 5: {
                    this.clearText();
                    break;
                }
            }
            return this;
        }

        @Override
        public boolean valid() {
            return this.optionals.get(0);
        }

        @Override
        public void validate() {
            if (!this.valid()) {
                ArrayList<String> missing = new ArrayList<String>();
                if (!this.optionals.get(0)) {
                    missing.add("type");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message putil.Any");
            }
        }

        @Override
        @Nonnull
        public PStructDescriptor<Any, _Field> descriptor() {
            return kDescriptor;
        }

        @Override
        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mType = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString(type) + " for putil.Any.type, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mMediaType = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString(type) + " for putil.Any.media_type, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 11) {
                            int len_3 = reader.expectUInt32();
                            this.mData = reader.expectBinary(len_3);
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString(type) + " for putil.Any.data, should be struct(12)", new Object[0]);
                    }
                    case 5: {
                        if (type == 11) {
                            int len_4 = reader.expectUInt32();
                            this.mText = new String(reader.expectBytes(len_4), StandardCharsets.UTF_8);
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString(type) + " for putil.Any.text, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue(reader, new BinaryFormatUtils.FieldInfo(field, type), null, false);
                    }
                }
                type = reader.expectByte();
            }
        }

        @Override
        public Any build() {
            return new Any(this);
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<Any, _Field> {
        private _Provider() {
        }

        @Override
        public PStructDescriptor<Any, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<Any, _Field> {
        public _Descriptor() {
            super("putil", "Any", _Builder::new, true);
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Override
        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField
    {
        TYPE(1, PRequirement.REQUIRED, "type", PPrimitive.STRING.provider(), null),
        MEDIA_TYPE(2, PRequirement.OPTIONAL, "media_type", PPrimitive.STRING.provider(), new PDefaultValueProvider<String>("application/vnd.apache.thrift.binary")),
        DATA(4, PRequirement.OPTIONAL, "data", PPrimitive.BINARY.provider(), null),
        TEXT(5, PRequirement.OPTIONAL, "text", PPrimitive.STRING.provider(), null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        @Override
        public int getId() {
            return this.mId;
        }

        @Override
        public PRequirement getRequirement() {
            return this.mRequired;
        }

        @Override
        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        @Override
        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.asString(this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return TYPE;
                }
                case 2: {
                    return MEDIA_TYPE;
                }
                case 4: {
                    return DATA;
                }
                case 5: {
                    return TEXT;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            switch (name) {
                case "type": {
                    return TYPE;
                }
                case "media_type": {
                    return MEDIA_TYPE;
                }
                case "data": {
                    return DATA;
                }
                case "text": {
                    return TEXT;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in putil.Any");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in putil.Any");
            }
            return field;
        }
    }
}

