/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer.pretty;

import java.io.File;
import java.util.Locale;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.util.Strings;

public class TokenizerException
extends SerializerException {
    private static final long serialVersionUID = 1513434504497049610L;
    private int lineNo;
    private int linePos;
    private String line;
    private String file;
    private int length;

    public TokenizerException(TokenizerException e, File file) {
        super(e.getMessage(), new Object[0]);
        this.initCause(e);
        this.setLine(e.getLine());
        this.setLineNo(e.getLineNo());
        this.setLinePos(e.getLinePos());
        this.setLength(e.getLength());
        if (e.getFile() == null && file != null) {
            this.setFile(file.getName());
        } else {
            this.setFile(e.getFile());
        }
    }

    public TokenizerException(String format, Object ... args) {
        super(format, args);
    }

    public TokenizerException(Throwable cause, String format, Object ... args) {
        super(cause, format, args);
    }

    public TokenizerException(Token token, String format, Object ... args) {
        super(format, args);
        this.setLinePos(token.getLinePos());
        this.setLineNo(token.getLineNo());
        this.setLength(token.toString().length());
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getLinePos() {
        return this.linePos;
    }

    public int getLength() {
        return this.length;
    }

    public String getLine() {
        return this.line;
    }

    public String getFile() {
        return this.file;
    }

    public TokenizerException setLineNo(int lineNo) {
        this.lineNo = lineNo;
        return this;
    }

    public TokenizerException setLinePos(int linePos) {
        this.linePos = linePos;
        return this;
    }

    public TokenizerException setLength(int len) {
        this.length = len;
        return this;
    }

    public TokenizerException setLine(String line) {
        this.line = line;
        return this;
    }

    public TokenizerException setFile(String file) {
        this.file = file;
        return this;
    }

    @Override
    public TokenizerException initCause(Throwable cause) {
        return (TokenizerException)super.initCause(cause);
    }

    @Override
    public String asString() {
        if (this.lineNo > 0) {
            String fileSpec = "";
            if (this.file != null) {
                fileSpec = " in " + this.file;
            }
            if (this.line != null) {
                return String.format(Locale.US, "Error%s on line %d, pos %d: %s%n%s%n%s%s", fileSpec, this.getLineNo(), this.getLinePos(), this.getMessage(), this.getLine(), Strings.times((String)"-", (int)(this.linePos - 1)), Strings.times((String)"^", (int)Math.max(1, this.length)));
            }
            return String.format(Locale.US, "Error%s on line %d, pos %d: %s", fileSpec, this.getLineNo(), this.getLinePos(), this.getMessage());
        }
        if (this.file != null) {
            return String.format(Locale.US, "Error in %s: %s", this.file, this.getMessage());
        }
        return String.format(Locale.US, "Error: %s", this.getMessage());
    }

    @Override
    public String toString() {
        StringBuilder helper = new StringBuilder().append(this.getClass().getSimpleName()).append("{").append(this.getMessage());
        if (this.file != null) {
            helper.append(", file=").append(this.file);
        }
        if (this.getExceptionType() != PApplicationExceptionType.PROTOCOL_ERROR) {
            helper.append(", e=").append(this.getExceptionType());
        }
        if (Strings.isNotEmpty((String)this.getLine())) {
            helper.append(", line=").append(this.lineNo);
            helper.append(", pos=").append(this.linePos);
            helper.append(", len=").append(this.length);
        }
        if (Strings.isNotEmpty((String)this.getMethodName())) {
            helper.append(", method=").append(this.getMethodName());
            helper.append(", type=").append(this.getCallType());
            helper.append(", seq=").append(this.getSequenceNo());
        }
        return helper.append("}").toString();
    }
}

