/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.util.Locale;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Strings;
import net.morimekta.util.json.JsonException;

public class JsonSerializerException
extends SerializerException {
    private static final long serialVersionUID = 1493883783445793582L;

    public JsonSerializerException(@Nonnull JsonException e) {
        super(e, e.getMessage(), new Object[0]);
    }

    @Override
    @Nonnull
    public synchronized JsonException getCause() {
        return (JsonException)super.getCause();
    }

    public String getLine() {
        return this.getCause().getLine();
    }

    public int getLineNo() {
        return this.getCause().getLineNo();
    }

    public int getLinePos() {
        return this.getCause().getLinePos();
    }

    public int getLen() {
        return this.getCause().getLen();
    }

    @Override
    public synchronized Throwable initCause(Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        StringBuilder tsh = new StringBuilder().append(this.getClass().getSimpleName()).append("{").append(this.getMessage());
        if (this.getExceptionType() != PApplicationExceptionType.PROTOCOL_ERROR) {
            tsh.append(", e=").append(this.getExceptionType());
        }
        if (Strings.isNotEmpty((String)this.getLine())) {
            tsh.append(", line=").append(this.getLineNo()).append(", pos=").append(this.getLinePos());
        }
        if (Strings.isNotEmpty((String)this.getMethodName())) {
            tsh.append(", method=").append(this.getMethodName()).append(", type=").append(this.getCallType()).append(", seq=").append(this.getSequenceNo());
        }
        return tsh.append("}").toString();
    }

    @Override
    public String asString() {
        if (this.getLine() != null) {
            return String.format(Locale.US, "JSON Error%s on line %d: %s%n%s%n%s%s", this.getMethodName().isEmpty() ? "" : " in " + this.getMethodName(), this.getLineNo(), this.getLocalizedMessage(), this.getLine(), Strings.times((String)"-", (int)(this.getLinePos() - 1)), Strings.times((String)"^", (int)this.getLen()));
        }
        return String.format(Locale.US, "JSON Error: %s", this.getLocalizedMessage());
    }
}

