/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer.pretty;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.TokenizerException;
import net.morimekta.util.Strings;
import net.morimekta.util.io.LineBufferedReader;
import net.morimekta.util.io.Utf8StreamReader;

public class Tokenizer
extends LineBufferedReader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    private Token lastToken;
    private Token unreadToken = null;

    public Tokenizer(InputStream in) {
        this(in, 2048);
    }

    public Tokenizer(InputStream in, int bufferSize) {
        this((Reader)new Utf8StreamReader(in), bufferSize, false);
    }

    public Tokenizer(Reader in, int bufferSize, boolean preLoadAll) {
        super(in, bufferSize, preLoadAll);
    }

    @Nonnull
    public Token expect(@Nonnull String expected) throws IOException {
        if (!this.hasNext()) {
            throw this.eof("Expected %s: Got end of file", expected);
        }
        this.lastToken = this.unreadToken;
        this.unreadToken = null;
        return this.lastToken;
    }

    public Token expect(@Nonnull String expected, @Nonnull TokenValidator validator) throws IOException {
        if (!this.hasNext()) {
            throw this.eof("Expected %s, got end of file", expected);
        }
        if (validator.validate(this.unreadToken)) {
            this.lastToken = this.unreadToken;
            this.unreadToken = null;
            return this.lastToken;
        }
        throw this.failure(this.unreadToken, "Expected %s, but got '%s'", expected, Strings.escape((CharSequence)((Object)this.unreadToken)));
    }

    public char expectSymbol(@Nonnull String expected, char ... symbols) throws IOException {
        if (symbols.length == 0) {
            throw new IllegalArgumentException("No symbols to match.");
        }
        if (!this.hasNext()) {
            if (symbols.length == 1) {
                throw this.eof("Expected %s ('%c'), Got end of file", expected, Character.valueOf(symbols[0]));
            }
            throw this.eof("Expected %s (one of ['%s']): Got end of file", expected, Strings.joinP((String)"', '", (char[])symbols));
        }
        for (char symbol : symbols) {
            if (!this.unreadToken.isSymbol(symbol)) continue;
            this.lastToken = this.unreadToken;
            this.unreadToken = null;
            return symbol;
        }
        if (symbols.length == 1) {
            throw this.failure(this.getLineNo(), this.getLinePos(), 1, "Expected %s ('%c'): but found '%s'", new Object[]{expected, Character.valueOf(symbols[0]), this.unreadToken});
        }
        throw this.failure(this.getLineNo(), this.getLinePos(), 1, "Expected %s (one of ['%s']): but found '%s'", new Object[]{expected, Strings.joinP((String)"', '", (char[])symbols), this.unreadToken});
    }

    public Token expectIdentifier(@Nonnull String message) throws IOException {
        return this.expect(message, Token::isIdentifier);
    }

    @Nonnull
    public Token expectInteger(String message) throws IOException {
        return this.expect(message, Token::isInteger);
    }

    @Nonnull
    public Token expectLiteral(String message) throws IOException {
        return this.expect(message, Token::isStringLiteral);
    }

    public boolean hasNext() throws IOException {
        if (this.unreadToken == null) {
            this.unreadToken = this.next();
        }
        return this.unreadToken != null;
    }

    public Token getLastToken() {
        return this.lastToken;
    }

    public String readBinary(char end) throws IOException {
        int startOffset = this.bufferOffset;
        int startLinePos = this.linePos;
        CharArrayWriter baos = new CharArrayWriter();
        while (this.readNextChar()) {
            if (this.lastChar == end) {
                this.lastChar = 0;
                return baos.toString();
            }
            if (this.lastChar == 32 || this.lastChar == 9 || this.lastChar == 13 || this.lastChar == 10) {
                throw this.failure(this.getLineNo(), startLinePos, startOffset, "Illegal char '%s' in binary", Strings.escape((char)((char)this.lastChar)));
            }
            baos.write(this.lastChar);
        }
        throw this.eof("Unexpected end of file in binary", new Object[0]);
    }

    public Token peek() throws IOException {
        this.hasNext();
        return this.unreadToken;
    }

    @Nonnull
    public Token peek(String message) throws IOException {
        if (!this.hasNext()) {
            throw this.failure(this.lineNo, this.linePos + 1, 0, "Expected %s: Got end of file", message);
        }
        return this.unreadToken;
    }

    @Nullable
    public Token next() throws IOException {
        if (this.unreadToken != null) {
            this.lastToken = this.unreadToken;
            this.unreadToken = null;
            return this.lastToken;
        }
        while (this.lastChar >= 0 && (this.lastChar != 0 || this.readNextChar())) {
            if (this.lastChar == 10 || this.lastChar == 13 || this.lastChar == 32 || this.lastChar == 9) {
                this.lastChar = 0;
                continue;
            }
            if (this.lastChar == 35) {
                this.getRestOfLine();
                continue;
            }
            if (this.lastChar == 34 || this.lastChar == 39) {
                this.lastToken = this.nextStringLiteral((char)this.lastChar);
                return this.lastToken;
            }
            if (this.lastChar == 46 || this.lastChar == 45 || this.lastChar >= 48 && this.lastChar <= 57) {
                this.lastToken = this.nextNumber();
                return this.lastToken;
            }
            if (95 == this.lastChar || 97 <= this.lastChar && this.lastChar <= 122 || 65 <= this.lastChar && this.lastChar <= 90) {
                this.lastToken = this.nextToken();
                return this.lastToken;
            }
            if (this.lastChar < 32 || this.lastChar >= 127) {
                throw this.failure(this.lineNo, this.linePos, 1, "Unknown token initiator '%s'", Strings.escape((char)((char)this.lastChar)));
            }
            this.lastToken = this.nextSymbol();
            return this.lastToken;
        }
        return null;
    }

    @Nonnull
    protected Token nextSymbol() throws IOException {
        this.lastChar = 0;
        return new Token(this.buffer, this.bufferOffset, 1, this.lineNo, this.linePos);
    }

    @Nonnull
    private Token nextToken() throws IOException {
        this.maybeConsolidateBuffer();
        int startPos = this.linePos;
        int startOffset = this.bufferOffset;
        int startLine = this.lineNo;
        int len = 0;
        int lastLast = 0;
        while (this.lastChar == 95 || this.lastChar == 46 || this.lastChar >= 48 && this.lastChar <= 57 || this.lastChar >= 97 && this.lastChar <= 122 || this.lastChar >= 65 && this.lastChar <= 90) {
            if (this.lastChar == 46 && lastLast == 46) {
                throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset + 1, "Identifier with double '.'", new Object[0]);
            }
            if (lastLast == 46 && 48 <= this.lastChar && this.lastChar <= 57) {
                throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset + 1, "Identifier part starting with digit '%c'", this.lastChar);
            }
            lastLast = this.lastChar;
            ++len;
            if (this.readNextChar()) continue;
        }
        if (lastLast == 46) {
            throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset, "Identifier with trailing '.'", new Object[0]);
        }
        return new Token(this.buffer, startOffset, len, startLine, startPos);
    }

    @Nonnull
    private Token nextNumber() throws IOException {
        this.maybeConsolidateBuffer();
        int startPos = this.linePos;
        int startOffset = this.bufferOffset;
        int len = 0;
        if (this.lastChar == 45) {
            ++len;
            if (!this.readNextChar()) {
                throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset, "Negative indicator without number", new Object[0]);
            }
            if (this.lastChar != 46 && (this.lastChar < 48 || this.lastChar > 57)) {
                throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset, "No decimal after negative indicator", new Object[0]);
            }
        } else if (this.lastChar == 48) {
            if (this.readNextChar()) {
                ++len;
                if (this.lastChar == 120) {
                    ++len;
                    if (!this.readNextChar()) {
                        throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset + 1, "No decimal after hex indicator", new Object[0]);
                    }
                    while (this.lastChar >= 48 && this.lastChar <= 57 || this.lastChar >= 97 && this.lastChar <= 102 || this.lastChar >= 65 && this.lastChar <= 70) {
                        ++len;
                        if (this.readNextChar()) continue;
                    }
                    return this.validateAfterNumber(startOffset, startPos, len);
                }
                if (48 <= this.lastChar && this.lastChar <= 55) {
                    ++len;
                    while (this.readNextChar() && this.lastChar >= 48 && this.lastChar <= 55) {
                        ++len;
                    }
                    return this.validateAfterNumber(startOffset, startPos, len);
                }
            } else {
                return this.validateAfterNumber(startOffset, startPos, 1);
            }
        }
        while (this.lastChar >= 48 && this.lastChar <= 57) {
            ++len;
            if (this.readNextChar()) continue;
        }
        if (this.lastChar == 46) {
            ++len;
            if (this.readNextChar()) {
                while (this.lastChar >= 48 && this.lastChar <= 57) {
                    ++len;
                    if (this.readNextChar()) continue;
                }
            }
        }
        if (this.lastChar == 101 || this.lastChar == 69) {
            ++len;
            if (!this.readNextChar()) {
                String tmp = new String(this.buffer, startOffset, len);
                throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset + 1, "Badly terminated number exponent: '%s'", tmp);
            }
            if (this.lastChar == 45 || this.lastChar == 43) {
                ++len;
                if (!this.readNextChar()) {
                    String tmp = new String(this.buffer, startOffset, len);
                    throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset + 1, "Badly terminated number exponent: '%s'", tmp);
                }
            }
            if (this.lastChar >= 48 && this.lastChar <= 57) {
                while (this.lastChar >= 48 && this.lastChar <= 57) {
                    ++len;
                    if (this.readNextChar()) continue;
                    break;
                }
            } else {
                if (this.lastChar > 0) {
                    String tmp = new String(this.buffer, startOffset, len + 1);
                    throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset + 1, "Badly terminated number exponent: '%s'", tmp);
                }
                String tmp = new String(this.buffer, startOffset, len + 1);
                throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset, "Badly terminated number exponent: '%s'", tmp);
            }
        }
        return this.validateAfterNumber(startOffset, startPos, len);
    }

    private Token validateAfterNumber(int startOffset, int startLinePos, int len) throws TokenizerException {
        if (this.lastChar == 95 || this.lastChar >= 97 && this.lastChar <= 122 || this.lastChar >= 65 && this.lastChar <= 90) {
            String tmp = new String(this.buffer, startOffset, len + 1);
            throw this.failure(this.lineNo, startLinePos, this.bufferOffset - startOffset + 1, "Invalid termination of number: '%s'", tmp);
        }
        return new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
    }

    @Nonnull
    private Token nextStringLiteral(char quote) throws IOException {
        int startOffset;
        int startPos;
        StringBuilder consolidatedString;
        block8: {
            this.maybeConsolidateBuffer();
            consolidatedString = null;
            startPos = this.linePos;
            startOffset = this.bufferOffset;
            boolean esc = false;
            while (true) {
                if (!this.preLoaded && this.bufferOffset >= this.bufferLimit - 1) {
                    if (consolidatedString == null) {
                        consolidatedString = new StringBuilder();
                    }
                    consolidatedString.append(this.buffer, startOffset, this.bufferOffset - startOffset + 1);
                    startOffset = 0;
                }
                if (!this.readNextChar()) {
                    throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset + 1, "Unexpected end of stream in string literal", new Object[0]);
                }
                if (esc) {
                    esc = false;
                    continue;
                }
                if (this.lastChar == 92) {
                    esc = true;
                    continue;
                }
                if (this.lastChar == quote) break block8;
                if (this.lastChar == 10) {
                    throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset, "Unexpected newline in string literal", new Object[0]);
                }
                if (this.lastChar < 32 || this.lastChar == 127 || this.lastChar > 127 && !Strings.isConsolePrintable((int)this.lastChar)) break;
            }
            throw this.failure(this.lineNo, startPos, this.bufferOffset - startOffset + 1, "Unescaped non-printable char in literal: '%s'", Strings.escape((char)((char)this.lastChar)));
        }
        this.lastChar = 0;
        if (consolidatedString != null) {
            consolidatedString.append(this.buffer, 0, this.bufferOffset + 1);
            String result = consolidatedString.toString();
            return new Token(result.toCharArray(), 0, result.length(), this.lineNo, startPos);
        }
        return new Token(this.buffer, startOffset, this.bufferOffset - startOffset + 1, this.lineNo, startPos);
    }

    @Nonnull
    public TokenizerException failure(Token token, String message, Object ... params) {
        return this.failure(token.getLineNo(), token.getLinePos(), token.length(), message, params);
    }

    @Nonnull
    protected final TokenizerException failure(int startLineNo, int startLinePos, int length, String format, Object ... params) {
        return this.failure(format, params).setLineNo(startLineNo).setLinePos(startLinePos).setLine(this.getLine()).setLength(length);
    }

    @Nonnull
    protected final TokenizerException eof(String format, Object ... params) {
        return this.failure(format, params).setLinePos(this.getLinePos() + 1).setLength(1).setLineNo(this.getLineNo()).setLine(this.getLine());
    }

    @Nonnull
    protected TokenizerException failure(String format, Object ... params) {
        return new TokenizerException(format, params);
    }

    @FunctionalInterface
    public static interface TokenValidator {
        public boolean validate(Token var1);
    }
}

