/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.IOException;
import java.util.Locale;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.util.Stringable;

public class SerializerException
extends IOException
implements Stringable {
    private static final long serialVersionUID = 1442914425369642982L;
    private String methodName;
    private PServiceCallType callType;
    private int sequenceNo;
    private PApplicationExceptionType exceptionType;

    public SerializerException(String format, Object ... args) {
        super(args.length == 0 ? format : String.format(Locale.US, format, args));
        this.exceptionType = PApplicationExceptionType.PROTOCOL_ERROR;
    }

    public SerializerException(Throwable cause, String format, Object ... args) {
        super(args.length == 0 ? format : String.format(Locale.US, format, args), cause);
        this.exceptionType = PApplicationExceptionType.PROTOCOL_ERROR;
    }

    public SerializerException(SerializerException cause) {
        super(cause.getMessage(), cause);
        this.setCallType(cause.getCallType());
        this.setMethodName(cause.getMethodName());
        this.setSequenceNo(cause.getSequenceNo());
        this.setExceptionType(cause.getExceptionType());
    }

    public String getMethodName() {
        return this.methodName == null ? "" : this.methodName;
    }

    public PServiceCallType getCallType() {
        return this.callType;
    }

    public int getSequenceNo() {
        return this.sequenceNo;
    }

    public PApplicationExceptionType getExceptionType() {
        return this.exceptionType;
    }

    public SerializerException setMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public SerializerException setCallType(PServiceCallType callType) {
        this.callType = callType;
        return this;
    }

    public SerializerException setSequenceNo(int sequenceNo) {
        this.sequenceNo = sequenceNo;
        return this;
    }

    public SerializerException setExceptionType(PApplicationExceptionType type) {
        this.exceptionType = type;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(16).append(this.getClass().getSimpleName()).append("{").append(this.getMessage());
        if (this.methodName != null) {
            builder.append(", method=").append(this.methodName);
        }
        if (this.callType != null) {
            builder.append(", type=").append(this.callType);
        }
        if (this.methodName != null) {
            builder.append(", seq=").append(this.sequenceNo);
        }
        if (this.exceptionType != null) {
            builder.append(", exception=").append(this.exceptionType);
        }
        return builder.append("}").toString();
    }

    public String asString() {
        if (this.methodName != null) {
            return "Error in " + this.methodName + "(): " + this.getMessage();
        }
        return "Error: " + this.getMessage();
    }
}

